<?php

/**
 * This is the model class for table "job_artwork_logo_archives".
 *
 * The followings are the available columns in table 'job_artwork_logo_archives':
 * @property integer $id
 * @property integer $job_artowk_id
 * @property string $logoImage
 * @property string $createdDate
 * @property bool $customer_accepted
 */
class ArtworkLogoArchive extends CActiveRecord
{

	const STATUS_CUSTOMER_ACCEPTED = 1;
	const STATUS_CUSTOMER_REJECTED = 2;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ArtworkLogoArchive the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_artwork_logo_archives';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			//array('id', 'required'),
			array('id, job_artowk_id, customer_accepted', 'numerical', 'integerOnly' => true),
			array('logoImage', 'length', 'max' => 255),
			array('createdDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_artowk_id, logoImage, createdDate', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'artworkjob' => array(self::BELONGS_TO, 'JobArtwork', 'job_artowk_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_artowk_id' => 'Job Artowk',
			'logoImage' => 'Logo Image',
			'createdDate' => 'Created Date',
			'customer_accepted' => 'Customer Accepted'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('job_artowk_id', $this->job_artowk_id);
		$criteria->compare('logoImage', $this->logoImage, true);
		$criteria->compare('createdDate', $this->createdDate, true);

		$criteria->order = 'createdDate desc';

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	public function getStatus()
	{
		switch ($this->customer_accepted) {
			case ArtworkLogoArchive::STATUS_CUSTOMER_ACCEPTED:
				return 'Accepted';
			case ArtworkLogoArchive::STATUS_CUSTOMER_REJECTED:
				return 'Rejected';
			default:
				return '';
		}
	}
}
