<?php

/**
 * This is the model class for table "branch".
 *
 * The followings are the available columns in table 'branch':
 * @property integer $id
 * @property string $name
 * @property string $code
 * @property string $address1
 * @property string $district
 * @property string $email
 * @property integer $telephone
 * @property integer $fax
 * @property integer $country_id
 * @property integer $currency_id
 * @property integer $user_id
 * @property string $createddate
 */
class Branch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Branch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'branch';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name, code, country_id, currency_id, user_id', 'required'),
			array('id, telephone, fax, country_id, currency_id, user_id', 'numerical', 'integerOnly'=>true),
			array('name, address1', 'length', 'max'=>255),
			array('code', 'length', 'max'=>10),
			array('district, email', 'length', 'max'=>50),
			array('createddate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, name, code, address1, district, email, telephone, fax, country_id, currency_id, user_id, createddate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'name' => 'Name',
			'code' => 'Code',
			'address1' => 'Address1',
			'district' => 'District',
			'email' => 'Email',
			'telephone' => 'Telephone',
			'fax' => 'Fax',
			'country_id' => 'Country',
			'currency_id' => 'Currency',
			'user_id' => 'User',
			'createddate' => 'Createddate',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('district',$this->district,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('telephone',$this->telephone);
		$criteria->compare('fax',$this->fax);
		$criteria->compare('country_id',$this->country_id);
		$criteria->compare('currency_id',$this->currency_id);
		$criteria->compare('user_id',$this->user_id);
		$criteria->compare('createddate',$this->createddate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}