<?php

/**
 * This is the model class for table "consolidated_po_details".
 *
 * The followings are the available columns in table 'consolidated_po_details':
 * @property integer $id
 * @property integer $consolidated_po_id
 * @property integer $child_po_id
 * @property integer $job_id
 * @property integer $child_po_dtl_id
 * @property integer $detail_added_by
 * @property string $details_added_date
 */
class ConsolidatedPoDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ConsolidatedPoDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'consolidated_po_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id', 'required'),
			array('id, consolidated_po_id, child_po_id, job_id, child_po_dtl_id, detail_added_by', 'numerical', 'integerOnly'=>true),
			array('details_added_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, consolidated_po_id, child_po_id, job_id, child_po_dtl_id, detail_added_by, details_added_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
        
        
        public function rel_master_po() {
            return ConsolidatedPurchaseOrder::model()->findByPk($this->consolidated_po_id);
        }
        
        public function rel_po() {
            return PurchaseOrders::model()->findByPk($this->child_po_id);
        }
        
        public function rel_po_detail() {
            return PurchaseOrderDetails::model()->findByPk($this->child_po_dtl_id);
        }
        

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'consolidated_po_id' => 'Consolidated Po',
			'child_po_id' => 'Child Po',
			'job_id' => 'Job',
			'child_po_dtl_id' => 'Child Po Dtl',
			'detail_added_by' => 'Detail Added By',
			'details_added_date' => 'Details Added Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('consolidated_po_id',$this->consolidated_po_id);
		$criteria->compare('child_po_id',$this->child_po_id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('child_po_dtl_id',$this->child_po_dtl_id);
		$criteria->compare('detail_added_by',$this->detail_added_by);
		$criteria->compare('details_added_date',$this->details_added_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}