<?php

/**
 * This is the model class for table "consolidated_po_details".
 *
 * The followings are the available columns in table 'consolidated_po_details':
 * @property integer $id
 * @property integer $consolidated_po_id
 * @property integer $child_po_id
 * @property integer $job_id
 * @property integer $child_po_dtl_id
 * @property integer $detail_added_by
 * @property string $details_added_date
 */
class ConsolidatedPoDetail extends CActiveRecord
{

	/**
	 * Master PO Summary related fields
	 */

	public $created_date;
	public $datefrom;
	public $dateto;
	public $masterPONumber;
	public $subPONumber;
	public $groupID;
	public $productCode;
	public $productName;
	public $prodQty;
	public $size;
	public $color;
	public $qty;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ConsolidatedPoDetail the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'consolidated_po_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id', 'required'),
			array('groupID, prodQty, qty', 'numerical', 'integerOnly' => true),
			array('masterPONumber, subPONumber, productCode, productName, size, color', 'length', 'max' => 255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, consolidated_po_id, child_po_id, job_id, child_po_dtl_id, detail_added_by, details_added_date', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array();
	}


	public function rel_master_po()
	{
		return ConsolidatedPurchaseOrder::model()->findByPk($this->consolidated_po_id);
	}

	public function rel_po()
	{
		return PurchaseOrders::model()->findByPk($this->child_po_id);
	}

	public function rel_po_detail()
	{
		return PurchaseOrderDetails::model()->findByPk($this->child_po_dtl_id);
	}


	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'consolidated_po_id' => 'Consolidated Po',
			'child_po_id' => 'Child Po',
			'job_id' => 'Job',
			'child_po_dtl_id' => 'Child Po Dtl',
			'detail_added_by' => 'Detail Added By',
			'details_added_date' => 'Details Added Date',

			'datefrom' => 'Date From',
			'dateto' => 'Date To',
			'masterPONumber' => 'Mater PO Number',
			'subPONumber' => 'Sub PO Number',
			'groupID' => 'Group ID',
			'productCode' => 'Product Code',
			'productName' => 'Product Name',
			'prodQty' => 'Item Quantity',
			'size' => 'Size',
			'color' => 'Colour',
			'qty' => 'Quantity',
			'created_date' => 'Created At'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function searchMasterPOSummary()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;
		$criteria->select = '*,cpo.po_number as masterPONumber, cpo.created_date, po.poNum as subPONumber, podt.id as groupID,  wd.productsku as productCode, 
								wd.prdsrtdesc as productName, wd.prodQty, wdqtybrk.size, wdqtybrk.qty, wdqtybrk.color';
		$criteria->alias = 'cpodt';
		$criteria->join = '	LEFT JOIN consolidated_purchase_orders cpo ON cpodt.`consolidated_po_id` = cpo.id 
							LEFT JOIN purchase_order_details podt ON cpodt.`child_po_dtl_id` = podt.id 
							LEFT JOIN purchase_orders po ON podt.po_id = po.id 
							LEFT JOIN workorderdetails wd ON podt.workorderDtl_id = wd.id 
							LEFT JOIN workorderdetailssizecolor wdqtybrk ON podt.workorderDtl_id = wdqtybrk.workOrderDetailsId';

		$criteria->compare('po_number', $this->masterPONumber, true);
		$criteria->compare('poNum', $this->subPONumber, true);
		$criteria->compare('podt.id', $this->groupID);
		$criteria->compare('productsku', $this->productCode);
		$criteria->compare('prdsrtdesc', $this->productName, true);
		$criteria->compare('prodQty', $this->prodQty);
		$criteria->compare('size', $this->size, true);
		$criteria->compare('qty', $this->qty, true);
		$criteria->compare('color', $this->color, true);


		if (!empty($this->datefrom) && empty($this->dateto)) {
			
			$criteria->addCondition("DATE_FORMAT(cpo.created_date, '%Y-%m-%d') >= '" . $this->datefrom . "'");
			
		} else if (empty($this->datefrom) && !empty($this->dateto)) {
			
			$criteria->addCondition("DATE_FORMAT(cpo.created_date, '%Y-%m-%d') <= '" . $this->dateto . "'");
			
		} else if (!empty($this->datefrom) && !empty($this->dateto)) {
			
			$criteria->addCondition("DATE_FORMAT(cpo.created_date, '%Y-%m-%d') between '".$this->datefrom."' and '" . $this->dateto . "'");
			
		}

		if (isset(Yii::app()->session['m_po_summary_query'])) {
            unset(Yii::app()->session['m_po_summary_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        $paramarr = array('podt.id=:' => $this->groupID, ':dateFrom' => $this->datefrom, ':dateTo' => $this->dateto);

        $paramarrLike = array(
			'po_number LIKE :' => $this->masterPONumber, 'poNum LIKE :' => $this->subPONumber,
            'productsku LIKE :' => $this->productCode, 'prdsrtdesc LIKE :' => $this->productName,
            'prodQty LIKE :' => $this->prodQty, 'size LIKE :' => $this->size, 'qty LIKE :' => $this->qty,'color LIKE :' => $this->color
		);


        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }




        Yii::app()->session['m_po_summary_query'] = $originalQuery;

		

		$pageSize = 50;

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
				'defaultOrder' => 'masterPONumber ASC, groupID ASC',
			)
		));
	}
}
