<?php

/**
 * This is the model class for table "consolidated_purchase_orders".
 *
 * The followings are the available columns in table 'consolidated_purchase_orders':
 * @property integer $id
 * @property string $po_number
 * @property integer $supplier_id
 * @property string $po_type
 * @property string $comments
 * @property integer $status_id
 * @property string $due_date
 * @property string $created_date
 * @property integer $created_by
 */
class ConsolidatedPurchaseOrder extends CActiveRecord {

    /**
     * searching properties  
     */
    
    public $search_supplier;
    




    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return ConsolidatedPurchaseOrder the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'consolidated_purchase_orders';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('supplier_id, status_id, created_by', 'numerical', 'integerOnly' => true),
            array('po_number, po_type', 'length', 'max' => 45),
            array('comments', 'length', 'max' => 255),
            array('due_date, created_date, search_supplier', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, po_number, supplier_id, po_type, comments, status_id, due_date, created_date, created_by', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }
    
    public function rel_details() {
        return ConsolidatedPoDetail::model()->findAll(array('condition'=>"consolidated_po_id = $this->id"));
    }

    public function rel_supplier() {
        return Supplier::model()->findByAttributes(array('supsno' => $this->supplier_id));
    }

    public function rel_status() {
        return Status::model()->findByPk($this->status_id);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'po_number' => 'Po Number',
            'supplier_id' => 'Supplier',
            'po_type' => 'Po Type',
            'comments' => 'Comments',
            'status_id' => 'Status',
            'due_date' => 'Due Date',
            'created_date' => 'Created Date',
            'created_by' => 'Created By',
            'search_supplier'=>'Supplier'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->select = 't.id, t.po_number, t.supplier_id, t.po_type, t.comments, t.status_id, t.due_date, t.created_date, t.created_by, sup.supnam as search_supplier';

        $criteria->join = 'left join supplier sup on t.supplier_id = sup.supsno'
                . '         left join status st on t.status_id = st.id ';

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.po_number', $this->po_number, true);
        $criteria->compare('t.supplier_id', $this->supplier_id, true);
        $criteria->compare('sup.supnam', $this->search_supplier, true);
        $criteria->compare('t.po_type', $this->po_type, true);
        $criteria->compare('t.comments', $this->comments, true);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.due_date', $this->due_date, true);
        $criteria->compare('t.created_date', $this->created_date, true);
        $criteria->compare('t.created_by', $this->created_by);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.due_date ASC',
            )
        ));
    }

}
