<?php

/**
 * This is the model class for table "customer".
 *
 * The followings are the available columns in table 'customer':
 * @property integer $cussno
 * @property string $cuscus
 * @property string $cuscus_fref
 * @property integer $cusmcussno
 * @property string $cusnam
 * @property string $cusadd1
 * @property string $cusadd2
 * @property string $cusadd3
 * @property string $custown
 * @property string $cusstate
 * @property string $cuspostcode
 * @property integer $cuscousno
 * @property integer $custypsno
 * @property string $custel
 * @property string $cusfax
 * @property string $cusemail
 * @property double $cusdispcn
 * @property string $cusfnam
 * @property string $cussnam
 * @property string $custtl
 * @property string $cusofc
 * @property string $cusimgpath
 * @property string $cuscontact
 * @property string $cusucdnew
 * @property string $cusentddt
 * @property string $cusenttime
 * @property string $cusucdame
 * @property string $cusameddt
 * @property string $cusametime
 * @property string $shipAddress1
 * @property string $shipAddress2
 * @property string $shipAddress3
 * @property string $shipSub
 * @property string $shipState
 * @property string $shipPostalCode
 * @property integer $categoryId
 * @property integer $industryId
 */
class Customer extends CActiveRecord implements MYOBSynchronizable {

    public $importFile;

    /**
     * Provide the logic to be synchronized this record in an API 
     * @var MYOBSynchronizer concrete implementation of Synchronizer
     */
    public $synchronizer;
    //for report
    public $datefrom;
    public $dateto;
    public $followupStatus;

    //customer merging 
    public $mergeIntoCusId;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Customer the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'customer';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('cusnam, cusadd1,cusemail', 'required'),
            array('cussno, cusmcussno, cuscousno, custypsno, invoiceDueInXDays, myob_taxId, myob_freightTaxId, status_id, categoryId, industryId, shipCountryId, mergeIntoCusId', 'numerical', 'integerOnly' => true),
            array('cusemail', 'email'),
            array('cusdispcn', 'numerical'),
            array('cuscus, cuscontact, cusucdnew, cusucdame', 'length', 'max' => 50),
            array('cuscus_fref, cusnam, cusadd1, cusadd2, cusadd3, custel, cusmobtel, 
                cusfax, cusemail, cusfnam, cussnam, custtl, cusofc, cusimgpath, xeroContactID,qca_ref', 'length', 'max' => 255),
            array('custown', 'length', 'max' => 40),
            array('cusstate, myob_item_price_level', 'length', 'max' => 30),
            array('cuspostcode', 'length', 'max' => 10),
            array('cusmobtel', 'length', 'max' => 20),
            array('cuscontactemail, shipAddress1, shipAddress2, shipAddress3, datefrom, dateto, followupStatus', 'length', 'max' => 150),
            array('shipSub, shipState, shipPostalCode', 'length', 'max' => 100),
            array('invoiceDueInXDays', 'length', 'max' => 4),
            array('myob_guid_uuid', 'length', 'max' => 36),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('cussno, cuscus, cuscus_fref, cusmcussno, cusnam, cusadd1, cusadd2, cusadd3, custown, 
                cusstate, cuspostcode, cuscousno, custypsno, custel, cusfax, cusemail, cusdispcn, 
                cusfnam, cussnam, custtl, cusofc, cusimgpath, cuscontact, cusucdnew, cusentddt, cusenttime, 
                cusucdame, cusameddt, cusametime, xeroContactID, cuscontactemail, invoiceDueInXDays, importFile', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'master' => array(self::BELONGS_TO, 'MasterCustomer', '', 'foreignKey' => array('cusmcussno' => 'mcussno')),
            'category' => array(self::BELONGS_TO, 'CustomerCategory', 'categoryId'),
            'industry' => array(self::BELONGS_TO, 'CustomerIndustry', 'industryId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'cussno' => 'No',
            'cuscus' => 'Customer ID',
            'cuscus_fref' => 'Reference ID',
            'cusmcussno' => 'Master Customer',
            'cusnam' => 'Customer Name',
            'cusadd1' => 'Address',
            'cusadd2' => 'Address 2',
            'cusadd3' => 'Address 3',
            'custown' => 'Town',
            'cusstate' => 'State',
            'cuspostcode' => 'Postal Code',
            'cuscousno' => 'Country',
            'custypsno' => 'Custypsno',
            'custel' => 'Telephone',
            'cusmobtel' => 'Mobile Phone',
            'cusfax' => 'Fax',
            'cusemail' => 'E-mail',
            'cusdispcn' => 'Cusdispcn',
            'cusfnam' => 'Cusfnam',
            'cussnam' => 'Cussnam',
            'custtl' => 'Custtl',
            'cusofc' => 'Cusofc',
            'cusimgpath' => 'Cusimgpath',
            'cuscontact' => 'Contact Name',
            'cusucdnew' => 'Cusucdnew',
            'cusentddt' => 'Created Date',
            'cusenttime' => 'Created Time',
            'cusucdame' => 'Cusucdame',
            'cusameddt' => 'Modified Date',
            'cusametime' => 'Modified Time',
            'cuscontactemail' => 'Contact E-mail',
            'invoiceDueInXDays' => 'Invoice Due In (n) Days',
            'myob_taxId' => 'MYOB Tax Code',
            'myob_freightTaxId' => 'MYOB Freight Tax Code',
            'status_id' => 'Status',
            'qca_ref' => 'Reference',
            'shipAddress1' => 'Shipping Address 1',
            'shipAddress2' => 'Shipping Address 2',
            'shipAddress3' => 'Shipping Address 3',
            'shipSub' => 'Shipping Suburb',
            'shipState' => 'Shipping State',
            'shipPostalCode' => 'Shipping Postal Code',
            'importFile' => 'Import File',
            'categoryId' => 'Category',
            'industryId' => 'Industry',
            'account_number' => 'Account Numebr',
            'dateto' => 'Date To',
            'datefrom' => 'Date From',
            'followupStatus' => 'Follow-up Satatus',
            'mergeIntoCusId' => 'Merge Into'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        //$criteria->compare('cussno', $this->cussno);
        //$criteria->compare('cuscus', $this->cuscus, true);
        // $criteria->compare('cuscus_fref', $this->cuscus_fref, true);
        $criteria->compare('cusmcussno', $this->cusmcussno);
        $criteria->compare('cusnam', $this->cusnam, true);
        //$criteria->compare('cusadd1', $this->cusadd1, true);
        //$criteria->compare('cusadd2', $this->cusadd2, true);
        //$criteria->compare('cusadd3', $this->cusadd3, true);
        //$criteria->compare('custown', $this->custown, true);
        //$criteria->compare('cusstate', $this->cusstate, true);
        //$criteria->compare('cuspostcode', $this->cuspostcode, true);
        //$criteria->compare('cuscousno', $this->cuscousno);
        //$criteria->compare('custypsno', $this->custypsno);
        $criteria->compare('custel', $this->custel, true);
        $criteria->compare('cusmobtel', $this->cusmobtel, true);
        //$criteria->compare('cusfax', $this->cusfax, true);
        $criteria->compare('cusemail', $this->cusemail, true);
        //$criteria->compare('cusdispcn', $this->cusdispcn);
        //$criteria->compare('cusfnam', $this->cusfnam, true);
        //$criteria->compare('cussnam', $this->cussnam, true);
        //$criteria->compare('custtl', $this->custtl, true);
        //$criteria->compare('cusofc', $this->cusofc, true);
        // $criteria->compare('cusimgpath', $this->cusimgpath, true);
        $criteria->compare('cuscontact', $this->cuscontact, true);
        //$criteria->compare('cusucdnew', $this->cusucdnew, true);
        //$criteria->compare('cusentddt', $this->cusentddt, true);
        //$criteria->compare('cusenttime', $this->cusenttime, true);
        //$criteria->compare('cusucdame', $this->cusucdame, true);
        //$criteria->compare('cusameddt', $this->cusameddt, true);
        //$criteria->compare('cusametime', $this->cusametime, true);
        //$criteria->compare('invoiceDueInXDays', $this->invoiceDueInXDays, true);
        //$criteria->compare('status_id', $this->status_id);

        $criteria->compare('categoryId', $this->categoryId);
        $criteria->compare('industryId', $this->industryId);

        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.cussno in ($idStr)");
            } else {
                $criteria->addCondition("t.cussno in (0)");
            }
        }



        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array(
            'categoryId=:' => $this->categoryId,
            'industryId=:' => $this->industryId,
            'cusmcussno=:' => $this->cusmcussno,
        );

        //here define the filter fields by like values
        $paramarrLike = array(
            'cusnam LIKE :' => $this->cusnam,
            'custel LIKE :' => $this->custel,
            'cusmobtel LIKE :' => $this->cusmobtel,
            'cusemail LIKE :' => $this->cusemail,
            'cuscontact LIKE :' => $this->cuscontact
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        Yii::app()->session['customer_expt_qry'] = $originalQuery;

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'cusnam ASC',
            )
        ));
    }

    public function searchStatus() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        //$criteria->compare('cussno', $this->cussno);
        //$criteria->compare('cuscus', $this->cuscus, true);
        // $criteria->compare('cuscus_fref', $this->cuscus_fref, true);
        $criteria->compare('cusmcussno', $this->cusmcussno);
        $criteria->compare('cusnam', $this->cusnam, true);
        //$criteria->compare('cusadd1', $this->cusadd1, true);
        //$criteria->compare('cusadd2', $this->cusadd2, true);
        //$criteria->compare('cusadd3', $this->cusadd3, true);
        //$criteria->compare('custown', $this->custown, true);
        //$criteria->compare('cusstate', $this->cusstate, true);
        //$criteria->compare('cuspostcode', $this->cuspostcode, true);
        //$criteria->compare('cuscousno', $this->cuscousno);
        //$criteria->compare('custypsno', $this->custypsno);
        $criteria->compare('custel', $this->custel, true);
        $criteria->compare('cusmobtel', $this->cusmobtel, true);
        //$criteria->compare('cusfax', $this->cusfax, true);
        $criteria->compare('cusemail', $this->cusemail, true);
        //$criteria->compare('cusdispcn', $this->cusdispcn);
        //$criteria->compare('cusfnam', $this->cusfnam, true);
        //$criteria->compare('cussnam', $this->cussnam, true);
        //$criteria->compare('custtl', $this->custtl, true);
        //$criteria->compare('cusofc', $this->cusofc, true);
        // $criteria->compare('cusimgpath', $this->cusimgpath, true);
        $criteria->compare('cuscontact', $this->cuscontact, true);
        //$criteria->compare('cusucdnew', $this->cusucdnew, true);
        //$criteria->compare('cusentddt', $this->cusentddt, true);
        //$criteria->compare('cusenttime', $this->cusenttime, true);
        //$criteria->compare('cusucdame', $this->cusucdame, true);
        //$criteria->compare('cusameddt', $this->cusameddt, true);
        //$criteria->compare('cusametime', $this->cusametime, true);
        //$criteria->compare('invoiceDueInXDays', $this->invoiceDueInXDays, true);
        //$criteria->compare('status_id', $this->status_id);

        $criteria->compare('categoryId', $this->categoryId);
        $criteria->compare('industryId', $this->industryId);

        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.cussno in ($idStr)");
            } else {
                $criteria->addCondition("t.cussno in (0)");
            }
        }


        if (isset(Yii::app()->session['cus_sts_selcted']) || ($this->datefrom || $this->dateto)) {
            $stsArr = explode(',', Yii::app()->session['cus_sts_selcted']);

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' AND followupSts_id > 0"));
            foreach ($saleslogs as $slog) {


                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $query = "category = '" . FollowupStatus::CUSTOMER . "' AND tbl_id = {$slog->tbl_id} AND followupSts_id > 0 ";

                    if (!empty($this->datefrom) && empty($this->dateto)) {
                       $query .= "AND DATE_FORMAT(createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'";
                    } else if (empty($this->datefrom) && !empty($this->dateto)) {
                        $query .= "AND DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'";
                    } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                        
                         $query .= "AND DATE_FORMAT(createdDtm, '%Y-%m-%d') BETWEEN '" . date('Y-m-d', strtotime($this->datefrom)) . "' AND '" . date('Y-m-d', strtotime($this->dateto)) . "'";
                    }

                    $slog = SalesLog::model()->find(array('condition' => $query, 'order' => "id DESC"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if ($slog) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.cussno in ($idStr)");
            } else {
                $criteria->addCondition("t.cussno in (-1)");// set to nothing
            }
        }






        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array(
            'categoryId=:' => $this->categoryId,
            'industryId=:' => $this->industryId,
            'cusmcussno=:' => $this->cusmcussno,
        );

        //here define the filter fields by like values
        $paramarrLike = array(
            'cusnam LIKE :' => $this->cusnam,
            'custel LIKE :' => $this->custel,
            'cusmobtel LIKE :' => $this->cusmobtel,
            'cusemail LIKE :' => $this->cusemail,
            'cuscontact LIKE :' => $this->cuscontact
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        Yii::app()->session['customer_status_report_qry'] = $originalQuery;

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'cusnam ASC',
            )
        ));
    }

    protected function afterSave() {

        $workoders = Workorder::model()->findAll("cus_fref = '$this->cuscus_fref'");
        $jobs = Jobs::model()->findAll("cus_fref = '$this->cuscus_fref'");

        foreach ($workoders as $workorder) {
            $workorder->mastercusno = $this->cusmcussno;
            $workorder->save();
        }

        foreach ($jobs as $job) {
            $job->mastercusno = $this->cusmcussno;
            $job->save();
        }
        return true;
    }

    /**
     * @return string
     */
    public function getFullAddress() {
        $addressArr = array(
            $this->cusadd1,
            $this->cusadd2,
            $this->cusadd3,
            $this->custown,
            $this->cusstate,
            $this->cuspostcode
        );

        $addressArr = array_filter($addressArr);

        $addressArr = array_map(function($val) {
            return trim($val) ? str_replace(',', '', $val) : null;
        }, $addressArr);

        return implode(',', array_filter($addressArr));
    }

    public function getCusNameHtml() {
        $html = $this->cusnam;

        if ($this->status_id == 29) {
            $html .= "<br><span class='label label-important'>ACCOUNT ON HOLD</span>";
        }

        if ($this->myob_uuid && empty($this->json_response)) {
            $html .= '<br><span class="label label-success" title="Successfully uploaded">MYOB</span>';
        } else if (!empty($this->json_response)) {
            $html .= '<br><span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
        }

        if ($this->xeroContactID) {
            $html .= '<br><span class="label label-info" title="Xero Customer">Xero</span>';
        }

        return $html;
    }

    /**
     * refine telephone number
     * @return string | null 
     */
    public function telephone() {
        if (in_array($this->custel, array('Array', null))) {
            return null;
        }
        return trim($this->custel);
    }

    /**
     * refine mobile telephone number
     * @return string | null 
     */
    public function mobile() {
        if (in_array($this->cusmobtel, array('Array', null))) {
            return null;
        }
        return trim($this->cusmobtel);
    }

    /**
     * @return string telephones number
     */
    public function getPhones() {
        $phones = array(
            $this->telephone(),
            $this->mobile()
        );

        return implode(',', array_filter($phones));
    }

    public function copyMasterCustomerContact() {
        if ($this->cusmcussno) {

            $master = $this->master ?: MasterCustomer::model()->findByPk($this->cusmcussno);

            $this->cusadd1 = $master->mcusadd1;
            $this->cusadd2 = $master->mcusadd2;
            $this->cusadd3 = $master->mcusadd3;
            $this->custown = $master->mcustown;
            $this->cusstate = $master->mcusstate;
            $this->cuspostcode = $master->mcuspostcode;
            $this->custel = $master->mcustel;
            $this->cusfax = $master->mcusfax;
            $this->cusemail = $master->mcusemail;
        }
    }

    public function getMYOBJson() {

        //required - TaxCode,FreightTaxCode
        $myobsettings = MyobSetting::getSettings();
        $taxcode = $this->myob_taxId ? MyobTaxCode::model()->findByPk($this->myob_taxId) : MyobTaxCode::model()->findByPk($myobsettings->cus_taxcode_id);
        $freighttaxcode = $this->myob_freightTaxId ? MyobTaxCode::model()->findByPk($this->myob_freightTaxId) : MyobTaxCode::model()->findByPk($myobsettings->cus_freight_taxcode_id);

        $taxcodeuuid = $taxcode ? $taxcode->uuid : null;
        $freightcodeuuid = $freighttaxcode ? $freighttaxcode->uuid : null;

        $customerarr = array(
            "CompanyName" => $this->cusnam,
            "IsIndividual" => "false",
            "DisplayID" => $this->cuscus,
            "IsActive" => "true",
            "SellingDetails" => array(
                "SaleLayout" => "NoDefault",
                "PrintedForm" => "Pre-Printed Invoice",
                "ShippingMethod" => "Freight",
                "TaxCode" => array(
                    "UID" => $taxcodeuuid,
                ),
                "FreightTaxCode" => array(
                    "UID" => $freightcodeuuid,
                ),
            )
        );

        /* this will force  MYOB to update the record */

        if ($this->myob_uuid && $this->myob_row_version) {
            $customerarr["UID"] = $this->myob_uuid;
            $customerarr["RowVersion"] = $this->myob_row_version;
        }

        $street = $this->cusadd1 . " " . $this->cusadd2 . " " . $this->cusadd3;
        $customerarr["Addresses"][] = array(
            "Location" => 1,
            "Street" => $street,
            "City" => $this->custown,
            "State" => $this->cusstate,
            "PostCode" => $this->cuspostcode,
            "Country" => "Australia",
            "Phone1" => $this->custel,
            "Phone2" => $this->custel2,
            "Phone3" => $this->custel3,
            "Fax" => $this->cusfax,
            "Email" => $this->cusemail,
            "ContactName" => $this->cuscontact,
            "Salutation" => "Hello"
        );

        return json_encode($customerarr);
    }

    public function getMYOBError() {
        $obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
        return $obj ? MYOBResponse::formatError($obj) : '';
    }

    public function myobLastModified() {
        return date('Y-m-d H:i:s', strtotime($this->cusameddt . ' ' . $this->cusametime));
    }

    /**
     * @override
     * Synchronize current record with MYOB
     * @param MYOBApiConnector $myobConnector api connection
     * @return boolean success true, otherwise false
     */
    public function myobSynchronize(\MYOBApiConnector $myobConnector) {
        return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
    }

    public function reportMYOBError(\MYOBResponse $response) {
        Yii::app()->db->createCommand()
                ->update('customer', array(
                    'json_response' => serialize($response),
                        ), "cussno=$this->cussno" /* where condition */
        );

        MYOBLog::writeLog(array(
            'table_name' => $this->tableName(),
            'table_reference_id' => $this->cussno,
            'log_type_id' => MYOBLog::LOG_TYPE_ERROR,
            'log_message' => serialize($response),
            'log_class' => $GLOBALS['MYOB_ERROR_CLASS'],
            'log_line' => $GLOBALS['MYOB_ERROR_LINE'],
        ));
    }

    public function setSynchronizer(\MYOBSynchronizer $synchronizer) {
        $this->synchronizer = $synchronizer;
    }

    public function toJsonString() {
        return $this->getMYOBJson();
    }

    public function updateByMYOB(\MYOBResponse $response) {
        try {
            $dataArr = self::myobProductDataCore($response);
            if ($this->myob_guid_uuid != trim(Yii::app()->session['myob_guid_uuid']) || !$this->cusmcussno) {
                /* check whether the master customer available for the same record and also update the master customer id of the current customer record */
                $masterCusRaw = Yii::app()->db->createCommand()->select('mcussno')
                                ->from('master_customer')
                                ->where('myob_uuid=:UID AND myob_guid_uuid=:GUIDE', array(
                                    ':UID' => $response->UID,
                                    ':GUIDE' => trim(Yii::app()->session['myob_guid_uuid']),
                                ))->queryRow();
                if ($masterCusRaw) {
                    $dataArr['cusmcussno'] = $masterCusRaw['mcussno'];
                }
            }


            if (in_array($response->DisplayID, array(null, '', '*None'))) { /* MYOB DisplayID may contain with empty or *None value */
                $dataArr['cuscus'] = $this->cuscus ?: $this->cussno;
            }



            Yii::app()->db->createCommand()
                    ->update('customer', $dataArr, "cussno=$this->cussno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public function updateMYOBReferences(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('customer', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "cussno=$this->cussno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public static function createByMYOB(\MYOBResponse $response) {
        try {
            $dataArr = self::myobProductDataCore($response);
            $dataArr['cuscus'] = $response->DisplayID;
            $dataArr['cuscus_fref'] = $response->DisplayID;
            $dataArr['cusentddt'] = date('Y-m-d');
            $dataArr['cusenttime'] = date('H:i:s');
            if (in_array($response->DisplayID, array(null, '', '*None'))) { /* MYOB DisplayID may contain with empty or *None value */
                $dataArr['cuscus'] = time();
                $dataArr['cuscus_fref'] = time();
            }

            if (Yii::app()->db->createCommand()
                            ->insert('customer', $dataArr)) {
                $lastInsertID = Yii::app()->db->getLastInsertID();
                Yii::app()->db->createCommand("UPDATE customer SET cuscus = customer.cussno, cuscus_fref = customer.cussno WHERE cussno = {$lastInsertID}")->execute();
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true;
    }

    /**
     * Encapsulate supplier data creation from MYOB response
     * @return array key,value pairs represent this data table
     */
    static function myobProductDataCore(\MYOBResponse $response) {
        $addressArr = $response->Addresses;
        $sellingDetailArr = $response->SellingDetails;

        if ($taxUID = $sellingDetailArr["TaxCode"]["UID"]) {
            $taxRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $taxUID,))->queryRow();
        }
        if ($freightTaxUID = $sellingDetailArr["FreightTaxCode"]["UID"]) {
            $freightTaxRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $freightTaxUID,))->queryRow();
        }

        return array(
            'cuscus' => $response->DisplayID,
            'myob_uuid' => $response->UID,
            'cusnam' => (boolval($response->IsIndividual) ? ($response->FirstName . ' ' . $response->LastName) : $response->CompanyName),
            'cusadd1' => $addressArr[0]["Street"],
            'custown' => $addressArr[0]["City"],
            'cusstate' => $addressArr[0]["State"],
            'cuspostcode' => $addressArr[0]["PostCode"],
            'custel' => $addressArr[0]["Phone1"],
            'custel2' => $addressArr[0]["Phone2"],
            'custel3' => $addressArr[0]["Phone3"],
            'cusfax' => $addressArr[0]["Fax"],
            'cusemail' => $addressArr[0]["Email"],
            'cuscontact' => $addressArr[0]["ContactName"],
            'myob_item_price_level' => $sellingDetailArr["ItemPriceLevel"],
            'myob_row_version' => $response->RowVersion,
            'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
            'myob_taxId' => isset($taxRaw) ? $taxRaw['id'] : null,
            'myob_freightTaxId' => isset($freightTaxRaw) ? $freightTaxRaw['id'] : null,
            'json_response' => null,
            'cusameddt' => date('Y-m-d', strtotime($response->LastModified)),
            'cusametime' => date('H:i:s', strtotime($response->LastModified))
        );
    }

    public function reportMYOBSuccess(\MYOBResponse $response) {
        
    }

    public function getFollowupStatusToString() {
        $slog = SalesLog::model()->find(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and tbl_id = {$this->cussno} and followupSts_id > 0", 'order' => "id desc"));
        if ($slog) {
            return FollowupStatus::model()->findByPk($slog->followupSts_id)->status;
        } else {
            return null;
        }
    }
    
    public function getFollowupLog() {
        return  SalesLog::model()->find(array('condition' => "category = '" . FollowupStatus::CUSTOMER . "' and tbl_id = {$this->cussno} and followupSts_id > 0", 'order' => "id desc"));
        
    }

}
