<?php

/**
 * This is the model class for table "decoration_price".
 *
 * The followings are the available columns in table 'decoration_price':
 * @property integer $dcpsno
 * @property integer $dcpdecsno
 * @property integer $dcpquantity_break_level
 * @property double $dcpsquantity
 * @property string $dcpquantity
 * @property double $dcpprice
 * @property string $dcpucdnew
 * @property string $dcpentddt
 * @property string $dcpenttime
 * @property string $dcpucdame
 * @property string $dcpameddt
 * @property string $dcpametime
 */
class DecorationPrice extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DecorationPrice the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'decoration_price';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('dcpdecsno, dcpsquantity, dcpucdnew, dcpentddt, dcpenttime, dcpucdame, dcpameddt, dcpametime', 'required'),
			array('dcpdecsno, dcpquantity_break_level', 'numerical', 'integerOnly'=>true),
			array('dcpsquantity, dcpprice', 'numerical'),
			array('dcpquantity', 'length', 'max'=>10),
			array('dcpucdnew, dcpucdame', 'length', 'max'=>30),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('dcpsno, dcpdecsno, dcpquantity_break_level, dcpsquantity, dcpquantity, dcpprice, dcpucdnew, dcpentddt, dcpenttime, dcpucdame, dcpameddt, dcpametime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'dcpsno' => 'Dcpsno',
			'dcpdecsno' => 'Dcpdecsno',
			'dcpquantity_break_level' => 'Dcpquantity Break Level',
			'dcpsquantity' => 'Dcpsquantity',
			'dcpquantity' => 'Dcpquantity',
			'dcpprice' => 'Dcpprice',
			'dcpucdnew' => 'Dcpucdnew',
			'dcpentddt' => 'Dcpentddt',
			'dcpenttime' => 'Dcpenttime',
			'dcpucdame' => 'Dcpucdame',
			'dcpameddt' => 'Dcpameddt',
			'dcpametime' => 'Dcpametime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('dcpsno',$this->dcpsno);
		$criteria->compare('dcpdecsno',$this->dcpdecsno);
		$criteria->compare('dcpquantity_break_level',$this->dcpquantity_break_level);
		$criteria->compare('dcpsquantity',$this->dcpsquantity);
		$criteria->compare('dcpquantity',$this->dcpquantity,true);
		$criteria->compare('dcpprice',$this->dcpprice);
		$criteria->compare('dcpucdnew',$this->dcpucdnew,true);
		$criteria->compare('dcpentddt',$this->dcpentddt,true);
		$criteria->compare('dcpenttime',$this->dcpenttime,true);
		$criteria->compare('dcpucdame',$this->dcpucdame,true);
		$criteria->compare('dcpameddt',$this->dcpameddt,true);
		$criteria->compare('dcpametime',$this->dcpametime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}