<?php

/**
 * This is the model class for table "decoration".
 *
 * The followings are the available columns in table 'decoration':
 * @property integer $decsno
 * @property string $decprtnam
 * @property string $deccustomyn
 * @property string $decnam
 * @property double $declogo_setup_charges
 * @property integer $decmaintypsno
 * @property string $decis_main_type
 * @property integer $decweight_4_sorting
 * @property integer $decpriority
 * @property integer $decis_shown_to_clients
 * @property integer $decflag
 * @property integer $decsupsno
 * @property double $decuntprice
 * @property integer $decleadtime
 * @property string $decduration
 * @property string $decmob
 * @property string $decucdnew
 * @property string $decentddt
 * @property string $decenttime
 * @property string $decucdame
 * @property string $decameddt
 * @property string $decametime
 */
class Decoration extends CActiveRecord {

    public $decoration_mntyp_description;
    public $main_deco_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Decoration the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'decoration';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('decprtnam, decnam', 'required'),
            array('decmaintypsno, decweight_4_sorting, decpriority, decis_shown_to_clients, decflag, decsupsno', 'numerical', 'integerOnly' => true),
            array('declogo_setup_charges, decuntprice,logoSetupUnitMarkupRate', 'numerical'),
            array('decprtnam, decnam', 'length', 'max' => 255),
            array('deccustomyn, decis_main_type', 'length', 'max' => 1),
            array('decduration', 'length', 'max' => 10),
            array('decmob', 'length', 'max' => 2),
            array('decoration_mntyp_description, main_deco_search', 'safe'),
            array('decucdnew, decucdame', 'length', 'max' => 50),
            array('declogo_setup_charges,decmaintypsno,decweight_4_sorting,decpriority,decis_shown_to_clients,decflag,decsupsno,decleadtime', 'default', 'value' => 0),
            array('deccustomyn,decis_main_type,decduration,decmob,decucdnew,decucdame', 'default', 'value' => ''),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('decsno, decprtnam, deccustomyn, decnam, declogo_setup_charges, decmaintypsno, decis_main_type, decweight_4_sorting, decpriority, decis_shown_to_clients, decflag, decsupsno, decuntprice, decleadtime, decduration, decmob, decucdnew, decentddt, decenttime, decucdame, decameddt, decametime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'supplier' => array(self::BELONGS_TO, 'Supplier', 'decsupsno'),
            'mainDeco' => array(self::BELONGS_TO, 'Decoration', 'decmaintypsno'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'decsno' => 'Decsno',
            'decprtnam' => 'Decoration Code',
            'deccustomyn' => 'Is Custom Decoration',
            'decnam' => 'Decoration Description',
            'declogo_setup_charges' => 'Logo Setup Charges',
            'decmaintypsno' => 'Decoration Main Type',
            'decis_main_type' => 'Is Main Type',
            'decweight_4_sorting' => 'Decweight 4 Sorting',
            'decpriority' => 'Decpriority',
            'decis_shown_to_clients' => 'Decis Shown To Clients',
            'decflag' => 'Decflag',
            'decsupsno' => 'Decoration Supplier',
            'decuntprice' => 'Unit Price Cost',
            'decleadtime' => 'Lead Time',
            'decduration' => 'Decduration',
            'decmob' => 'Decmob',
            'decucdnew' => 'Created By',
            'decentddt' => 'Created Date',
            'decenttime' => 'Decenttime',
            'decucdame' => 'Decucdame',
            'decameddt' => 'Decameddt',
            'decametime' => 'Decametime',
            'decoration_mntyp_description' => 'Main Type Description',
            'logoSetupUnitMarkupRate' => 'Logo Setup Unit Markup Rate (%)'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('mainDeco');

        $criteria->compare('t.decsno', $this->decsno);
        $criteria->compare('t.decprtnam', $this->decprtnam, true);
        $criteria->compare('t.deccustomyn', $this->deccustomyn, true);
        $criteria->compare('t.decnam', $this->decnam, true);
        $criteria->compare('t.declogo_setup_charges', $this->declogo_setup_charges);
        //$criteria->compare('decmaintypsno', $this->decmaintypsno);
        $criteria->compare('t.decis_main_type', $this->decis_main_type, true);
        $criteria->compare('t.decweight_4_sorting', $this->decweight_4_sorting);
        $criteria->compare('t.decpriority', $this->decpriority);
        $criteria->compare('t.decis_shown_to_clients', $this->decis_shown_to_clients);
        $criteria->compare('t.decflag', $this->decflag);
        $criteria->compare('t.decsupsno', $this->decsupsno);
        $criteria->compare('t.decuntprice', $this->decuntprice);
        $criteria->compare('t.decleadtime', $this->decleadtime);
        $criteria->compare('t.decduration', $this->decduration, true);
        $criteria->compare('t.decmob', $this->decmob, true);
        $criteria->compare('t.decucdnew', $this->decucdnew, true);
        $criteria->compare('t.decentddt', $this->decentddt, true);
        $criteria->compare('t.decenttime', $this->decenttime, true);
        $criteria->compare('t.decucdame', $this->decucdame, true);
        $criteria->compare('t.decameddt', $this->decameddt, true);
        $criteria->compare('t.decametime', $this->decametime, true);

        $criteria->compare('mainDeco.decprtnam', $this->main_deco_search, true);



        $criteria->addCondition("t.decmaintypsno <> 0");
        $criteria->order = 't.decmaintypsno asc';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }
    
    
    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchForSelectPopup() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('mainDeco');

        $hasFiltering = false;
        
        if (trim($this->decprtnam)) {
            $hasFiltering = true;
            $criteria->compare('t.decprtnam', $this->decprtnam, true);
        }
        
        if (trim($this->decnam)) {
            $hasFiltering = true;
            $criteria->compare('t.decnam', $this->decnam, true);
        }
        
        if (trim($this->declogo_setup_charges)) {
            $hasFiltering = true;
            $criteria->compare('t.declogo_setup_charges', $this->declogo_setup_charges);
        }
        
        if (trim($this->main_deco_search)) {
            $hasFiltering = true;
            $criteria->compare('mainDeco.decprtnam', $this->main_deco_search, true);
        }
       
        if (!$hasFiltering) {
            $criteria->addCondition("t.decsno < 0");
        }
        
       

        



        $criteria->addCondition("t.decmaintypsno <> 0");
        $criteria->order = 't.decmaintypsno asc';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function searchmian() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('decsno', $this->decsno);
        $criteria->compare('decprtnam', $this->decprtnam, true);
        $criteria->compare('deccustomyn', $this->deccustomyn, true);
        $criteria->compare('decnam', $this->decnam, true);
        $criteria->compare('declogo_setup_charges', $this->declogo_setup_charges);
        $criteria->compare('decmaintypsno', $this->decmaintypsno);
        $criteria->compare('decis_main_type', $this->decis_main_type, true);
        $criteria->compare('decweight_4_sorting', $this->decweight_4_sorting);
        $criteria->compare('decpriority', $this->decpriority);
        $criteria->compare('decis_shown_to_clients', $this->decis_shown_to_clients);
        $criteria->compare('decflag', $this->decflag);
        $criteria->compare('decsupsno', $this->decsupsno);
        $criteria->compare('decuntprice', $this->decuntprice);
        $criteria->compare('decleadtime', $this->decleadtime);
        $criteria->compare('decduration', $this->decduration, true);
        $criteria->compare('decmob', $this->decmob, true);
        $criteria->compare('decucdnew', $this->decucdnew, true);
        $criteria->compare('decentddt', $this->decentddt, true);
        $criteria->compare('decenttime', $this->decenttime, true);
        $criteria->compare('decucdame', $this->decucdame, true);
        $criteria->compare('decameddt', $this->decameddt, true);
        $criteria->compare('decametime', $this->decametime, true);

        $criteria->addCondition("decis_main_type = 'Y' and decprtnam <> 'N/A'");
        $criteria->order = 'decentddt desc';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    protected function beforeSave() {



        if ($this->isNewRecord) {
            $this->decentddt = date("Y-m-d");
            $this->decenttime = date("H:i:s");
            $this->decucdnew = Yii::app()->user->username;
        } else {
            $this->decameddt = date("Y-m-d");
            $this->decametime = date("H:i:s");
            $this->decucdame = Yii::app()->user->username;
        }



        return parent::beforeSave();
    }
    
    public static function updateDecoration(array $attributes) {

        if ($attributes['decprtnam'] != 'custom_decoration') {
            $supplier = Supplier::model()->find("supsup_fref = '{$attributes['supsup_fref']}'");
            $decoration = Decoration::model()->find(array('condition' => 'decprtnam=:decorationKey', 'params' => array(':decorationKey' => $attributes['decprtnam'])));

            if (!$decoration) {
                $decoration = new Decoration();
            }


            $decoration->deccustomyn = $attributes['deccustomyn'];
            $decoration->decnam = $attributes['decnam'];
            $decoration->declogo_setup_charges = $attributes['declogo_setup_charges'];


            $decoration->logoSetupUnitMarkupRate = $attributes['logoSetupUnitMarkupRate'];


            $decoration->decsupsno = ($supplier ? $supplier->supsno : null);
            $decoration->decuntprice = $attributes['decuntprice'];
            $decoration->decucdnew = Yii::app()->user->username;
            $decoration->decameddt = date('Y-m-d');
            $decoration->decametime = date('H:i:s');

            $decoration->decmaintypsno = $attributes['decmaintypsno'];

            $decoration->decis_main_type = $attributes['decis_main_type'];
            $decoration->decis_shown_to_clients = $attributes['decis_shown_to_clients'];
            ;
            $decoration->decflag = $attributes['decflag'];            
            
            $decoration->decucdame = Yii::app()->user->username;
            $decoration->decameddt = date('Y-m-d');
            $decoration->decametime = date('H:i:s');

            return $decoration;
        }
    }
    
    public function getSupplierLink() {
         return CHtml::link($this->supplier->supnam, array('supplier/view', 'id' => $this->supplier->supsno));
    }

}
