<?php

/**
 * This is the model class for table "delivery_docket_details".
 *
 * The followings are the available columns in table 'delivery_docket_details':
 * @property integer $id
 * @property integer $deliveryDocketId
 * @property integer $wrkorderId
 * @property integer $wrkorderDtlId
 * @property integer $invoiceid
 * @property integer $invoiceDtlId
 * @property integer $jobId
 * @property integer $qty
 * @property integer $boxNumber
 * @property integer $designNumber
 */
class DeliveryDocketDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DeliveryDocketDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'delivery_docket_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('deliveryDocketId, wrkorderId, wrkorderDtlId, invoiceid, invoiceDtlId, jobId, qty, boxNumber', 'numerical', 'integerOnly'=>true),
			array('designNumber', 'length', 'max'=>100),
                                // The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, deliveryDocketId, wrkorderId, wrkorderDtlId, invoiceid, invoiceDtlId, jobId, qty, boxNumber, designNumber', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'deliverydocket'=> array(self::BELONGS_TO, 'DeliveryDockets', 'deliveryDocketId'),
                    'workorderdtl' => array(self::BELONGS_TO, 'Workorderdetails', 'wrkorderDtlId'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'deliveryDocketId' => 'Delivery Docket',
			'wrkorderId' => 'Wrkorder',
			'wrkorderDtlId' => 'Wrkorder Dtl',
			'invoiceid' => 'Invoiceid',
			'invoiceDtlId' => 'Invoice Dtl',
			'jobId' => 'Job',
			'qty' => 'Qty',
			'boxNumber' => 'Box Number',
			'designNumber' => 'Notes',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('deliveryDocketId',$this->deliveryDocketId);
		$criteria->compare('wrkorderId',$this->wrkorderId);
		$criteria->compare('wrkorderDtlId',$this->wrkorderDtlId);
		$criteria->compare('invoiceid',$this->invoiceid);
		$criteria->compare('invoiceDtlId',$this->invoiceDtlId);
		$criteria->compare('jobId',$this->jobId);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('boxNumber',$this->boxNumber);
		$criteria->compare('designNumber',$this->designNumber,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}