<?php

/**
 * This is the model class for table "delivery_docket_labels".
 *
 * The followings are the available columns in table 'delivery_docket_labels':
 * @property integer $id
 * @property integer $delivery_docket_id
 * @property integer $delivery_docket_dtl_id
 * @property string $boxnum
 * @property string $notes
 * @property integer $quantity
 */
class DeliveryDocketLabel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DeliveryDocketLabel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'delivery_docket_labels';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('delivery_docket_id, delivery_docket_dtl_id, quantity', 'numerical', 'integerOnly'=>true),
			array('boxnum', 'length', 'max'=>45),
			array('notes', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, delivery_docket_id, delivery_docket_dtl_id, boxnum, notes, quantity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'delivery_docket_id' => 'Delivery Docket',
			'delivery_docket_dtl_id' => 'Delivery Docket Dtl',
			'boxnum' => 'Boxnum',
			'notes' => 'Notes',
			'quantity' => 'Quantity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('delivery_docket_id',$this->delivery_docket_id);
		$criteria->compare('delivery_docket_dtl_id',$this->delivery_docket_dtl_id);
		$criteria->compare('boxnum',$this->boxnum,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('quantity',$this->quantity);

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
}