<?php

/**
 * This is the model class for table "delivery_dockets".
 *
 * The followings are the available columns in table 'delivery_dockets':
 * @property integer $id
 * @property integer $quoteId
 * @property integer $wrkorderId
 * @property integer $jobId
 * @property integer $invoiceId
 * @property string $diliveryDocketNum
 * @property string $contactName
 * @property string $companyName
 * @property string $companyAddress
 * @property string $telephone1
 * @property string $telephone2
 * @property integer $createdBy
 * @property string $createdDtm
 */
class DeliveryDockets extends CActiveRecord {

    var $invoice_number;
    var $job_number;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return DeliveryDockets the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'delivery_dockets';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('id,quoteId, wrkorderId, jobId, invoiceId, createdBy, shippedBy', 'numerical', 'integerOnly' => true),
            array('createdDtm,companyName', 'required'),
            array('diliveryDocketNum, town, state', 'length', 'max' => 100),
            array('contactName, companyName, companyAddress, companyAddress2, companyAddress3, invoice_number', 'length', 'max' => 255),
            array('telephone1, telephone2', 'length', 'max' => 15),
             array('postalCode', 'length', 'max' => 50),
            array('createdDtm, conNote, job_number', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, quoteId, wrkorderId, jobId, invoiceId, diliveryDocketNum, invoice_number, contactName, 
                            companyName, companyAddress, telephone1, telephone2, createdBy, createdDtm, town, state, companyAddress, companyAddress2, conNote, shippedBy', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'invoice' => array(self::BELONGS_TO, 'Invoice', 'invoiceId'),
            'job' => array(self::BELONGS_TO, 'Jobs', 'jobId'),
            'ShippingLine' => array(self::BELONGS_TO, 'ShippingLine', 'shippedBy'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quoteId' => 'Quote',
            'wrkorderId' => 'Wrkorder',
            'jobId' => 'Job',
            'invoiceId' => 'Invoice',
            'diliveryDocketNum' => 'Delivery Docket Number',
            'contactName' => 'Contact Name',
            'companyName' => 'Company Name',
            'companyAddress' => 'Company Address',
            'companyAddress2' => 'Company Address 2',
            'companyAddress3' => 'Company Address 3',
            'telephone1' => 'Office Telephone',
            'telephone2' => 'Mobile Phone',
            'createdBy' => 'Created By',
            'createdDtm' => 'Created Date',
            'invoice_number' => 'Invoice Number',
            'town' => 'Town',
            'state' => 'State',
            'shippedBy' => 'Shipped By',
            'conNote' => 'Con Note',
            'job_number'=>'Job'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('job','invoice');

        $criteria->compare('id', $this->id);
        $criteria->compare('quoteId', $this->quoteId);
        $criteria->compare('wrkorderId', $this->wrkorderId);
        $criteria->compare('jobId', $this->jobId);
        $criteria->compare('invoiceId', $this->invoiceId);
        $criteria->compare('diliveryDocketNum', $this->diliveryDocketNum, true);
        $criteria->compare('contactName', $this->contactName, true);
        $criteria->compare('companyName', $this->companyName, true);
        $criteria->compare('companyAddress', $this->companyAddress, true);
        $criteria->compare('companyAddress2', $this->companyAddress2, true);
        $criteria->compare('companyAddress3', $this->companyAddress3, true);
        $criteria->compare('telephone1', $this->telephone1, true);
        $criteria->compare('telephone2', $this->telephone2, true);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('conNote', $this->conNote, true);
        $criteria->compare('shippedBy', $this->shippedBy);
        
        $criteria->compare('job.jobNum', $this->job_number, true);
        $criteria->compare('invoice.invoiceNum', $this->invoice_number, true);

        //$criteria->order = 'createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm DESC',
                'attributes'=>array(
                    'job_number'=>array(
                        'asc'=>'job.jobNum ASC',
                        'desc'=>'job.jobNum DESC',                        
                        
                    ),
                    'createdDtm'=>array(
                        'asc'=>'t.createdDtm ASC',
                        'desc'=>'t.createdDtm DESC',
                        'default' => 't.createdDtm DESC',
                        
                    ),
                    'diliveryDocketNum'=>array(
                        'asc'=>'diliveryDocketNum ASC',
                        'desc'=>'diliveryDocketNum DESC',
                        'default' => 'diliveryDocketNum DESC',
                        
                    ),
                    'invoice_number'=>array(
                        'asc'=>'invoice.invoiceNum ASC',
                        'desc'=>'invoice.invoiceNum DESC',
                        'default' => 'invoice.invoiceNum DESC',
                        
                    )
                    
                )
            )
        ));
    }

    public function getFullAddress() {
        $fulladdress = '';
        if (!empty($this->companyAddress)) {
            $fulladdress .= $this->companyAddress;
        }

        if (!empty($this->companyAddress2)) {
            $fulladdress .= ', ' . $this->companyAddress2;
        }

        if (!empty($this->companyAddress3)) {
            $fulladdress .= ', ' . $this->companyAddress3;
        }

        if (!empty($this->town)) {
            $fulladdress .= ', ' . $this->town;
        }

        if (!empty($this->state)) {
            $fulladdress .= ', ' . $this->state;
        }

        return $fulladdress;
    }

}