<?php

/**
 * This is the model class for table "developernote".
 *
 * The followings are the available columns in table 'developernote':
 * @property integer $id
 * @property string $ticketNumber
 * @property string $developer
 * @property string $description
 * @property string $status
 * @property string $datetime
 * @property integer $createdBy
 * @property interger $trapId 
 */
class DeveloperNote extends CActiveRecord
{
    const STATUS_DRAFT = 'DRAFT';
    const STATUS_TO_DO = 'TO_DO';
    const STATUS_DONE = 'DONE';
    const STATUS_FIXED = 'FIXED';
    const STATUS_IN_PROGRESS = 'IN_PROGRESS';

    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DeveloperNote the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'developernote';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ticketNumber, description, developer', 'required'),
			array('id, createdBy, trapId', 'numerical', 'integerOnly'=>true),
			array('ticketNumber, developer, status', 'length', 'max'=>100),
			array('description, datetime', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, ticketNumber, developer, description, status, datetime, createdBy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'userRel' => array(self::BELONGS_TO, 'User', 'createdBy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'ticketNumber' => 'Ticket Number',
			'developer' => 'Developer',
			'description' => 'Description',
			'status' => 'Status',
			'datetime' => 'Datetime',
			'createdBy' => 'Created By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('ticketNumber',$this->ticketNumber,true);
		$criteria->compare('developer',$this->developer,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('datetime',$this->datetime,true);
		$criteria->compare('createdBy',$this->createdBy);
                
                $criteria->order = 'datetime desc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function beforeSave(){
            $this->createdBy = Yii::app()->user->id;
            $this->datetime = date('Y-m-d H:i:s');
             return parent::beforeSave();
        }
}