<?php

/**
 * This is the model class for table "emails".
 *
 * The followings are the available columns in table 'emails':
 * @property integer $id
 * @property string $toemailaddresses
 * @property string $ccemailaddresses carbon copy
 * @property string $bccEmailAddresses blind carbon copy
 * @property integer $createdBy
 * @property string $createdDtm
 */
class Emails extends CActiveRecord {

    const TYPE_WEBSTORE_ORDER = 'WEBSTORE_ORDER';

    public $type;
    public $fileattachment;
    public $emailAddressSearch;
    public $quoteAcceptanceEnablePayLater;
    

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Emails the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'emails';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('bodyText, subject, fromaddress, toemailaddresses', 'required'),
            array('createdBy, quoteAcceptanceEnablePayLater', 'numerical', 'integerOnly' => true),
            array('toemailaddresses, ccemailaddresses,fileattachment, subject, bccEmailAddresses, type', 'length', 'max' => 255),
            array('toemailaddresses, fromaddress', 'email', 'message' => '"{attribute}" is not a valid email address. if you want to add multiple addresses use cc or bcc'),
            array('createdDtm, bodyText,emailAddressSearch', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, toemailaddresses, ccemailaddresses, createdBy, createdDtm,fileattachment, fromaddress', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'toemailaddresses' => 'To',
            'ccemailaddresses' => 'Cc',
            'createdBy' => 'Created By',
            'createdDtm' => 'Created Date',
            'fileattachment' => 'Attached File',
            'subject' => 'Subject',
            'bodyText' => 'Body',
            'fromaddress' => 'From',
            'bccEmailAddresses' => 'Bcc',
            'emailAddressSearch' => 'To',
            'quoteAcceptanceEnablePayLater' => 'Enable Pay later  '
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('toemailaddresses', $this->toemailaddresses, true);
        //$criteria->compare('ccemailaddresses',$this->ccemailaddresses,true);
        //$criteria->compare('bccEmailAddresses',$this->bccEmailAddresses,true);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('subject', $this->subject, true);
        $criteria->compare('bodyText', $this->bodyText, true);
        $criteria->compare('fromaddress', $this->fromaddress, true);

        $criteria->addCondition("toemailaddresses LIKE '%{$this->emailAddressSearch}%' OR ccemailaddresses LIKE '%{$this->emailAddressSearch}%' OR bccEmailAddresses LIKE '%{$this->emailAddressSearch}%'");

        if (!User::isAdmin()) {
            $criteria->addCondition('createdBy = ' . Yii::app()->user->id);
        }

        $criteria->order = 'createdDtm desc';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function getAttachement() {
        $mailattachement = EmailAttachments::model()->find(array('condition' => "email_id = '{$this->id}'"));
        $filemodel = FileInventory::model()->findByPk($mailattachement->fileinventory_id);
    }

    public static function trackSave($recepient, $cc, $bodytxt) {
        //save email
        $trackemail = new Emails();
        $trackemail->toemailaddresses = $recepient;
        $trackemail->ccemailaddresses = $cc;
        $trackemail->createdBy = Yii::app()->user->id;
        $trackemail->createdDtm = date('Y-m-d', strtotime('now'));
        if ($trackemail->save()) {
            $trackmailbody = new Emailbody();
            $trackmailbody->email_id = $trackemail->id;
            $trackmailbody->bodytext = $bodytxt;
            return $trackmailbody->save();
        } else {
            return false;
        }

        //end track email
    }

    public function renderAttachemntsColumn() {

        $html = '';
        $emailattachements = EmailAttachments::model()->findAll(array('condition' => "email_id = '{$this->id}'"));
        foreach($emailattachements as $attachment) {
            $fileattachment = FileInventory::model()->findByPk($attachment->fileinventory_id);
            if(!$attachment->ref_id) {
                $html .= CHtml::link("View PDF [{$fileattachment->filename}]",array('fileInventory/viewfile', 'id'=>$attachment->fileinventory_id),array('style'=>'margin-left:10px;','target'=>'_blank')) . '<br />';
            } else {
                
                $html .= CHtml::link("View File [{$fileattachment->filename}]",array('fileInventory/downloadFile', 'id'=>$attachment->fileinventory_id),array('style'=>'margin-left:10px;','target'=>'_blank')) . '<br />';
            }
            
        }

        return $html;
        
    }

}
