<?php

/**
 * This is the model class for table "eway_transsactions".
 *
 * The followings are the available columns in table 'eway_transsactions':
 * @property integer $id
 * @property string $accessCode
 * @property string $authorisationCode
 * @property string $responseCode
 * @property string $responseMessage
 * @property integer $invoiceNumber
 * @property string $invoiceReference
 * @property string $totalAmount
 * @property integer $transactionID
 * @property integer $transactionStatus
 */
class EwayTranssaction extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return EwayTranssaction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'eway_transsactions';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('invoiceNumber, transactionID, transactionStatus', 'numerical', 'integerOnly'=>true),
			array('authorisationCode, responseCode, responseMessage, invoiceReference, totalAmount', 'length', 'max'=>255),
			array('accessCode', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, accessCode, authorisationCode, responseCode, responseMessage, invoiceNumber, invoiceReference, totalAmount, transactionID, transactionStatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'accessCode' => 'Access Code',
			'authorisationCode' => 'Authorisation Code',
			'responseCode' => 'Response Code',
			'responseMessage' => 'Response Message',
			'invoiceNumber' => 'Invoice Number',
			'invoiceReference' => 'Invoice Reference',
			'totalAmount' => 'Total Amount',
			'transactionID' => 'Transaction ID',
			'transactionStatus' => 'Transaction Status',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('accessCode',$this->accessCode,true);
		$criteria->compare('authorisationCode',$this->authorisationCode,true);
		$criteria->compare('responseCode',$this->responseCode,true);
		$criteria->compare('responseMessage',$this->responseMessage,true);
		$criteria->compare('invoiceNumber',$this->invoiceNumber);
		$criteria->compare('invoiceReference',$this->invoiceReference,true);
		$criteria->compare('totalAmount',$this->totalAmount,true);
		$criteria->compare('transactionID',$this->transactionID);
		$criteria->compare('transactionStatus',$this->transactionStatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}