<?php

/**
 * This is the model class for table "file_inventory".
 *
 * The followings are the available columns in table 'file_inventory':
 * @property integer $id
 * @property string $filename
 * @property string $comments
 * @property string $createdDtm
 * @property integer $createdBy
 */
class FileInventory extends CActiveRecord {

    const TYPE_WEBSTORE_BANNER = 'WEBSTORE_BANNER';
    const TYPE_WEBSTORE_ORDER = 'WEBSTORE_ORDER';
    const TYPE_PRODUCT_IMAGE = 'PRODUCT_IMAGE';

    public $documentfilename;
    public $statusType;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return FileInventory the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'file_inventory';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('filename', 'required'),
            array('id, createdBy, ref_id', 'numerical', 'integerOnly' => true),
            //array('filename, comments', 'required'),
            array('filename, comments', 'length', 'max' => 255),
            array('type', 'length', 'max' => 50),
            array('createdDtm, documentfilename, statusType', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, filename, comments, createdDtm, createdBy,type,ref_id', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'filename' => 'Attached File',
            'comments' => 'Comments',
            'createdDtm' => 'Attached Date',
            'createdBy' => 'Attached By',
            'type' => 'Type',
            'ref_id' => 'Reference ID',
            'documentfilename' => 'Document Name',
            'followup_sts_id' => 'Status'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('filename', $this->filename, true);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('type', $this->type);
        $criteria->compare('ref_id', $this->ref_id);
        $criteria->compare('followup_sts_id', $this->followup_sts_id);

        if (!User::isAdmin()) {
            $criteria->addCondition('createdBy = ' . Yii::app()->user->id);
        }

        $criteria->order = 'createdDtm desc';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function getFileView() {
        $this->refresh();
        $viewfile = '';
        $flieArr = explode('.', $this->filename);


        $dirPath = 'files/' . $this->type . '/' . $this->filename;
        if (in_array($flieArr[1], array('JPG', 'jpg', 'jpeg', 'gif', 'png'))) {
            $viewfile = CHtml::image($dirPath, '', array('style' => 'width:80px;'));
        } else if (in_array($flieArr[1], array('pdf', 'PDF'))) {
            $dirpath = 'images/file-type-icon/pdf-icon.png';
            $viewfile = CHtml::image($dirpath, '', array('style' => 'width:80px;'));
        } else if (in_array($flieArr[1], array('xls', 'xlsx'))) {
            $dirpath = 'images/file-type-icon/excel-icon.png';
            $viewfile = CHtml::image($dirpath, '', array('style' => 'width:80px;'));
        } else {
            $dirpath = 'images/file-type-icon/file-attachment.png';
            $viewfile = CHtml::image($dirpath, '', array('style' => 'width:80px;'));
        }

        return $viewfile;
    }

    /**
     * @param array mix
     * throw Exception if required parameters are not available
     * @return FileInventory 
     */
    public static function createFile(array $data) {
        if (!$data) {
            throw new Exception('No data to create file');
        }

        $required = array('referenceId', 'type', 'fileName');



        if (count(array_intersect_key(array_flip($required), $data)) !== count($required)) {
            throw new Exception('Requuired fileds not existed!');
        }

        $model = new FileInventory;
        $model->ref_id = $data['referenceId'];
        $model->type = $data['type'];
        $model->filename = $data['fileName'];
        $model->createdDtm = date('Y-m-d');
        $model->createdBy = Yii::app()->user->id;
        if ($model->save()) {
            return $model;
        }

        return null;
    }

    /**
     * copy all files and data related to the type and reference id  into the given type and ref id
     * @return bool 
     */
    public static function copyAttachments($referece_from, $type_from, $refernce_to, $type_to) {


        $createdBy = Yii::app()->user->id;
        $sql = "INSERT INTO file_inventory(filename,type,ref_id,createdDtm,createdBy) SELECT filename,'$type_to','$refernce_to', NOW(), '$createdBy' FROM file_inventory WHERE ref_id = $referece_from AND type = '$type_from'";
        Yii::app()->db->createCommand($sql)->execute();


        $fileInventories = Yii::app()->db->createCommand()
                ->select('filename,type,ref_id')
                ->from('file_inventory')
                ->where('type=:type AND ref_id=:ref_id', array(':type' => $type_from, ':ref_id' => $referece_from))
                ->queryAll();

        $dirPathFrom = 'files/' . $type_from;
        $dirPathTo = 'files/' . $type_to;

        if (!file_exists($dirPathTo)) {
            mkdir($dirPathTo, 0777, true);
        }

        foreach ($fileInventories as $data) {
            /* suppres warning(@) if cannot copy the file */
            @copy($dirPathFrom . '/' . $data['filename'], $dirPathTo . '/' . $data['filename']);
        }
    }

}
