<?php

/**
 * This is the model class for table "followup_status".
 *
 * The followings are the available columns in table 'followup_status':
 * @property integer $id
 * @property string $status
 * @property integer $status_sequence
 * @property integer $system_required
 * @property string $color_hex
 */
class FollowupStatus extends CActiveRecord {
    
	 const  QUOTATION = 'Quotation';
	 const SALES_ORDER = 'SalesOrder';
	 const JOB = 'Job'; 
	 const INVOICE = 'Invoice';
	 const PURCHASE_ORDER = 'PurchaseOrder';
         const CUSTOMER = 'Customer';
	 const OTHER = 'Other';
	 const STATUS_TYPE_PURCHASE_ORDER = 'PurchaseOrder';
         const WEBSTORE_ORDER = 'WebStoreOrder';

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return FollowupStatus the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'followup_status';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('type, status', 'required'),
            array('status_sequence, system_required', 'numerical'),
            array('status', 'length', 'max' => 255),
            array('type', 'length', 'max' => 100),
            array('color_hex', 'length', 'max' => 10),
            array('type, status', 'uniqueTest','on' => 'create'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, status, type', 'safe', 'on' => 'search'),
        );
    }
    
    public function uniqueTest($attribute, $params) {

		
		
        $fstatus = FollowupStatus::model()->find(array('condition'=>"type = '{$this->type}' AND status = '{$this->status}'"));
        
        if (!empty($fstatus)) {
            
            $this->addError('status', "Already have this 'Type' and 'Status' combination!");
            return false;
        }
        
        return true;
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'status' => 'Status',
            'type' => 'Type',
            'status_sequence' => 'Status Sequence',
            'color_hex' => 'Colour'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('status', $this->status, true);
        $criteria->compare('type', $this->type, true);
		$criteria->compare('status_sequence', $this->status_sequence);
		
		$pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
                'defaultOrder' => ' type ASC,-status_sequence DESC, id DESC',
            )
        ));
    }

    public static function getStatus($id) {
        $model = FollowupStatus::model()->findByPk($id);
        
		return $model->status ?? null;		
		
    }
	
	public static function getList()
	{
		return array(self::QUOTATION =>'Quotation', self::SALES_ORDER =>'Sales Order', self::JOB =>'Job', self::INVOICE =>'Invoice', self::PURCHASE_ORDER =>'Purchase Order' , self::OTHER =>'Other');
	}
        
        public function isSystemRequired() {
        if (!$this->isNewRecord && $this->system_required) {
            return true;
        }
        
        return false;
    }
	
}
