<?php

/**
 * This is the model class for table "global_vars".
 *
 * The followings are the available columns in table 'global_vars':
 * @property integer $id
 * @property string $globalVar
 * @property double $value
 * @property integer $createdBy
 * @property string $createdDtm
 */
class GlobalVars extends CActiveRecord {

    const GST = 'GST';
    const ADMIN_EMAIL = 'AdminEmail';
    const FOLLOW_UP_IN_X_DAYS = 'FollowInXDays';
    const DUE_IN_X_DAYS = 'DueInXDays';
    const DATE_FORMAT = 'DateFormat';
    const INVOICE_PREFIX = 'InvoicePrefix';
    const MYSQL_DATETIME_FORMAT = 'Y-m-d H:i:s';
    const MASTER_PO_PREFIX = 'MasterPOPrefix';
    const PURCHASE_ORDER_PREFIX = 'PurchaseOrderPrefix';
    const PRODUCT_IMAGE_SOURCE = 'ProductImageResource';
    const QUOTATION_STARTING_NUMBER = 'QuoteStartingNumber';
    const QUOTATION_NEXT_NUMBER = 'NextQuoteNumber';
    const PO_STARTING_NUMBER = 'PurchaseOrderStartingNumber';
    const PO_NEXT_NUMBER = 'NextPurchasrOrderNumber';
    const SITE_PREFIX = 'SitePrefix'; //this will be used as the prefix for file names, report names and headers etc.
    const SUPPLIER_MARKUP_RATE = 'SupplierMarkUp';

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return GlobalVars the static model class
     */

    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'global_vars';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('createdBy', 'numerical', 'integerOnly' => true),
            array('globalVar,value', 'length', 'max' => 255),
            array('createdDtm, comment', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, globalVar, value, createdBy, createdDtm, comment', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'globalVar' => 'Global Variable',
            'value' => 'Value',
            'createdBy' => 'Created By',
            'createdDtm' => 'Created Date',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('globalVar', $this->globalVar, true);
        $criteria->compare('value', $this->value);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('createdDtm', $this->createdDtm, true);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    protected function beforeSave() {


        $this->createdDtm = date("Y-m-d H:i:s");
        $this->createdBy = Yii::app()->user->id;

        return parent::beforeSave();
    }

    public static function get($globalvar = null) {
        $model = GlobalVars::model()->find("globalVar = '$globalvar'");
        if (!empty($model)) {
            return $model->value;
        } else {
            return '';
        }
    }

}
