<?php

/**
 * This is the model class for table "gin_details".
 *
 * The followings are the available columns in table 'gin_details':
 * @property integer $id
 * @property integer $gin_id
 * @property integer $po_id
 * @property integer $wrkorder_id
 * @property integer $wrkorderDtl_id
 * @property integer $job_id
 * @property integer $jobDtl_id
 * @property integer $jobProdDocoDtl_id
 * @property integer $qty
 */
class GoodsIssueDetails extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GoodsIssueDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gin_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gin_id, po_id, wrkorder_id, wrkorderDtl_id, job_id, jobDtl_id, jobProdDocoDtl_id, qty', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, gin_id, po_id, wrkorder_id, wrkorderDtl_id, job_id, jobDtl_id, jobProdDocoDtl_id, qty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'wrkorderDtl_id'),
                    'jobproductdeco' => array(self::BELONGS_TO, 'JobProductDecorations', 'jobProdDocoDtl_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'gin_id' => 'Gin',
			'po_id' => 'Po',
			'wrkorder_id' => 'Wrkorder',
			'wrkorderDtl_id' => 'Wrkorder Dtl',
			'job_id' => 'Job',
			'jobDtl_id' => 'Job Dtl',
			'jobProdDocoDtl_id' => 'Job Prod Doco Dtl',
			'qty' => 'Qty',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('gin_id',$this->gin_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('wrkorder_id',$this->wrkorder_id);
		$criteria->compare('wrkorderDtl_id',$this->wrkorderDtl_id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('jobDtl_id',$this->jobDtl_id);
		$criteria->compare('jobProdDocoDtl_id',$this->jobProdDocoDtl_id);
		$criteria->compare('qty',$this->qty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}