<?php

/**
 * This is the model class for table "gins".
 *
 * The followings are the available columns in table 'gins':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorder_id
 * @property integer $po_id
 * @property integer $supplier_id
 * @property string $issuedDtm
 * @property string $createdDtm
 * @property integer $createdBy
 * @property integer $status_id
 * @property string $ginType
 */
class GoodsIssueNote extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GoodsIssueNote the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gins';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, workorder_id, po_id, supplier_id, createdBy, status_id', 'numerical', 'integerOnly'=>true),
			array('ginType,ginnum', 'length', 'max'=>45),
			array('issuedDtm, createdDtm,comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, workorder_id, po_id, supplier_id, issuedDtm, createdDtm, createdBy, status_id, ginType,ginnum,comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
                    'porder' => array(self::BELONGS_TO, 'PurchaseOrders', 'po_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'workorder_id' => 'Workorder',
			'po_id' => 'Po',
			'supplier_id' => 'Supplier',
			'issuedDtm' => 'Issued Date',
			'createdDtm' => 'Created Date',
			'createdBy' => 'Created By',
			'status_id' => 'Status',
			'ginType' => 'Gin Type',
                    'ginnum'=>'GIN Number',
                    'comments'=>'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('supplier_id',$this->supplier_id);
		$criteria->compare('issuedDtm',$this->issuedDtm,true);
		$criteria->compare('createdDtm',$this->createdDtm,true);
		$criteria->compare('createdBy',$this->createdBy);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('ginType',$this->ginType,true);
                $criteria->compare('ginnum',$this->ginnum,true);
                $criteria->compare('comments',$this->comments,true);
                
                $criteria->order = 'createdDtm DESC';
                
                
		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
}