<?php

/**
 * This is the model class for table "grns".
 *
 * The followings are the available columns in table 'grns':
 * @property integer $id
 * @property integer $job_id
 * @property integer $wrkorder_id
 * @property integer $po_id
 * @property integer $supplier_id
 * @property string $receivedDate
 * @property string $createdDtm
 * @property integer $createdBy
 * @property integer $status_id
 * @property string $grnType
 */
class GoodsReceived extends CActiveRecord
{
    
    public  $addtoinventory;

    /**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GoodsReceived the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'grns';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, wrkorder_id, po_id, supplier_id, createdBy, status_id', 'numerical', 'integerOnly'=>true),
			array('grnType', 'length', 'max'=>255),
                        array('grnnum', 'length', 'max'=>45),
			array('receivedDate, createdDtm, addtoinventory', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, wrkorder_id, po_id, supplier_id, receivedDate, createdDtm,
                            createdBy, status_id, grnType, grnnum, addtoinventory', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'workorder' => array(self::BELONGS_TO, 'Workorder', 'wrkorder_id'),
                    'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
                    'porder' => array(self::BELONGS_TO, 'PurchaseOrders', 'po_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job ID',
			'wrkorder_id' => 'Sales Order',
			'po_id' => 'Po',
			'supplier_id' => 'Supplier',
			'receivedDate' => 'Received Date',
			'createdDtm' => 'Created Date',
			'createdBy' => 'Created By',
			'status_id' => 'Status',
			'grnType' => 'GRN Type',
                        'grnnum'=>'GRN Number',
                        'addtoinventory'=>'Add to Inventory'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('wrkorder_id',$this->wrkorder_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('supplier_id',$this->supplier_id);
		$criteria->compare('receivedDate',$this->receivedDate,true);
		$criteria->compare('createdDtm',$this->createdDtm,true);
		$criteria->compare('createdBy',$this->createdBy);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('grnType',$this->grnType,true);
                
                if (!User::isAdmin()) {
            $criteria->addCondition('createdBy = ' . Yii::app()->user->id);
        }
                
                $criteria->order = 'createdDtm DESC';

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
}