<?php

/**
 * This is the model class for table "internal_jobs".
 *
 * The followings are the available columns in table 'internal_jobs':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorderDtl_id
 * @property string $internaljobType
 * @property string $notation
 * @property string $image
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $status_id
 * @property integer $user_id
 */
class InternalJobs extends CActiveRecord
{
    public $createddatefrom;
    public $createddateto;
    public $followupdatefrom;
    public $followupdateto;
    public $expecteddatefrom;
    public $expecteddateto;
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InternalJobs the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'internal_jobs';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, status_id, user_id', 'numerical', 'integerOnly'=>true),
			array('internaljobType', 'length', 'max'=>45),
			array('notation, image,interjobnum', 'length', 'max'=>255),
			array('followupDate, dueDate, createdDtm, createddatefrom,createddateto,
                            followupdatefrom,followupdateto,expecteddatefrom,expecteddateto', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id,  internaljobType,interjobnum, notation, image, followupDate, 
                            dueDate, status_id, user_id, createdDtm', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',	
                        'interjobnum'=>'Internal Job Number',
			'internaljobType' => 'Internaljob Type',
			'notation' => 'Notation',
			'image' => 'Image',
			'followupDate' => 'Followup Date',
			'dueDate' => 'Due Date',
			'status_id' => 'Status',
			'user_id' => 'User',
                        'createdDtm'=>'Created Date'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);		
		$criteria->compare('internaljobType',$this->internaljobType,true);
                $criteria->compare('interjobnum',$this->interjobnum,true);
		$criteria->compare('notation',$this->notation,true);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('followupDate',$this->followupDate,true);
		$criteria->compare('dueDate',$this->dueDate,true);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('user_id',$this->user_id);
                $criteria->compare('createdDtm',$this->createdDtm,true);
                
                $criteria->order = 'createdDtm DESC';
                

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
        public function searchpendingartwork()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);		
		$criteria->compare('internaljobType',$this->internaljobType,true);
                $criteria->compare('interjobnum',$this->interjobnum,true);
		$criteria->compare('notation',$this->notation,true);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('followupDate',$this->followupDate,true);
		$criteria->compare('dueDate',$this->dueDate,true);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('user_id',$this->user_id);
                $criteria->compare('createdDtm',$this->createdDtm,true);
                
                //find from created date
                if(!empty($this->createddatefrom) && !empty($this->createddateto)){
                    $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->createddatefrom))."' and DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '".date('Y-m-d',  strtotime($this->createddateto))."'");
                }else if(!empty($this->createddatefrom) && empty($this->createddateto)){
                    $today = date('Y-m-d',  strtotime('now'));
                    $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->createddatefrom))."' and DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '$today'");
                }else if(empty($this->createddatefrom) && !empty($this->createddateto)){
                    
                    $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '$this->createddateto'");
                }
                
                //search from followup date
                if(!empty($this->followupdatefrom) && !empty($this->followupdateto)){
                    $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->followupdatefrom))."' and DATE_FORMAT(followupDate, '%Y-%m-%d') <= '".date('Y-m-d',  strtotime($this->followupdateto))."'");
                }else if(!empty($this->followupdatefrom) && empty($this->followupdateto)){
                    $today = date('Y-m-d',  strtotime('now'));
                    $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->followupdatefrom))."' and DATE_FORMAT(followupDate, '%Y-%m-%d') <= '$today'");
                }else if(empty($this->followupdatefrom) && !empty($this->followupdateto)){
                    
                    $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') <= '".date('Y-m-d',  strtotime($this->createddateto))."'");
                }
                
                //search from due date
                if(!empty($this->expecteddatefrom) && !empty($this->expecteddateto)){
                    $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->expecteddatefrom))."' and DATE_FORMAT(dueDate, '%Y-%m-%d') <= '".date('Y-m-d',  strtotime($this->expecteddateto))."'");
                }else if(!empty($this->expecteddatefrom) && empty($this->expecteddateto)){
                    $today = date('Y-m-d',  strtotime('now'));
                    $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') >= '".date('Y-m-d',  strtotime($this->expecteddatefrom))."' and DATE_FORMAT(dueDate, '%Y-%m-%d') <= '$today'");
                }else if(empty($this->expecteddatefrom) && !empty($this->expecteddateto)){
                    
                    $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') <= '".date('Y-m-d',  strtotime($this->expecteddateto))."'");
                }
                
                $criteria->order = 'createdDtm DESC';
                

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
        
        public function purchaseEmbTape() {

        if (in_array($this->status_id, array(11))) {
            $artwrkinvent = InventoryArtWork::model()->find("internaljob_id = '{$this->id}'");

            if (!empty($artwrkinvent)) {
                if ($artwrkinvent->embrTapePo_id > 0) {
                    return false;
                }
            }
            
            return true;
        }else{
            return false;
        }
    }
    
     public function getFlowStatus(){
        if($this->status_id == 11)return 'complete';
        
        if(!empty($this->dueDate)){
            if($this->status_id != 11 && date('Y-m-d',  strtotime('now')) > date('Y-m-d',  strtotime($this->dueDate))){
                return 'due';
           }else{
               return 'notcomplete';
           }
        }else{
            return 'notcomplete';
        }
    }
}