<?php

/**
 * This is the model class for table "inventory".
 *
 * The followings are the available columns in table 'inventory':
 * @property integer $id
 * @property integer $product_id
 * @property integer $supplier_id
 * @property integer $qty
 * @property double $cost_price
 * @property string $remarks
 * @property integer $status
 * @property integer $po_id
 * @property integer $grn_id
 * @property integer $createdBy
 * @property string $createdDate
 */
class Inventory extends CActiveRecord {

    public $productcode_search;
    public $product_shortname_search;
    public $product_description_search;
    public $warehouse_search;
    public $customer_search;
    public $supplier_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Inventory the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'inventory';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('warehouseId, product_id, supplier_id, qty, status, po_id, grn_id, createdBy', 'numerical', 'integerOnly' => true),
            array('cost_price', 'numerical'),
            array('remarks, createdDate, productcode_search, product_shortname_search, product_description_search, supplier_search', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, product_id, supplier_id, qty, cost_price, remarks, status, po_id, grn_id, createdBy, createdDate', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'productLine' => array(self::BELONGS_TO, 'ProductLine', '', 'foreignKey' => array('product_id' => 'pdlsno')),
            'supplier' => array(self::BELONGS_TO, 'Supplier', 'supplier_id'),
            'status_' => array(self::BELONGS_TO, 'Status', 'status'),
            'warehouseRel' => array(self::BELONGS_TO, 'Branch', 'warehouseId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'product_id' => 'Product',
            'supplier_id' => 'Supplier',
            'qty' => 'Qty',
            'cost_price' => 'Cost Price',
            'remarks' => 'Remarks',
            'status' => 'Status',
            'po_id' => 'Po',
            'grn_id' => 'Grn',
            'createdBy' => 'Created By',
            'createdDate' => 'Created Date',
            'warehouseId' => 'Warehouse',
            'productcode_search' => 'Product Code',
            'product_shortname_search' => 'Product Name',
            'product_description_search' => 'Product Description',
            'supplier_search' => 'Supplier'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('productLine', 'supplier');

        $criteria->compare('id', $this->id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('supplier_id', $this->supplier_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('cost_price', $this->cost_price);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('status', $this->status);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('grn_id', $this->grn_id);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('warehouseId', $this->warehouseId);

        $criteria->compare('productLine.pdlpdl', $this->productcode_search, true);
        $criteria->compare('productLine.pdlprdline', $this->product_shortname_search, true);
        $criteria->compare('productLine.pdldes', $this->product_description_search, true);

        $criteria->compare('supplier.supnam', $this->supplier_search, true);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function warehouseSearch() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('product_id', $this->product_id);
        $criteria->compare('supplier_id', $this->supplier_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('cost_price', $this->cost_price);
        $criteria->compare('remarks', $this->remarks, true);
        $criteria->compare('status', $this->status);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('grn_id', $this->grn_id);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('warehouseId', $this->warehouseId);

        $criteria->addCondition("warehouseId is null or warehouseId = ''");

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

}
