<?php

/**
 * This is the model class for table "inventory_art_work".
 *
 * The followings are the available columns in table 'inventory_art_work':
 * @property integer $id
 * @property integer $job_id
 * @property integer $wrkord_id
 * @property integer $internaljob_id
 * @property integer $po_id
 * @property string $artworkcode
 * @property string $image
 * @property integer $embrTapePo_id
 * @property integer $screenPrintPo_id
 * @property string $embrTapeCode
 * @property integer $embrTapeJob_id
 * @property integer $isEmbrTapeAvl
 * @property integer $isScrnPrntAvl
 * @property string $createdDate
 * @property integer $user_id
 */
class InventoryArtWork extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InventoryArtWork the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'inventory_art_work';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, wrkord_id, internaljob_id, po_id, embrTapePo_id, artworkGrn_id,
                            screenPrintPo_id, embrTapeJob_id, isEmbrTapeAvl, grn_id, isScrnPrntAvl, user_id', 'numerical', 'integerOnly'=>true),
			array('artworkcode, embrTapeCode', 'length', 'max'=>45),
			array('image', 'length', 'max'=>255),
			array('createdDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, wrkord_id, internaljob_id, po_id, artworkcode, image, embrTapePo_id, grn_id, artworkGrn_id,
                            screenPrintPo_id, embrTapeCode, embrTapeJob_id, isEmbrTapeAvl, isScrnPrntAvl, createdDate, user_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
                    'internaljob' => array(self::BELONGS_TO, 'InternalJobs', 'internaljob_id'),
                    'workorder' => array(self::BELONGS_TO, 'Workorder', 'wrkord_id'),
                    'po'=>array(self::BELONGS_TO, 'PurchaseOrders', 'po_id'),
                    'grn'=>array(self::BELONGS_TO, 'GoodsReceived', 'grn_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'wrkord_id' => 'Wrkord',
			'internaljob_id' => 'Internaljob',
			'po_id' => 'Po',
			'artworkcode' => 'Artworkcode',
			'image' => 'Image',
			'embrTapePo_id' => 'Embr Tape Po',
			'screenPrintPo_id' => 'Screen Print Po',
			'embrTapeCode' => 'Embr Tape Code',
			'embrTapeJob_id' => 'Embr Tape Job',
			'isEmbrTapeAvl' => 'Is Embr Tape Avl',
			'isScrnPrntAvl' => 'Is Scrn Prnt Avl',
			'createdDate' => 'Created Date',
			'user_id' => 'User',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('wrkord_id',$this->wrkord_id);
		$criteria->compare('internaljob_id',$this->internaljob_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('artworkcode',$this->artworkcode,true);
		$criteria->compare('image',$this->image,true);
		$criteria->compare('embrTapePo_id',$this->embrTapePo_id);
		$criteria->compare('screenPrintPo_id',$this->screenPrintPo_id);
		$criteria->compare('embrTapeCode',$this->embrTapeCode,true);
		$criteria->compare('embrTapeJob_id',$this->embrTapeJob_id);
		$criteria->compare('isEmbrTapeAvl',$this->isEmbrTapeAvl);
		$criteria->compare('isScrnPrntAvl',$this->isScrnPrntAvl);
		$criteria->compare('createdDate',$this->createdDate,true);
		$criteria->compare('user_id',$this->user_id);
                
                $criteria->order = 'createdDate';

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
        
        public function getImg(){
            return Yii::app()->baseUrl . '/images/artwork/' . $this->image;
        }
        
        public function getPurchaseOrderNumLink(){
            if(Yii::app()->user->checkAccess("PurchaseOrders.View")){
                return CHtml::link((!empty($this->po) ? $this->po->poNum : ""),array("purchaseOrders/view","id"=>$this->po_id),array("target"=>"_blank"));
            }else{
                return (!empty($this->po) ? $this->po->poNum : "");
            }
        }
        
        public function getGrnNumLink(){
            if(Yii::app()->user->checkAccess("GoodsReceived.View")){
                return CHtml::link((!empty($this->grn) ? $this->grn->grnnum : ""),array("goodsReceived/view","id"=>$this->grn_id),array("target"=>"_blank"));
            }else{
                return (!empty($this->grn) ? $this->grn->grnnum : "");
            }
            
        }
}