<?php

/**
 * This is the model class for table "inventory_product".
 *
 * The followings are the available columns in table 'inventory_product':
 * @property integer $id
 * @property integer $job_id
 * @property integer $wrkorder_id
 * @property integer $wrkorderDtl_id
 * @property integer $product_id
 * @property integer $prdGrn_id
 * @property integer $prdGrnQty
 * @property integer $isDecoDone
 * @property integer $prodDecoGrn_id
 * @property integer $prdDecoGrnQty
 * @property string $prdReceivedDtm
 * @property string $prdDecoReceivedDtm
 */
class InventoryProduct extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InventoryProduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'inventory_product';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, wrkorder_id, wrkorderDtl_id, product_id, prdGrn_id, prdGrnQty, isDecoDone,
                            prodDecoGrn_id, prdDecoGrnQty,gin_id, ginDtls_id, ginQty, goodsStatus_id', 'numerical', 'integerOnly'=>true),
			array('prdReceivedDtm, prdDecoReceivedDtm', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, wrkorder_id, wrkorderDtl_id, product_id, prdGrn_id, prdGrnQty, isDecoDone, prodDecoGrn_id, 
                            prdDecoGrnQty, prdReceivedDtm, prdDecoReceivedDtm, gin_id, ginDtls_id, ginQty, goodsStatus_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'wrkorder_id' => 'Wrkorder',
			'wrkorderDtl_id' => 'Wrkorder Dtl',
			'product_id' => 'Product',
			'prdGrn_id' => 'Prd Grn',
			'prdGrnQty' => 'Prd Grn Qty',
			'isDecoDone' => 'Is Deco Done',
			'prodDecoGrn_id' => 'Prod Deco Grn',
			'prdDecoGrnQty' => 'Prd Deco Grn Qty',
			'prdReceivedDtm' => 'Prd Received Dtm',
			'prdDecoReceivedDtm' => 'Prd Deco Received Dtm',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('wrkorder_id',$this->wrkorder_id);
		$criteria->compare('wrkorderDtl_id',$this->wrkorderDtl_id);
		$criteria->compare('product_id',$this->product_id);
		$criteria->compare('prdGrn_id',$this->prdGrn_id);
		$criteria->compare('prdGrnQty',$this->prdGrnQty);
		$criteria->compare('isDecoDone',$this->isDecoDone);
		$criteria->compare('prodDecoGrn_id',$this->prodDecoGrn_id);
		$criteria->compare('prdDecoGrnQty',$this->prdDecoGrnQty);
		$criteria->compare('prdReceivedDtm',$this->prdReceivedDtm,true);
		$criteria->compare('prdDecoReceivedDtm',$this->prdDecoReceivedDtm,true);

		$pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
	}
}