<?php

/**
 * This is the model class for table "inventory_sizeqtycolor".
 *
 * The followings are the available columns in table 'inventory_sizeqtycolor':
 * @property integer $id
 * @property integer $inventory_id
 * @property integer $inventory_product_id
 * @property integer $product_size_id
 * @property integer $qty
 * @property string $color
 */
class InventorySizeQtyColor extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InventorySizeQtyColor the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'inventory_sizeqtycolor';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inventory_id, inventory_product_id, product_size_id, qty', 'numerical', 'integerOnly'=>true),
			array('color', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, inventory_id, inventory_product_id, product_size_id, qty, color', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'productSizeRel' => array(self::BELONGS_TO, 'ProductSize', 'product_size_id'), 
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'inventory_id' => 'Inventory',
			'inventory_product_id' => 'Inventory Product',
			'product_size_id' => 'Product Size',
			'qty' => 'Qty',
			'color' => 'Color',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;
                
                $criteria->with = array('productSizeRel');

		$criteria->compare('id',$this->id);
		$criteria->compare('inventory_id',$this->inventory_id);
		$criteria->compare('inventory_product_id',$this->inventory_product_id);
		$criteria->compare('product_size_id',$this->product_size_id);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('color',$this->color,true);
                
                $criteria->order = "productSizeRel.ordernumber asc";

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}