<?php

/**
 * This is the model class for table "invoices".
 *
 * The followings are the available columns in table 'invoices':
 * @property integer $id
 * @property integer $quote_id
 * @property integer $job_id
 * @property integer $customer_id
 * @property double $amount
 * @property string $comments
 * @property string $createdDtm
 * @property integer $createdBy
 * @property integer $status_id
 * @property integer $xero_in_queue
 * @property integer $xero_to_be_sent
 */
class Invoice extends CActiveRecord implements MYOBSynchronizable {

    public $sales_person_search;
    public $spersonDateFlag;
    public $datefrom;
    public $dateto;
    public $ws_user_id;
    public $job_number_search;
    public $customer_search;
    public $master_customer_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Invoice the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'invoices';
    }

    public function behaviors() {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('quote_id, job_id, customer_id, createdBy, status_id, surcharge_id, myobTaxCodeId, xero_in_queue, xero_to_be_sent', 'numerical', 'integerOnly' => true),
            array('amountExVat,amountIncVat, surcharge_rate', 'numerical'),
            array('comments,invoiceNum,quoteNum, xero_invoice_id, myob_row_version', 'length', 'max' => 255),
            array('xero_status', 'length', 'max' => 100),
            array('createdDtm, xero_makePayments, duedate, json_response, myob_uuid, sales_person_search, '
                . 'spersonDateFlag,datefrom,dateto,ws_user_id,job_number_search,customer_search,xero_error_response, master_customer_search ', 'safe'),
            array('specialcmnt', 'filter', 'filter' => 'strip_tags'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, quote_id, job_id, invoiceNum, quoteNum, customer_id, amountExVat,amountIncVat, comments, 
                specialcmnt,createdDtm, createdBy, status_id, xero_invoice_id, xero_status, xero_makePayments, duedate', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
    }

    public function rel_details() {
        return InvoiceDetail::model()->findAll(array('condition' => "invoice_id = $this->id"));
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'quote_id' => 'Quote',
            'job_id' => 'Job',
            'customer_id' => 'Customer ID',
            'amountExVat' => 'Amount Excluding GST',
            'amountIncVat' => 'Amount Including GST',
            'comments' => 'Comments',
            'createdDtm' => 'Created Date',
            'createdBy' => 'Created By',
            'status_id' => 'Status',
            'invoiceNum' => 'Invoice Number',
            'quoteNum' => 'Quotation Number',
            'specialcmnt' => 'Extra Note',
            'duedate' => 'Due Date',
            'myobTaxCodeId' => 'MYOB Tax Code',
            'sales_person_search' => 'Sales Person',
            'ws_user_id' => 'Sales Person',
            'job_number_search' => 'Job',
            'master_customer_search' => 'Master Customer',
            'xero_to_be_sent' => 'To Be Synced'
        );
    }

    var $show_custmizedtl = true;
    var $show_notes = true;
    var $prod_column_width = 18;
    var $deco_column_width = 25;
    var $qty_column_width = 5;
    var $cost_column_width = 8;
    var $cutmz_column_width = 45;
    var $notes_column_width = 55;

    public function generatePDF($parms_arr) {
        $model = $this;

        $show_price = $parms_arr['show_price'];
        $show_decoration = $parms_arr['show_decoration'];
        $this->show_custmizedtl = $parms_arr['show_custmizedtl'];
        $this->show_notes = $parms_arr['show_notes'];

        if ($show_price == false && $show_decoration == false) {
            $this->prod_column_width = 55;
            $this->qty_column_width = 25;
        } else if ($show_price == true && $show_decoration == false) {

            $this->prod_column_width = 43;
            $this->deco_column_width = 0; //optional
        } else if ($show_price == false && $show_decoration == true) {
            $this->prod_column_width = 33;
            $this->deco_column_width = 40;
            $this->qty_column_width = 7;
        }

        if ($this->show_custmizedtl == true && $this->show_notes == true) {
            $this->cutmz_column_width = 45; //optional
            $this->notes_column_width = 55; //optional
        } else if ($this->show_custmizedtl == true && $this->show_notes == false) {
            $this->cutmz_column_width = 100;
        } else if ($this->show_custmizedtl == false && $this->show_notes == true) {
            $this->notes_column_width = 100;
        }


        $slog = SalesLog::model()->find("comments = 'Invoice ({$model->invoiceNum}) is printed'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->quote_id, $model->job->workorder->id, $model->quoteNum, 'Invoice', "Invoice ({$model->invoiceNum}) is printed", 1, 1, 1);
        }


        $pdf = Yii::createComponent('application.extensions.tcpdf.How2PayPDF', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . ' - Invoice');
        $pdf->SetSubject('Invoice');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();


        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;text-align:center;font-size:2em;">INVOICE</td></tr>
                    <tr><td style="width:100%;text-align:center;font-size:2em;">' . $model->invoiceNum . '</td></tr>    
                  </table><br/><br/>';

        $html .= '<table style="width:100%;border-bottom:1px solid black;border-top:1px solid black;padding:2px;">';

        $html .= '<tr><td style="width:50%;font-size:1.2em;">Quoatation Number : ' . $model->quoteNum . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Date : ' . date(GlobalVars::get(GlobalVars::DATE_FORMAT), strtotime($model->createdDtm)) . '</td></tr>';

        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Customer : ' . (!empty($model->customer) ? $model->customer->cusnam : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Job Number : ' . $model->job->jobNum . '  </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Address : ' . (!empty($model->customer) ? $model->customer->getFullAddress() : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Sales Order Number : ' . $model->job->workorder->salesorderNumber . ' </td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">E-mail :  ' . (!empty($model->customer) ? $model->customer->cusemail : '') . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">PO Number : ' . $model->job->customerpono . '</td></tr>';
        $html .= '<tr><td style="width:50%;font-size:1.2em;text-align:left;">Telephone :  ' . (!empty($model->customer) ? $model->customer->custel : '' ) . ' </td><td style="width:50%;font-size:1.2em;text-align:right;">Sales Person : ' . $model->job->ws_user . '</td></tr>';

        $html .= '</table><br/>';


        $html .= '<table style="width: 100%;height:100%;border:1px solid #000;padding:2px;">';
        $html .= '<tr style="width: 100%;background-color:#DDD;">
                    <td style="width: 100%;border:1px solid #000;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <th style="width: 5%;text-align: center;" >No</th>
                                <th style="width: 15%;text-align: center;" >Image</th>
                                <th style="width: ' . $this->prod_column_width . '%;text-align: center;">Product</th>';
        if ($show_decoration == true)
            $html .= '<th style="width: ' . $this->deco_column_width . '%;text-align: center;">Decoration</th>';

        $html .= '<th style="width: ' . $this->qty_column_width . '%;text-align: center;">Qty</th>';

        if ($show_price == true) {
            $html .= '<th style="width: 8%;text-align: center;">Selling Price Excluding GST</th>
                                <th style="width: 8%;text-align: center;">Selling Price Including GST</th>
                                <th style="width: 8%;text-align: center;">Total Excluding GST</th>
                                <th style="width: 8%;text-align: center;">Total Including GST</th>';
        }
        $html .= '</tr>

                        </table>
                    </td>

                </tr>';


        $invoicedetailsList = InvoiceDetail::model()->findAll("invoice_id = '{$model->id}'");

        $htmlbodyrows = '';

        foreach ($invoicedetailsList as $record) {
            $this->count++;
            $this->rowtype = $this->count % 2;
            $htmlbodyrows .= $this->getHtml($record, $show_price, $show_decoration);
        }

        $html .= $htmlbodyrows;




        $html .= '<tr style="width: 100%;background-color:#CCC;">
                    <td style="width: 100%;">
                        <table style="width: 100%;">
                            <tr style="width: 100%;">
                                <td style="width: 5%;"></td>
                                <td style="width: 15%;"></td>';
        if ($show_decoration == true)
            $html .= '<td style="width: ' . $this->prod_column_width . '%;"></td>';
        else
            $html .= '<td style="width: ' . $this->prod_column_width . '%;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';

        if ($show_decoration == true)
            $html .= '<td style="width: ' . $this->deco_column_width . '%;"><font style="font-size: 1.2em; font-weight: bold;">Total</font></td>';

        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;"><div style="font-size: 0.9em; font-weight: bold; text-align: center;" id="totprodqty"> ' . $model->getProductQtyTot() . '</div></td>';

        if ($show_price == true) {
            $html .= '<td style="width: 8%;text-align: right;"><div style="font-size: 0.9em; font-weight: bold; text-align: right;" id="totsellexvat"> ' . number_format($model->getSellingPriceExVat(), 2) . '</div></td>
                  <td style="width: 8%;"><div style="font-size: 0.9em; font-weight: bold; text-align: right;" id="totsellincvat"> ' . number_format($model->getSellingPriceIncVat(), 2) . '</div></td>
                  <td style="width: 8%;"><div style="font-size: 0.9em; font-weight: bold; text-align: right;" id="totexvattot"> ' . number_format($model->getTotExVat(), 2) . '</div>
                         
                      </td>
                  <td style="width: 8%;"><div style="font-size: 0.9em; font-weight: bold; text-align: right;width:100%;" id="totinvattot"> ' . number_format($model->getTotIncVat(), 2) . '</div>
                         
                   </td>';
        }

        $html .= '</tr>';


        $html .= '</table>';

        $html .= '<div style="text-align:right;width:100%;">
                        <table style="width:100%;">
                            <tr style="width:100%;">
                                <td style="width:80%;text-align:right;font-size:1.2em;">Sub Total :</td><td style="width:20%;text-align:right;font-size:1.2em;">' . number_format($model->getTotExVat(), 2) . '</td>
                            </tr>
                            <tr style="width:100%;">
                                <td style="width:80%;text-align:right;font-size:1.2em;">GST :</td><td style="width:20%;text-align:right;font-size:1.2em;">' . number_format($model->getGSTAmnt(), 2) . '</td>
                            </tr>
                            <tr style="width:100%;">
                                <td style="width:80%;text-align:right;font-size:1.2em;">Total Amount :</td><td style="width:20%;text-align:right;font-size:1.2em;">' . number_format($model->getTotIncVat(), 2) . '</td>
                            </tr>
                            <tr style="width:100%;">
                                <td style="width:80%;text-align:right;font-size:1.2em;">Paid Amount :</td><td style="width:20%;text-align:right;font-size:1.2em;">' . number_format($model->getPaidAmount(), 2) . '</td>
                            </tr>
                            <tr style="width:100%;">
                                <td style="width:80%;text-align:right;font-size:1.2em;">Balance Amount :</td><td style="width:20%;text-align:right;font-size:1.2em;">' . number_format($model->getBalanceAmnt(), 2) . '</td>
                            </tr>
                        </table>
                   </div>';

        $html .= '</td>


                </tr>';

        $html .= '</table>';

        $html .= '<br/><br/>';
        if (!empty($model->specialcmnt)) {
            $html .= '<table style="width:100%;border:1px solid #000;">';
            $html .= '<tr>
                    <td style="width:100%;font-size:1.2em;">' . $model->specialcmnt . '</td>
                    
                  </tr>';
            $html .= '</table><br/>';
        }

        $howtopayimgsrc = 'images/how_to_pay.jpg';
        $html .= '<table style="width:100%"><tr style="width:100%"><td style="width:100%"><img src="' . $howtopayimgsrc . '" /></td></tr></table>';

// data loading
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();


        $filename = str_replace("/", "-", $model->invoiceNum) . '.pdf';
        //$filename = time() . 'UID' . Yii::app()->user->id . '.pdf';
//Close and output PDF document
        $pdf->Output("files/{$filename}", 'F');

        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = 'INV';
        $fileinventory->ref_id = $model->id;

        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save();

        return $fileinventory;
    }

    var $rowtype = 0;
    var $count = 0;

    private function getHtml($detail, $show_price, $show_decoration) {

        $record = Workorderdetails::model()->findByPk($detail->wrkorderDtl_id);

        $html = '';

        //$count = 0;
        //$productline = ProductLine::model()->find(array('condition' => 'pdlpdl=:prodUniqId', 'params' => array(':prodUniqId' => $record->productsku)));
        //$decoration = Decoration::model()->find(array('condition' => 'decprtnam=:subDecorNam', 'params' => array(':subDecorNam' => $record->decprtnam)));
        $workordersizeqtycolors = Workorderdetailssizecolor::model()->findAll(array('condition' => 'workOrderDetailsId=:workOrderDetailsID', 'params' => array(':workOrderDetailsID' => $record->id)));



        //$rowcolor = "background-color:#DDD;";

        $html .= '<tr style="width:100%;" nobr="true">            
                <td style="border-bottom:1px solid #000;">
                    <table style="width:100%;">
                            <tr   style="width:100%;">
                                <td style="width: 5%;"> ' . $this->count . ' </td>
                                 <td style="width: 15%;"> <img src="' . $record->getImg() . '" width="50" height="50"/></td>';

        $html .= '<td style="width: ' . $this->prod_column_width . '%;"><div class="prodecs">';



        if (!empty($record->productsku)) {

            $html .= trim($record->productsku . '<br>' . $record->prdsrtdesc);
        } else {

            $html .= trim($record->custmproduct);
        }
        $html .= '</div></td>';


        if ($show_decoration == true) {
            $html .= '<td style="width: ' . $this->deco_column_width . '%;">';

            if (!empty($record->decprtnam)) {

                $html .= $record->decdesc;
            } else {

                $html .= $record->customdecoration;
            }



            $html .= '</td>';
        }

        $html .= '<td style="width: ' . $this->qty_column_width . '%;text-align: center;">
                                    ' . $detail->qty . '
                                </td>';


        if ($show_price == true) {
            $html .= '<td style="width: 8%;text-align: right;">
                                   ' . number_format($detail->sellPriceExVat, 2) . '
                                </td>
                                <td style="width: 8%;text-align: right;">
                                    ' . number_format($detail->sellPriceIncVat, 2) . '
                                </td>
                                <td style="width: 8%;text-align: right;">
                                    ' . number_format($detail->totExVat, 2) . '
                                </td>
                                <td style="width: 8%;text-align: right;">
                                    ' . number_format($detail->totIncVat, 2) . '
                                </td>  ';
        }

        $html .= '</tr>
                            <tr  style="width:100%;">
                                <td colspan="10" style="width:100%;">
                                    <div  style="width:100%;">
                                        <table style="width:100%;">';
        if ($this->show_custmizedtl != false || $this->show_notes != false) {
            $html .= '<tr style="width:100%;">
                                                <td style="width:100%;">
                                                    <table  style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">';
            if ($this->show_custmizedtl == true)
                $html .= '<th style="width:' . $this->cutmz_column_width . '%;text-align:center;" >Customization Details</th>';
            if ($this->show_notes == true)
                $html .= '<th style="width:' . $this->notes_column_width . '%;text-align:center;" >Notes</th>';


            $html .= ' </tr><tr style="width:100%;">';

            if ($this->show_custmizedtl == true)
                $html .= '<td style="width:' . $this->cutmz_column_width . '%;text-align:center;" >' . $record->customizationDetails . '</td>';
            if ($this->show_notes == true)
                $html .= '<td style="width:' . $this->notes_column_width . '%;text-align:center;" >' . $record->notes . '</td>';

            $html .= '</tr>
                                                    </table>
                                                </td> 
                                            </tr>';
        }
        $html .= '<tr style="width:100%">
                                                <td style="width:100%">
                                                    <div  style="width:100%;">
                                                        <table   style="width:100%;background-color:#ECFBD4;">
                                                        <tr style="width:100%;">
                                                            <th style="width:10%;text-align:center;">#</th>
                                                            <th style="width:30%;text-align:center;">Size</th>
                                                            <th style="width:30%;text-align:center;">Quantity</th>
                                                            <th style="width:30%;text-align:center;">Color</th>
                                                            
                                            </tr>';


        $countrow = 0;
        foreach ($workordersizeqtycolors as $row) {
            $countrow++;

            $html .= '<tr style="width:100%;" >
                                                    <td style="width:10%;text-align:center;">' . $countrow . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['size'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['qty'] . '</td>
                                                    <td style="width:30%;text-align:center;">' . $row['color'] . '</td>
                                                    
                                                </tr>';
        }

        $html .= ' </table></div></td></tr></table></div></td> </tr> </table>                        
                        </td>
                    </tr>';

        return $html;
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('t.id', $this->id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('customer_id', $this->customer_id);
        //$criteria->compare('amount',$this->amount);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('createdBy', $this->createdBy);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('invoiceNum', $this->invoiceNum, true);
        $criteria->compare('specialcmnt', $this->specialcmnt, true);
        $criteria->compare('duedate', $this->duedate, true);
        $criteria->compare('quoteNum', $this->quoteNum, true);

        $criteria->compare('amountExVat', $this->amountExVat, true);

        if (!User::isAdmin()) {
            $criteria->addCondition('createdBy = ' . Yii::app()->user->id);
        }

        //$criteria->order = 'duedate ASC, createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'duedate asc',
            )
        ));
    }

    public function searchXeroQueue() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('job', 'job.master');

        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.job_id', $this->job_id);
        $criteria->compare('t.customer_id', $this->customer_id);
        //$criteria->compare('amount',$this->amount);
        $criteria->compare('t.comments', $this->comments, true);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);
        $criteria->compare('t.createdBy', $this->createdBy);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.invoiceNum', $this->invoiceNum, true);
        $criteria->compare('t.specialcmnt', $this->specialcmnt, true);
        $criteria->compare('t.duedate', $this->duedate, true);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('master.mcusnam', $this->master_customer_search, true);

        $criteria->addCondition('t.xero_in_queue = 1');

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.duedate asc',
            )
        ));
    }

    public function getProductQtyTot() {
        $invoicedtls = InvoiceDetail::model()->findAll("invoice_id = '{$this->id}'");
        $totqty = 0;
        foreach ($invoicedtls as $dtl) {
            //$wrkorderDtl = Workorderdetails::model()->findByPk($dtl->wrkorderDtl_id);
            $totqty += $dtl->qty;
        }

        return $totqty;
    }

    public function getSellingPriceExVat() {

        $sql = "SELECT SUM(sellPriceExVat) AS sellPriceExVat  FROM invoice_details WHERE invoice_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellPriceExVat'];
    }

    public function getSellingPriceIncVat() {

        $sql = "SELECT SUM(sellPriceIncVat) AS sellPriceIncVat  FROM invoice_details WHERE invoice_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellPriceIncVat'];
    }

    public function getTotExVat() {
        $sql = "SELECT SUM(sellPriceExVat * qty) AS sellPriceExVat  FROM invoice_details WHERE invoice_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellPriceExVat'];
    }

    public function getTotIncVat() {
        $sql = "SELECT SUM(sellPriceIncVat * qty) AS sellPriceIncVat  FROM invoice_details WHERE invoice_id = {$this->id}";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        return $result['sellPriceIncVat'];
    }

    public function getGSTAmnt() {
        $totalexvat = $this->getTotExVat();
        $totalincvat = $this->getTotIncVat();
        $balance = $totalincvat - $totalexvat;

        return $balance;
    }

    public function getPaidAmount() {
        $sql = "select sum(value) as paid_amnt  from invoice_payments where invoice_id = '$this->id'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();

        $paidAmnt = $result['paid_amnt'];

        return $paidAmnt;
    }

    public function getBalanceAmnt() {
        $totincgst = $this->getTotIncVat();
        $paidamnt = $this->getPaidAmount();
        $balancetopay = $totincgst - $paidamnt;
        return $balancetopay;
    }

    public function isDOCompleted() {
        $invoiceDtls = InvoiceDetail::model()->findAll("invoice_id = '$this->id'");

        $isdocompleted = true;
        foreach ($invoiceDtls as $invDtl) {
            $dodtls = DeliveryDocketDetails::model()->findAll("invoiceDtlId = '{$invDtl->id}'");
            $totaldoqty = 0;
            foreach ($dodtls as $dtl) {
                $totaldoqty += $dtl->qty;
            }

            if ($invDtl->qty > $totaldoqty) {
                $isdocompleted = false;
            }
        }

        return $isdocompleted;
    }

    public function getPaymentCount() {
        $payments = InvoicePayment::model()->findAll(array('condition' => "invoice_id = '$this->id' and xero_updated <> 1"));
        return count($payments);
    }

    public function getRefinedDueDate() {
        if (!in_array($this->duedate, array('0000-00-00 00:00:00', null, '', '1970-01-01 00:00:00', '1969-12-12 00:00:00'))) {
            return date(GlobalVars::get("DateFormat"), strtotime($this->duedate));
        } else {
            return null;
        }
    }

    public function getNumberHtml() {
        $html = $this->invoiceNum;
        if ((int) SystemOptions::getOptions()->enbleXero) {
            return $this->invoiceNum . '<br />' . $this->getXerolabel();
        }

        if ((int) SystemOptions::getOptions()->enableMyob) {
            return $this->invoiceNum . '<br />' . $this->getMYOBLabel();
        }

        return $html;
    }

    public function getXeroDeepLink() {
        require 'vendor/autoload.php';
        $storage = new StorageClass();
        if (!$storage->getHasExpired() && $this->xero_invoice_id) {
            $organisation = XeroOrganisation::getOrganisation();

            return "https://go.xero.com/organisationlogin/default.aspx?shortcode={$organisation->short_code}&redirecturl=/AccountsReceivable/View.aspx?InvoiceID={$this->xero_invoice_id}";
        }

        return null;
    }

    public function getXerolabel() {
        return $this->xero_invoice_id ? "<span class='label label-info'>Xero</span>" : "<span class='label label-warning'>Xero</span>";
    }

    public function getMYOBLabel() {
        $html = '';
        if ($this->myob_uuid && empty($this->json_response)) {
            $html .= '<span class="label label-success" title="Successfully uploaded">MYOB</span>';
        } else if (!empty($this->json_response)) {
            $html .= '<span class="label label-important" title="Unsuccessful  upload">MYOB</span>';
        }

        return $html;
    }

    public function refreshTotal() {
        $amntExVat = 0;
        $amntIncVat = 0;

        foreach ($this->rel_details() as $dtl) {
            $amntExVat += $dtl->totExVat;
            $amntIncVat += $dtl->totIncVat;
        }

        $this->amountExVat = $amntExVat;
        $this->amountIncVat = $amntIncVat;
        return $this->save(false);
    }

    public function arrayDataProvider() {

        $lineItems = [];

        foreach ($this->rel_details() as $dtl) {
            $workorderdtl = $dtl->workorderdtl;
            $itmQty = $workorderdtl->prodQty;
            $accountCode = 200; //sales default
            if ($xeroAccount = XeroAccount::model()->findByPk($dtl->xero_account_id)) {
                $accountCode = $xeroAccount->code;
            }

            /* --------Product Item -------------- */
            $prodCostPrice = round($workorderdtl->prodCostPrice, 2);
            $prodMarkupRate = round($workorderdtl->prod_supmarg, 4);
            if (!$prodMarkupRate) {
                $prodMarkupRate = $workorderdtl->prodSupp->supmrate;
            }

            $prodMarkedUpPrice = $prodMarkupRate ? round(($prodCostPrice * $prodMarkupRate), 2) : $prodCostPrice;



            /* --------Product USD Freight -------------- */
            $usdFreight = $workorderdtl->prod_usd_freight;
            $usdFreightUnit = $usdFreight ? round($usdFreight / $itmQty, 2) : 0;
            $usdFreightPrice = $usdFreightUnit * $workorderdtl->productFrieghtMarkUpRate;







            /* Group USD price +  Product price */
            $groupProductPrice = $prodMarkedUpPrice + $usdFreightPrice;
            $groupProductPriceLineAmount = $groupProductPrice * $itmQty;
            $productLineItem = array(
                'description' => $workorderdtl->productsku . ' ' . $workorderdtl->prdsrtdesc,
                'quantity' => $itmQty,
                'unitAmount' => $groupProductPrice,
                'lineAmount' => $groupProductPriceLineAmount,
                'accountCode' => $accountCode,
            );

            array_push($lineItems, $productLineItem);




            /* -------- Product Decorations -------------- */
            $decoMaredUpPriceTotal = 0;
            $decoMaredUpPrice = 0;
            foreach ($workorderdtl->rel_multi_deco() as $data) {
                /* -------- decoration item -------------- */
                $decoPrice = ($data->cost_price ? ($data->cost_price * $data->sup_margin) : $data->cost_price);
                $logoSetupPrice = $data->logo_setup_unit_markedup_price;


                $decoLineItem = array(
                    'description' => $workorderdtl->productsku . ' ' . $data->decprtnam,
                    'quantity' => $itmQty,
                    'unitAmount' => $decoPrice,
                    'lineAmount' => $decoPrice * $itmQty,
                    'accountCode' => $accountCode,
                );

                array_push($lineItems, $decoLineItem);
                /* -------- logo setup charge -------------- */

                $logoSetupLineItem = array(
                    'description' => $workorderdtl->productsku . ' ' . $data->decprtnam . ' Logo Setup',
                    'quantity' => $itmQty,
                    'unitAmount' => $logoSetupPrice,
                    'lineAmount' => $logoSetupPrice * $itmQty,
                    'accountCode' => $accountCode,
                );

                array_push($lineItems, $logoSetupLineItem);




                //$decoMaredUpPrice += $decoPrice + $logoSetupPrice;
                //$decoMaredUpPriceTotal += ($decoPrice + $logoSetupPrice) * $itmQty;
            }



            /* -------- Product Other Cost -------------- */



            foreach ($workorderdtl->rel_other_costs() as $othercost) {
                $otherCostType = OtherCostType::model()->findByPk($othercost->other_cost_id);
                $unit_cost = $othercost->cost;
                if ($otherCostType->devide_by_qty) {
                    $unit_cost = $othercost->cost / $itmQty;
                }
                $otherCostWithMarkup = ($workorderdtl->other_cost_markup_rate ? ($unit_cost * $workorderdtl->other_cost_markup_rate) : $unit_cost);
                $otherCostLineItem = array(
                    'description' => $otherCostType->name,
                    'quantity' => $itmQty,
                    'unitAmount' => $otherCostWithMarkup,
                    'lineAmount' => ($otherCostWithMarkup * $itmQty),
                    'accountCode' => $accountCode,
                );

                array_push($lineItems, $otherCostLineItem);
            }
        }


        return new CArrayDataProvider($lineItems, array(
            'sort' => array('attributes' => array('description')),
            'pagination' => array('pageSize' => 100)
        ));
    }

    public function myobLastModified() {
        return null;
    }

    /**
     * @override
     * Synchronize current record with MYOB
     * @param MYOBApiConnector $myobConnector api connection
     * @return boolean success true, otherwise false
     */
    public function myobSynchronize(\MYOBApiConnector $myobConnector) {
        return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
    }

    public function setSynchronizer(\MYOBSynchronizer $synchronizer) {
        $this->synchronizer = $synchronizer;
    }

    public function toJsonString() {
        try {
            $myobsettings = MyobSetting::getSettings();

            $customerRawData = Yii::app()->db->createCommand()->select('cusmcussno')->from('customer')->where('cussno=:ID', array(':ID' => $this->customer_id))->queryRow();
            $masterCustomerRawData = Yii::app()->db->createCommand()
                            ->select('myob_uuid')->from('master_customer')->where('mcussno=:ID', array(':ID' => $customerRawData['cusmcussno']))->queryRow();

            $shipToAddress = '';

            $customerPO = '' . substr($this->job->customerpono, 0, 20);

            $freightTaxCode = MyobTaxCode::model()->findByPk($myobsettings->inv_freight_taxcode_id);


            $freightTaxCodeUid = $freightTaxCode ? $freightTaxCode->uuid : null;



            $invarr = array(
                'Number' => $this->invoiceNum,
                'Date' => date('Y-m-d H:i:s', strtotime($this->createdDtm)),
                'CustomerPurchaseOrderNumber' => $customerPO,
                'Customer' => array(
                    'UID' => $masterCustomerRawData['myob_uuid'],
                //"Name" => substr($model->customer->cusnam, 0, 50),
                //"DisplayID" => $model->customer->cuscus,
                ),
                'PromisedDate' => date('Y-m-d H:i:s', strtotime($this->duedate)),
                'BalanceDueAmount' => '0',
                'Status' => "Open",
                'IsTaxInclusive' => 'false',
                'ReferralSource' => $this->job->jobNum,
                'ShipToAddress' => isset($shipToAddress) ? $shipToAddress : '',
            );

            /* this will force  MYOB to update the record */
            /* this section will only be added if company file of this record ( myob guid) is same as the current login one */
            if ($this->myob_uuid && $this->myob_row_version && $this->myob_guid_uuid == trim(Yii::app()->session['myob_guid_uuid'])) {
                $invarr['UID'] = $this->myob_uuid;
                $invarr['RowVersion'] = $this->myob_row_version;
            }

            $taxCodeRawData = Yii::app()->db->createCommand()->select('uuid')->from('myob_tax_codes')->where('id=:ID', array(':ID' => ($this->myobTaxCodeId ?: $myobsettings->inv_taxcode_id)))->queryRow();
            $taxCodeUuid = $taxCodeRawData['uuid'];


            foreach ($this->rel_details() as $dtl) {




                if ($dtl->workorderdtl->product) {


                    if ($dtl->systemTaxRateId) { /* check if system tax code is mapped with MYOB tax code */
                        $myobTaxCode = MyobTaxCode::model()->find("systemTaxRateId = $dtl->systemTaxRateId");
                        if ($myobTaxCode) {
                            $taxCodeUuid = $myobTaxCode->uuid;
                        }
                    }

                    /*
                     * include product desc + deco desc + size info to description
                     * 
                     */
                    $description = '';
                    if ($dtl->workorderdtl->prdsrtdesc) {
                        $description .= $dtl->workorderdtl->prdsrtdesc;
                    }

                    if ($dtl->workorderdtl->decdesc) {
                        $description .= ' / ' . $dtl->workorderdtl->decdesc;
                    }

                    $sizeQtyColorRawData = Yii::app()->db->createCommand()->select('size, qty, color')->from('workorderdetailssizecolor')->where('workOrderDetailsId=:DETAILID', array(':DETAILID' => $dtl->workorderdtl->id))->queryAll();


                    if ($sizeQtyColorRawData) {
                        $description .= ' /Sizes:';
                        foreach ($sizeQtyColorRawData as $row) {
                            $description .= ' [ ' . $row['size'] . ' - ' . $row['qty'] . ' - ' . $row['color'] . ' ]';
                        }
                    }

                    $account = null;
                    if ($myobAccount = MyobAccount::model()->findByPk($dtl->myob_account_id)) {
                        $account = array(
                            "UID" => $myobAccount->uuid
                        );
                    }


                    $invarr['Lines'][] = array(
                        //"Type" => "Transaction",                
                        'Description' => substr($description, 0, 255),
                        'ShipQuantity' => $dtl->qty,
                        'UnitPrice' => $dtl->sellPriceExVat,
                        'Total' => $dtl->totExVat,
                        'Item' => array(
                            'UID' => $dtl->workorderdtl->product->myob_uuid,
                            'Number' => $dtl->workorderdtl->product->pdlsno,
                            'Name' => $dtl->workorderdtl->product->pdlpdl,
                        ),
                        'TaxCode' => array(
                            'UID' => $taxCodeUuid,
                        ),
                        $account
                    );
                }
            }
            $invarr['Subtotal'] = round($this->amountExVat, 2);

//			if ($freightTaxCode && $freightTaxCodeUid) {
//				/* need to provide both freight value and freight tax code otherwise MYOB responses 400 bad request! */
//				$invarr['Freight'] = round($this->postal_code_freight_charge, 2);
//
//				$invarr['FreightTaxCode'] = array(
//					"UID" => $freightTaxCodeUid,
//					'Code' => $freightTaxCode->code,
//				);
//			}
            $invarr['TotalTax'] = round(($this->amountIncVat - $this->amountExVat), 2);
            $invarr['TotalAmount'] = round($this->amountExVat, 2);
        } catch (Exception $x) {
            throw new Exception($x->getMessage(), $x->getCode());
        }
        return json_encode($invarr);
    }

    public function updateByMYOB(\MYOBResponse $response) {
        try {
            /* Here we only need to update the MYOB references for the invoice */
            Yii::app()->db->createCommand()
                    ->update('invoices', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "id=$this->id" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public function updateMYOBReferences(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('invoices', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "id=$this->id" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public static function createByMYOB(\MYOBResponse $response) {
        /* we don't pull the invoices from MYOB */
        return false;
    }

    public function reportMYOBError(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('invoices', array(
                        'json_response' => serialize($response),
                            ), "id=$this->id" /* where condition */
            );
            MYOBLog::writeLog(array(
                'table_name' => $this->tableName(),
                'table_reference_id' => $this->id,
                'log_type_id' => MYOBLog::LOG_TYPE_ERROR,
                'log_message' => serialize($response),
                'log_class' => __CLASS__,
                'log_line' => __LINE__,
            ));
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    /**
     * Format the MYOB error reported early to database and return it with some changes if needed
     * @return string MYOB error return in any string format
     */
    public function getMYOBError() {
        $obj = @unserialize($this->json_response); //if is not unserializeable, supress  E_NOTICE 
        return $obj ? MYOBResponse::formatError($obj) : '';
    }

    public function reportMYOBSuccess(\MYOBResponse $response) {
        MYOBLog::writeLog(array(
            'table_name' => $this->tableName(),
            'table_reference_id' => $this->id,
            'log_type_id' => MYOBLog::LOG_TYPE_SUCCESS,
            'log_message' => serialize($response),
            'log_class' => __CLASS__,
            'log_line' => __LINE__,
        ));
    }

}
