<?php

/**
 * This is the model class for table "invoice_details".
 *
 * The followings are the available columns in table 'invoice_details':
 * @property integer $id
 * @property integer $invoice_id
 * @property integer $quote_id
 * @property integer $job_id
 * @property integer $workorder_id
 * @property integer $wrkorderDtl_id
 * @property integer $qty
 * @property double $sellPriceExVat
 * @property double $sellPriceIncVat
 * @property double $totExVat
 * @property double $totIncVat
 * @property integer $xero_account_id
 * @property integer $hide_on_pdf
 */
class InvoiceDetail extends CActiveRecord {

    var $boxNumber;
    var $designNumber;
    var $DOQty;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return InvoiceDetail the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'invoice_details';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('invoice_id, quote_id, job_id, workorder_id, wrkorderDtl_id, qty, boxNumber, DOQty, xero_account_id, systemTaxRateId, hide_on_pdf', 'numerical', 'integerOnly' => true),
            array('sellPriceExVat, sellPriceIncVat, totExVat, totIncVat', 'numerical'),
            array('designNumber', 'length', 'max' => 100),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, invoice_id, quote_id, job_id, workorder_id, wrkorderDtl_id, qty, sellPriceExVat, sellPriceIncVat, totExVat, totIncVat, boxNumber, DOQty, designNumber', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorderdtl' => array(self::BELONGS_TO, 'Workorderdetails', 'wrkorderDtl_id'),
        );
    }

    public function rel_model() {
        return Invoice::model()->findByPk($this->invoice_id);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'invoice_id' => 'Invoice',
            'quote_id' => 'Quote',
            'job_id' => 'Job',
            'workorder_id' => 'Workorder',
            'wrkorderDtl_id' => 'Wrkorder Dtl',
            'qty' => 'Qty',
            'sellPriceExVat' => 'Selling Price Excluding GST',
            'sellPriceIncVat' => 'Selling Price Including GST',
            'totExVat' => 'Total Excluding GST',
            'totIncVat' => 'Total Including GST',
            'DOQty' => 'DO Qty',
			'xero_account_id'=> 'Xero Account',
			'systemTaxRateId' => 'Tax Rate'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('invoice_id', $this->invoice_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorder_id', $this->workorder_id);
        $criteria->compare('wrkorderDtl_id', $this->wrkorderDtl_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('sellPriceExVat', $this->sellPriceExVat);
        $criteria->compare('sellPriceIncVat', $this->sellPriceIncVat);
        $criteria->compare('totExVat', $this->totExVat);
        $criteria->compare('totIncVat', $this->totIncVat);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function getBalanceDOQty() {





        $invoicedtl = InvoiceDetail::model()->findByPk($this->id);

        $totalDOQty = 0;
        $deleiveryDocketDtls = DeliveryDocketDetails::model()->findAll("invoiceDtlId = '$this->id'");
        foreach ($deleiveryDocketDtls as $dtl) {
            $totalDOQty += $dtl->qty;
        }


        $totaldobalance = $invoicedtl->qty - $totalDOQty;


        return $totaldobalance;
    }
    
    public function getOnFlagsLabelsHtml() {
       

        $html = '';
        
        foreach (array('hide_on_pdf' => 'Hide on PDF') as $flag => $labelText) {
            //check flag on
            if($this->$flag) {
                $html .= '<span class="label label-success" >'.$labelText.'</span>';
            }
        }

        return $html;
    }

}
