<?php

/**
 * This is the model class for table "invoice_payments".
 *
 * The followings are the available columns in table 'invoice_payments':
 * @property integer $id
 * @property integer $quote_id
 * @property integer $workorder_id
 * @property integer $job_id
 * @property integer $invoice_id
 * @property string $signoff_terms
 * @property double $value
 * @property string $createddate
 * @property integer $createdby
 */
class InvoicePayment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return InvoicePayment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'invoice_payments';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('quote_id, workorder_id, job_id, invoice_id, createdby', 'numerical', 'integerOnly'=>true),
			array('value', 'numerical'),
                        array('value,signoff_terms,paiddate,createddate', 'required'),
			array('signoff_terms, createddate, xero_updated', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, quote_id, workorder_id, job_id, invoice_id, signoff_terms, value, createddate, createdby', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'quote_id' => 'Quote',
			'workorder_id' => 'Workorder',
			'job_id' => 'Job',
			'invoice_id' => 'Invoice',
			'signoff_terms' => 'Description',
			'value' => 'Amount',
			'createddate' => 'Createddate',
			'createdby' => 'Createdby',
                        'paiddate'=>'Payment Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('quote_id',$this->quote_id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('invoice_id',$this->invoice_id);
		$criteria->compare('signoff_terms',$this->signoff_terms,true);
		$criteria->compare('value',$this->value);
		$criteria->compare('createddate',$this->createddate,true);
		$criteria->compare('createdby',$this->createdby);
                
                $criteria->order = 'paiddate asc';

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}