<?php

/**
 * This is the model class for table "job_activity_flow".
 *
 * The followings are the available columns in table 'job_activity_flow':
 * @property integer $id
 * @property integer $job_id
 * @property integer $wrkorder_id
 * @property integer $wrkorderDtl_id
 * @property string $type
 * @property string $activity
 */
class JobActivityFlow extends CActiveRecord
{
    const ACTIVITY_MASTER_PO_CONSOLIDATED = "MASTER_PO_CONSOLIDATED";
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return JobActivityFlow the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_activity_flow';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, wrkorder_id, wrkorderDtl_id', 'numerical', 'integerOnly'=>true),
			array('type, activity', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, wrkorder_id, wrkorderDtl_id, type, activity', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'wrkorder_id' => 'Wrkorder',
			'wrkorderDtl_id' => 'Wrkorder Dtl',
			'type' => 'Type',
			'activity' => 'Activity',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('wrkorder_id',$this->wrkorder_id);
		$criteria->compare('wrkorderDtl_id',$this->wrkorderDtl_id);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('activity',$this->activity,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}