<?php

/**
 * This is the model class for table "job_artwork".
 *
 * The followings are the available columns in table 'job_artwork':
 * @property integer $id
 * @property string $workorderIDs
 * @property string $productColor
 * @property string $archiveImageLogo
 * @property string $decorationType
 * @property string $logoName
 * @property string $printSize
 * @property string $printColor
 * @property string $designNumber
 * @property integer $isRepeatDesign
 * @property string $comments
 * @property string $signOffTerms
 * @property string $jobType
 * @property integer $job_status_id
 * @property integer $approve_status_id
 * @property string $createdDate
 * @property string $approveDate
 * @property integer $job_id
 * @property integer $job_artwork_online_acceptence_log_id
 */
class JobArtwork extends CActiveRecord {

    public $filterPastDue = false;

    const JOB_TYPE_USE_EXIST = 'Use Exist';
    const JOB_TYPE_INTERNAL_JOB = 'Internal Job';
    const JOB_TYPE_PURCHASE_ARTOWRK = 'Purchase Artwork';

    public $artworkInventoryType = 'ArtworkApp';
    public $createddatefrom;
    public $createddateto;
    public $followupdatefrom;
    public $followupdateto;
    public $duedatefrom;
    public $duedateto;
    public $exist_artowrk_id;
    public $job_deco_id_str;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return JobArtwork the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'job_artwork';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('job_id, productColor, decorationType, printSize, printColor', 'required'),
            array('id, job_id, isRepeatDesign, job_status_id, approve_status_id, inventory_id, po_id, job_artwork_online_acceptence_log_id', 'numerical', 'integerOnly' => true),
            array('archiveImageLogo', 'length', 'max' => 255),
            array('productColor, decorationType, printSize, printColor, designNumber, jobType, artworkjobNum', 'length', 'max' => 100),
            array('logoName', 'length', 'max' => 200),
            array('job_deco_id_str, decorationPosition', 'length', 'max' => 255),
            array('comments, signOffTerms, createdDate, approveDate, job_deco_id_str,
                followupDate, rejectionNote, dueDate, 
                createddatefrom, createddateto, followupdatefrom, followupdateto, duedatefrom, duedateto, artworkInventoryType,
                filterPastDue', 'safe'),
            array('jobPriority', 'numerical', 'min' => 1),
            array('archiveImageLogo', 'file', 'types' => 'jpg, jpeg, gif, png', 'allowEmpty' => true, 'on' => 'insert,update'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, productColor, archiveImageLogo, decorationType, logoName, printSize, printColor, designNumber, 
                isRepeatDesign, comments, signOffTerms, jobType, job_status_id, approve_status_id, 
                createdDate, approveDate, decorationPosition, jobPriority', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
            'onlineAcceptenceLog' => array(self::BELONGS_TO, 'JobArtworkOnlineAcceptenceLog', 'job_artwork_online_acceptence_log_id'), 
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'productColor' => 'Product Colour',
            'archiveImageLogo' => 'Image Logo',
            'decorationType' => 'Decoration Type',
            'logoName' => 'Logo Name',
            'printSize' => 'Print Size',
            'printColor' => 'Print Color',
            'designNumber' => 'Design Number',
            'isRepeatDesign' => 'Repeat Design',
            'comments' => 'Comments',
            'signOffTerms' => 'Sign Off Terms',
            'jobType' => 'Job Type',
            'job_status_id' => 'Job Status',
            'approve_status_id' => 'Approve Status',
            'createdDate' => 'Created Date',
            'approveDate' => 'Approve Date',
            'followupDate' => 'Follow-Up Date',
            'dueDate' => 'Due Date',
            'po_id' => 'Purchase Order',
            'rejectionNote' => 'Reason to reject',
            'decorationPosition' => 'Decoration Position',
            'jobPriority' => 'Job Priority'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('productColor', $this->productColor, true);
        $criteria->compare('archiveImageLogo', $this->archiveImageLogo, true);
        $criteria->compare('decorationType', $this->decorationType, true);
        $criteria->compare('logoName', $this->logoName, true);
        $criteria->compare('printSize', $this->printSize, true);
        $criteria->compare('printColor', $this->printColor, true);
        $criteria->compare('designNumber', $this->designNumber, true);
        $criteria->compare('isRepeatDesign', $this->isRepeatDesign);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('signOffTerms', $this->signOffTerms, true);
        $criteria->compare('jobType', $this->jobType, true);
        $criteria->compare('inventory_id', $this->inventory_id);
        $criteria->compare('po_id', $this->po_id);

        $criteria->compare('job_status_id', $this->job_status_id);
        $criteria->compare('approve_status_id', $this->approve_status_id);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('approveDate', $this->approveDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('jobPriority', $this->jobPriority);

        if ($this->filterPastDue == true) {
            $criteria->addCondition("job_status_id <> 11 and dueDate < NOW()");
        }

        //$criteria->order = "DATE_FORMAT(dueDate, '%Y-%m-%d') desc";


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'dueDate DESC',
            )
        ));
    }

    public function searchOutstanding() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('productColor', $this->productColor, true);
        $criteria->compare('archiveImageLogo', $this->archiveImageLogo, true);
        $criteria->compare('decorationType', $this->decorationType, true);
        $criteria->compare('logoName', $this->logoName, true);
        $criteria->compare('printSize', $this->printSize, true);
        $criteria->compare('printColor', $this->printColor, true);
        $criteria->compare('designNumber', $this->designNumber, true);
        $criteria->compare('isRepeatDesign', $this->isRepeatDesign);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('signOffTerms', $this->signOffTerms, true);
        $criteria->compare('jobType', $this->jobType, true);
        $criteria->compare('inventory_id', $this->inventory_id);
        $criteria->compare('po_id', $this->po_id);

        $criteria->compare('job_status_id', $this->job_status_id);
        $criteria->compare('approve_status_id', $this->approve_status_id);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('approveDate', $this->approveDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);


        //find from created date
        if (!empty($this->createddatefrom) && !empty($this->createddateto)) {
            $criteria->addCondition("DATE_FORMAT(createdDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->createddatefrom)) . "' and DATE_FORMAT(createdDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->createddateto)) . "'");
        } else if (!empty($this->createddatefrom) && empty($this->createddateto)) {
            $today = date('Y-m-d', strtotime('now'));
            $criteria->addCondition("DATE_FORMAT(createdDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->createddatefrom)) . "' and DATE_FORMAT(createdDate, '%Y-%m-%d') <= '$today'");
        } else if (empty($this->createddatefrom) && !empty($this->createddateto)) {

            $criteria->addCondition("DATE_FORMAT(createdDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->createddateto)) . "'");
        }

        //search from followup date
        if (!empty($this->followupdatefrom) && !empty($this->followupdateto)) {
            $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->followupdatefrom)) . "' and DATE_FORMAT(followupDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->followupdateto)) . "'");
        } else if (!empty($this->followupdatefrom) && empty($this->followupdateto)) {
            $today = date('Y-m-d', strtotime('now'));
            $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->followupdatefrom)) . "' and DATE_FORMAT(followupDate, '%Y-%m-%d') <= '$today'");
        } else if (empty($this->followupdatefrom) && !empty($this->followupdateto)) {

            $criteria->addCondition("DATE_FORMAT(followupDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->createddateto)) . "'");
        }

        //search from due date
        if (!empty($this->duedatefrom) && !empty($this->duedateto)) {
            $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->duedatefrom)) . "' and DATE_FORMAT(dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->duedateto)) . "'");
        } else if (!empty($this->duedatefrom) && empty($this->duedateto)) {
            $today = date('Y-m-d', strtotime('now'));
            $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->duedatefrom)) . "' and DATE_FORMAT(dueDate, '%Y-%m-%d') <= '$today'");
        } else if (empty($this->duedatefrom) && !empty($this->duedateto)) {

            $criteria->addCondition("DATE_FORMAT(dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->duedateto)) . "'");
        }

        $criteria->addCondition("job_status_id in (1,2,4,5,10,14,15,16,18,22,23,25)");

        $criteria->order = "DATE_FORMAT(createdDate, '%Y-%m-%d') desc";

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function searchDue($nextdays) {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);

        $criteria->compare('productColor', $this->productColor, true);
        $criteria->compare('archiveImageLogo', $this->archiveImageLogo, true);
        $criteria->compare('decorationType', $this->decorationType, true);
        $criteria->compare('logoName', $this->logoName, true);
        $criteria->compare('printSize', $this->printSize, true);
        $criteria->compare('printColor', $this->printColor, true);
        $criteria->compare('designNumber', $this->designNumber, true);
        $criteria->compare('isRepeatDesign', $this->isRepeatDesign);
        $criteria->compare('comments', $this->comments, true);
        $criteria->compare('signOffTerms', $this->signOffTerms, true);
        $criteria->compare('jobType', $this->jobType, true);
        $criteria->compare('inventory_id', $this->inventory_id);
        $criteria->compare('po_id', $this->po_id);

        $criteria->compare('job_status_id', $this->job_status_id);
        $criteria->compare('approve_status_id', $this->approve_status_id);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('approveDate', $this->approveDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);

        $criteria->addCondition("dueDate between NOW() and DATE_ADD(NOW(), INTERVAL {$nextdays} DAY)");

        $criteria->order = "DATE_FORMAT(dueDate, '%Y-%m-%d') ASC";

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function generatePDF() {
        $model = $this;

        $url = Yii::app()->createUrl('jobArtwork/print', array("id" => $model->id));
        $link = CHtml::link($model->artworkjobNum, $url, array('target' => '_blank'));
        $slog = SalesLog::model()->find("comments = 'Artwork approval PDF($link) is generated'");

        if (empty($slog)) {
            SalesLog::createSalesLog($model->job->quote_id, $model->job->workorder_id, $model->job->quoteNum, 'Jobs', "Artwork approval PDF($link) is generated", 1, 1, 1);
            SalesLog::createTblLog($model->id, 'JobArtwork', "Artwork approval PDF($link) is generated");
        }

        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');
// create new PDF document
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor('Aranxa');
        $pdf->SetTitle(Yii::app()->name . " - Artwork Job");
        $pdf->SetSubject('Artwork Job');
// set default header data



        $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, null, null);

        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetFont('helvetica', '', 8, 'helvetica,Arial, sans-serif');
        $pdf->SetTextColor(0, 0, 0);
        $pdf->AddPage();

        $html .= '<h1 align="center">IMPORTANT - ARTWORK APPROVAL.</h1>';
        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Date :          &nbsp;&nbsp;' . date(GlobalVars::get(GlobalVars::DATE_FORMAT)) . '</td></tr>  
                    <tr><td style="width:100%;font-size:1.2em;font-weight:bold;">To :&nbsp;&nbsp;&nbsp;&nbsp;' . $model->job->customer->cusnam . '</td></tr> 
                    <tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Company :       &nbsp;&nbsp;</td></tr>   
                    <tr><td style="width:100%;font-size:1.2em;font-weight:bold;">From :    &nbsp;&nbsp;&nbsp;  ' . User::model()->findByPk($model->job->prd_cordinator_id)->username . '</td></tr>   
                  </table><br/><br/>';

        $html .= '<p>&nbsp;</p>';
        $html .= '<br/><br/><p style="font-size:1.4em;text-align:center;">
                    Below is the <b style="text-decoration: underline;">final artwork</b> for your order. It is very important that you
                    <b style="text-decoration: underline;">carefully check all details</b> including <b style="text-decoration: underline;">spelling, telephone no, logo, colours, size etc</b>
                    </p>';
        $html .= '<p style="font-size:1em;text-align:center;">Please note : Change of mind may incur a minimum charge of $30.</p>';

        $html .= '<h3>ARTWORK DETAILS</h3>';
        //artwork details
        $html .= '<table style="width:100%;">';

        $artworkdetails = JobArtworkDetail::model()->findAll(array('condition' => "job_artowk_id = '{$model->id}'"));
        $items = '';
        foreach ($artworkdetails as $dtl) {
            $items .= $dtl->workorderDtl->productsku . '(' . $dtl->workorderDtl->prdsrtdesc . ') - ';
        }

        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Item : ' . $items . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Decoration Type : ' . $model->decorationType . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Decoration Position : ' . $model->decorationPosition . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Print Size :  ' . $model->printSize . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Product Colour : ' . $model->productColor . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Print Colour :  ' . $model->printColor . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Design # : ' . $model->designNumber . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Repeat Design : ' . ($model->isRepeatDesign == true ? 'Yes' : 'No') . '</td></tr>';
        $html .= '<tr><td style="width:100%;font-size:1.2em;font-weight:bold;">Comment : ' . $model->comments . '</td></tr>';
        if (!empty($model->archiveImageLogo) && file_exists('images/artwork/job/' . $model->artworkjobNum . '/' . $model->archiveImageLogo)) {
            $html .= '<tr><td style="width:100%;font-size:1.2em;text-align:center;"><img src="images/artwork/job/' . $model->artworkjobNum . '/' . $model->archiveImageLogo . '" style="width:250px;"/></td></tr>';
        } else {
            $html .= '<tr><td style="width:100%;font-size:1.2em;text-align:center;">Logo Image Not Set</td></tr>';
        }
        $html .= '</table><br/>';

        $html .= '<br/><br/><br/><br/><table style="width:100%;">';

        $html .= '<tr nobr="true">
                    <td style="width:100%;font-size:1.2em;border-bottom:1px solid #000;font-weight:bold;">Sign Off Terms</td>                    
                  </tr>';
        $signofflogs = SignOffLog::model()->findAll(array('condition' => "model = 'JobArtwork' and model_id = '{$model->id}'", 'order' => 'id desc'));
        foreach ($signofflogs as $signoff) {
            $signoffterm = SignOffTerms::model()->findByPk($signoff->sign_off_id);

            $signofftexttoprint = '';
            if (!empty($signoff->sign_off_terms)) {
                $signofftexttoprint = $signoff->sign_off_terms;
            } else if (!empty($signoffterm)) {
                $signofftexttoprint = $signoffterm->term;
            }
            $html .= '<tr>
                        <td style="width:100%;font-size:1.2em;">' . nl2br($signofftexttoprint) . '</td>                    
                      </tr><tr><td>&nbsp;</td></tr>';
        }



        $html .= '</table><br/>';

        $html .= '<br/><p style="font-size:1.4em;text-align:center;font-weight:bold;text-decoration: underline;margin:20px;">
                            YES - All of the above details have been checked and are correct. 
                            I authorise the production of this order.
                       </p>';

        $html .= '<table style="width:100%;">
                    <tr><td style="width:100%;font-size:1.3em;">Authorised by - Name : ____________________________________________________ </td></tr>
                    <tr><td style="width:100%;font-size:1.3em;">&nbsp;</td></tr>
                    <tr><td style="width:100%;font-size:1.3em;">Signature:___________________________________Date:__________________________</td></tr>
                  </table><br/><br/>';

        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();

        $filename = $model->artworkjobNum . '.pdf';
        $pdf->Output("files/{$filename}", 'F');
//Close and output PDF document
        $fileinventory = new FileInventory();
        $fileinventory->filename = $filename;
        $fileinventory->type = $this->artworkInventoryType;
        $fileinventory->ref_id = $model->id;

        $fileinventory->createdBy = Yii::app()->user->id;
        $fileinventory->createdDtm = date("Y-m-d g:i");

        $fileinventory->save(false);

        return $fileinventory;
    }

    public function getFlowStatus() {
        if ($this->job_status_id == 11)
            return 'complete';

        if (!empty($this->dueDate)) {
            if ($this->job_status_id != 11 && date('Y-m-d', strtotime('now')) > date('Y-m-d', strtotime($this->dueDate))) {
                return 'due';
            } else {
                return 'notcomplete';
            }
        } else {
            return 'notcomplete';
        }
    }
    
    public function getSubStringComment(){
        if(strlen($this->comments) > 50){
            $substrComnt = substr($this->comments, 0, 50);
            $substrComnt .= '...';
            return $substrComnt;
        }else{
            return $this->comments;
        }
    }


    /**
	 * Generate online acceptance link for the quote
	 * @return string quote acceptance link
	 */
	public function generateOnlineAcceptLink()
	{	
		
		$linkSecret = AcceptanceLinkStringGenerator::randomString();
		$acceptURL = Yii::app()->createAbsoluteUrl('jobArtworkOnlineAcceptence/index&id=' . $linkSecret, array(), 'http');
		
		$logId = JobArtworkOnlineAcceptenceLog::write(array(
			'job_id' => $this->job_id,
            'job_artwork_id' => $this->id,
			'link_secret' => $linkSecret,
			'link_expire_in' => date('Y-m-d H:i:s', time() + (3600*24*7)), // expire in 7 days
			'link_active' => WorkorderOnlineAcceptenceLog::LINK_STATUS_ACTIVE,
			'status_id' => WorkorderOnlineAcceptenceLog::LOG_STATUS_LINK_GENERATED,
			'accept_url' => $acceptURL
		));
		
		$this->job_artwork_online_acceptence_log_id = $logId;
		$this->save();
		
		return $acceptURL;
	}


    public function updateFollowUpStatusByOnlineAcceptance(int $status)
	{		
		switch ($status) {

			case JobArtworkOnlineAcceptenceLog::LOG_STATUS_SENT:
				
				$this->approve_status_id = Status::SYS_STATUS_PENDING_APPROVAL;
				break;
			case JobArtworkOnlineAcceptenceLog::LOG_STATUS_ACCEPT:
				
				$this->approve_status_id = Status::SYS_STATUS_CONFIRMED;
				break;
			case JobArtworkOnlineAcceptenceLog::LOG_STATUS_DECLINE:
				
				$this->approve_status_id = Status::SYS_STATUS_CANCELLED;
				break;
		}
	}

}