<?php

/**
 * This is the model class for table "job_artwork_details".
 *
 * The followings are the available columns in table 'job_artwork_details':
 * @property integer $id
 * @property integer $job_artowk_id
 * @property integer $job_id
 * @property integer $workorder_id
 * @property integer $workorder_detial_id
 * @property integer $job_decoration_id
 */
class JobArtworkDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return JobArtworkDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_artwork_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_artowk_id, job_id, workorder_id, workorder_detial_id, job_decoration_id', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_artowk_id, job_id, workorder_id, workorder_detial_id, job_decoration_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorder_detial_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_artowk_id' => 'Job Artowk',
			'job_id' => 'Job',
			'workorder_id' => 'Workorder',
			'workorder_detial_id' => 'Workorder Detial',
			'job_decoration_id' => 'Job Decoration',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_artowk_id',$this->job_artowk_id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('workorder_detial_id',$this->workorder_detial_id);
		$criteria->compare('job_decoration_id',$this->job_decoration_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}