<?php

/**
 * This is the model class for table "job_artwork_subjobs".
 *
 * The followings are the available columns in table 'job_artwork_subjobs':
 * @property integer $id
 * @property integer $subArtworkJobId
 * @property integer $jobArtworkId
 * @property string $note
 * @property integer $statusId
 * @property string $statusDate
 * @property integer $createdBy
 */
class JobArtworkSubjob extends CActiveRecord {
    public $job_search;
    public $jobartwork_search;
    public $subjob_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return JobArtworkSubjob the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'job_artwork_subjobs';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('subArtworkJobId, jobArtworkId, statusId, createdBy, sortOrderVal', 'numerical', 'integerOnly' => true),
            array('note, statusDate, dueDate, job_search, jobartwork_search, subjob_search', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, subArtworkJobId, jobArtworkId, note, statusId, statusDate, createdBy, 
                dueDate, job_search, jobartwork_search, subjob_search', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'artworkJob' => array(self::BELONGS_TO, 'JobArtwork', 'jobArtworkId'),
            'subjob' => array(self::BELONGS_TO, 'SubArtworkJob', 'subArtworkJobId'),
            'RelStatus' => array(self::BELONGS_TO, 'Status', 'statusId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'subArtworkJobId' => 'Sub Job',
            'jobArtworkId' => 'Job Artwork',
            'note' => 'Note',
            'statusId' => 'Status',
            'statusDate' => 'Status Date',
            'createdBy' => 'Created By',
            'sortOrderVal' => 'Order',
            'dueDate' => 'Due Date',
            'job_search'=>'Job',
            'jobartwork_search'=>'Artwork Job',
            'subjob_search'=>'Sub Job'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
         $criteria->with = array( 'artworkJob.job','subjob');
        $criteria->compare('id', $this->id);
        $criteria->compare('subArtworkJobId', $this->subArtworkJobId);
        $criteria->compare('jobArtworkId', $this->jobArtworkId);
        $criteria->compare('note', $this->note, true);
        $criteria->compare('statusId', $this->statusId);
        if(!empty($this->statusDate))
        $criteria->compare('t.statusDate', date('Y-m-d',  strtotime($this->statusDate)), true);
        if(!empty($this->createdBy))
        $criteria->compare('t.createdBy', $this->createdBy);
        $criteria->compare('sortOrderVal', $this->sortOrderVal);
        if(!empty($this->dueDate))
            $criteria->compare('t.dueDate', date('Y-m-d',  strtotime($this->dueDate)), true);
        $criteria->compare('job.jobNum', $this->job_search, true);
        $criteria->compare('artworkjobNum', $this->jobartwork_search, true);
        $criteria->compare('subjob.name', $this->subjob_search, true);
        
        $criteria->order = 'sortOrderVal asc';

        $pageSize = (int)GlobalVars::get('RecordsViewPerPage');
        
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
             'pagination' => array('pageSize' => $pageSize),
        ));
    }
    
    public function searchReport() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
         $criteria->with = array( 'artworkJob.job','subjob');
        $criteria->compare('id', $this->id);
        $criteria->compare('subArtworkJobId', $this->subArtworkJobId);
        $criteria->compare('jobArtworkId', $this->jobArtworkId);
        $criteria->compare('note', $this->note, true);
        $criteria->compare('statusId', $this->statusId);
        if(!empty($this->statusDate))
        $criteria->compare('t.statusDate', date('Y-m-d',  strtotime($this->statusDate)), true);
        if(!empty($this->createdBy))
        $criteria->compare('t.createdBy', $this->createdBy);
        $criteria->compare('sortOrderVal', $this->sortOrderVal);
        if(!empty($this->dueDate))
            $criteria->compare('t.dueDate', date('Y-m-d',  strtotime($this->dueDate)), true);
        $criteria->compare('job.jobNum', $this->job_search, true);
        $criteria->compare('artworkjobNum', $this->jobartwork_search, true);
        $criteria->compare('subjob.name', $this->subjob_search, true);
        
        $criteria->order = 't.id desc';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    

}