<?php

/**
 * This is the model class for table "job_decorations".
 *
 * The followings are the available columns in table 'job_decorations':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorderDtl_id
 * @property integer $isInternalJob
 * @property integer $internalJob_id
 * @property string $decoJobType
 * @property integer $po_id
 * @property integer $qty
 * @property string $notation
 * @property string $followupDate
 * @property string $duedate
 * @property integer $status_id
 * @property integer $user_id
 * @property integer $lineOrder order of detail lines
 */
class JobDecorations extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return JobDecorations the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'job_decorations';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('job_id, workorderDtl_id, isInternalJob, internalJob_id, po_id, artwork_id, qty, decoQty, status_id, user_id, lineOrder', 'numerical', 'integerOnly' => true),
            array('decoJobType,decosupref', 'length', 'max' => 45),
            array('notation,decprtnam,customdecoration,customizationDetails', 'length', 'max' => 255),
            array('followupDate, duedate, createdDtm, decdesc', 'safe'),
            array('decoCostPrice, logo_setup', 'type', 'type' => 'float'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, job_id, workorderDtl_id, isInternalJob, internalJob_id, decoJobType, po_id,
                artwork_id, qty, notation, followupDate, duedate, createdDtm, status_id, 
                user_id, decprtnam, decdesc, customdecoration, decoQty, decoCostPrice, decosupref, customizationDetails', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorderDtl_id'),
            'decoSupp' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('decosupref' => 'supsup_fref')),
            'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'job_id' => 'Job',
            'workorderDtl_id' => 'Workorder Dtl',
            'isInternalJob' => 'Is Internal Job',
            'internalJob_id' => 'Internal Job',
            'decoJobType' => 'Deco Job Type',
            'po_id' => 'Po',
            'qty' => 'Qty',
            'notation' => 'Notation',
            'followupDate' => 'Followup Date',
            'duedate' => 'Duedate',
            'status_id' => 'Status',
            'user_id' => 'User',
            'createdDtm' => 'Created Date',
            'artwork_id' => 'Artwork ID',
            'decprtnam'=>'Decoration',
            'lineOrder' => 'Line Order'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorderDtl_id', $this->workorderDtl_id);

        $criteria->compare('decprtnam', $this->decprtnam, true);
        $criteria->compare('decdesc', $this->decdesc, true);
        $criteria->compare('customdecoration', $this->customdecoration, true);
        $criteria->compare('decoQty', $this->decoQty, true);
        $criteria->compare('decoCostPrice', $this->decoCostPrice, true);
        $criteria->compare('decosupref', $this->decosupref, true);
        $criteria->compare('customizationDetails', $this->customizationDetails, true);

        $criteria->compare('isInternalJob', $this->isInternalJob);
        $criteria->compare('internalJob_id', $this->internalJob_id);
        $criteria->compare('decoJobType', $this->decoJobType, true);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('duedate', $this->duedate, true);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        
        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }
    
    public function getProductDecorationRaw() {
        
        $deco = Decoration::model()->find(array('condition'=>"decprtnam = '$this->decprtnam'"));
        
        $decorationdesc = '<a href="' . Yii::app()->createUrl("decoration/view", array("id" => $deco->decsno)) . '" target="_blank">CODE [ ' . $this->decprtnam . ' ]</a><br>';
       
       $decorationdesc .=  nl2br($this->decdesc);
       
        
         $row .= $decorationdesc .  nl2br($this->getCustomizationDetail()) .  nl2br($this->getDecoSupplierLink());


        return $row;
    }

    public function getCustomizationDetail() {
        $html = "<div><table>";
        $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Customization Details</th></tr>";

        if (!empty($this->customizationDetails)) {
            $html .= "<tr><td style='text-align:center'>{$this->customizationDetails}</td></tr>";
        } else {
            $html .= "<tr><td style='text-align:center'>--empty--</td></tr>";
        }


        $html .= "</table></div>";
        return $html;
    }

    public function getDecoSupplierLink() {
        $html = "<div><table>";
        $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Supplier</th></tr>";
        $html .= "<tr><td style='text-align:center'>" . CHtml::link($this->decoSupp->supnam, array('supplier/view', 'id' => $this->decoSupp->supsno)) . "</td></tr>";
        $html .= "</table></div>";

        return $html;
    }

    public function getJobActivityFlow($type) {
        $flowstr = '';
        $lastactivity = '';
        $artworkdtl = null;
        $artworkPO = null;

        $job = Jobs::model()->findByPk($this->job_id);

        $flows = JobActivityFlow::model()->findAll("type = '$type' and flowjob_id = '$this->id'");

        $flowstr .= '<ul style="font-size:0.9em;">';
        $artwokids = array();
        foreach ($flows as $flow) {

            if ($type == 'Decoration') {

                if ($flow->activity == 'Artwork Created') {
                    $artworkdtl = JobArtworkDetail::model()->findAll(array('condition' => "job_decoration_id = '{$this->id}'"));
                    foreach ($artworkdtl as $dtl) {
                        if (!in_array($dtl->job_artowk_id, $artwokids)) {
                            $artwokids[] = $dtl->job_artowk_id;
                            $artwork = JobArtwork::model()->find(array('condition' => "id = '{$dtl->job_artowk_id}' and job_status_id <> 3"));
                            $flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobArtwork/view", array("id" => $artwork->id)) . '">ARTWORK:' . $artwork->artworkjobNum . '</a>';
                            $flowstr .= '<br>[';
                            $flowstr .= '<br>' . Status::getStatusName($artwork->job_status_id) . '<br>';

                            if ($artwork->po_id > 0) {

                                $artworkPO = PurchaseOrders::model()->findByPk($artwork->po_id);

                                $flowstr .= '<br>(<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $artworkPO->id)) . '">' . $artworkPO->poNum . '</a>)';
                                $grn = GoodsReceived::model()->find(array('condition' => "po_id = '$artworkPO->id'"));
                                if (!empty($grn)) {
                                    $flowstr .= '<br>(<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)';
                                } else {
                                    $flowstr .= '<br>Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $artwork->po_id)) . '">Goods Receive</a>';
                                }
                            } else if ($artwork->jobType == JobArtwork::JOB_TYPE_INTERNAL_JOB && $artwork->job_status_id == 11) {

                                $flowstr .= '-----<b>Job Done</b>----';
                            }

                            $subjobs = JobArtworkSubjob::model()->findAll(array('condition' => "jobArtworkId = $dtl->job_artowk_id", 'order' => "sortOrderVal asc"));
                            if (count($subjobs) > 0) {

                                $flowstr .= '<ul style="margin-left:30px;">';
                                $flowstr .= '<br>Sub Jobs<br>[';
                                foreach ($subjobs as $task) {
                                    $flowstr .= '<li>' . $task->subjob->name . '&nbsp;-&nbsp;(' . $task->RelStatus->name . ')</li>';
                                }
                                $flowstr .= '<br>]';
                                $flowstr .= '</ul>';
                            }

                            $flowstr .= '<br>]<br>';


                            $flowstr .= '</li>';
                        }
                    }
                }
            } else {
                $flowstr .= '<li >' . $flow->activity . '</li>';
            }


            $lastactivity = $flow->activity;
        }

        if ($this->status_id == 11) {
            $flowstr .= '-----<b>Job Done</b>----';
        }



        if ($type == 'Decoration' && $lastactivity == '') {
            $flowstr .= '<li >Next &#187; <br>Create Artwork<br>Use Exist Artwork<br>Purchase Artwork</li>';
        }



        if (in_array($lastactivity, array('PO Created', 'Artwork PO Created'))) {

            if ($lastactivity == 'Artwork PO Created') {
                $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $this->po_id)) . '">Goods Receive</a></li>';
            }
        }





        if (in_array($lastactivity, array('Artwork Received', 'Artwork Created')) && $this->status_id != 11) {
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobDecorations/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
        }

        if (in_array($lastactivity, array('Job End'))) {

            $inventory_id = null;
            if (!empty($artworkdtl)) {
                $artworkinventory = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                $inventory_id = $artworkinventory->id;
            } else if (!empty($artworkPO)) {
                $artworkinventory = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");
                $inventory_id = $artworkinventory->id;
            }
            $flowstr .= '<li >&#187;End</li>';
            //$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("purchaseOrders/createEmbTapePO", array("id" => $inventory_id, "type" => "po_emb_tape")) . '">Purchase Embroidery Tape</a></li>';
            //$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobs/endDecoration",array("job_id"=>$job->id,"wodtls_id"=>  $this->workorderDtl_id, "jd_id"=>  $this->id)) . '">End Job</a></li>';
        }



        if ($lastactivity == 'PO Emb Tape') {
            $pos = PurchaseOrders::model()->findAll("job_id = '{$job->id}' and poType = 'Purchase  Embroidery Tape' ");
            $po_id = null;
            foreach ($pos as $po) {
                $podtl = PurchaseOrderDetails::model()->find("po_id = '{$po->id}' and workorderDtl_id = '{$this->workorderDtl_id}'");
                if (!empty($podtl)) {
                    $po_id = $po->id;
                    break;
                }
            }
            $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $po_id)) . '">Receive Embroidery Tape</a></li>';
        }

        if (in_array($lastactivity, array('Emb Tape Received', 'Job End', 'Artwork Allocated'))) {
            $flowstr .= '<li >&#187;End</li>';
        }



        $flowstr .= '</ul>';

        return $flowstr;
    }
	
	public function getJobActivityFlowForPDF($type) {
        $flowstr = '';
        $lastactivity = '';
        $artworkdtl = null;
        $artworkPO = null;

        $job = Jobs::model()->findByPk($this->job_id);

        $flows = JobActivityFlow::model()->findAll("type = '$type' and flowjob_id = '$this->id'");

        $flowstr .= '';
        $artwokids = array();
        foreach ($flows as $flow) {

            if ($type == 'Decoration') {

                if ($flow->activity == 'Artwork Created') {
                    $artworkdtl = JobArtworkDetail::model()->findAll(array('condition' => "job_decoration_id = '{$this->id}'"));
                    foreach ($artworkdtl as $dtl) {
                        if (!in_array($dtl->job_artowk_id, $artwokids)) {
                            $artwokids[] = $dtl->job_artowk_id;
                            $artwork = JobArtwork::model()->find(array('condition' => "id = '{$dtl->job_artowk_id}' and job_status_id <> 3"));
							$flowstr .= 'ARTWORK:' . $artwork->artworkjobNum;
                            $flowstr .= '<br>[';
                            $flowstr .= '<br>' . Status::getStatusName($artwork->job_status_id) . '<br>';

                            if ($artwork->po_id > 0) {

                                $artworkPO = PurchaseOrders::model()->findByPk($artwork->po_id);

                                $flowstr .= '<br>(' . $artworkPO->poNum . ')';
                                $grn = GoodsReceived::model()->find(array('condition' => "po_id = '$artworkPO->id'"));
                                if (!empty($grn)) {
                                    $flowstr .= '<br>(' . $grn->grnnum . ')';
                                } 
                            } else if ($artwork->jobType == JobArtwork::JOB_TYPE_INTERNAL_JOB && $artwork->job_status_id == 11) {

                                $flowstr .= '-----<b>Job Done</b>----';
                            }

                            $subjobs = JobArtworkSubjob::model()->findAll(array('condition' => "jobArtworkId = $dtl->job_artowk_id", 'order' => "sortOrderVal asc"));
                            if (count($subjobs) > 0) {

                                $flowstr .= '';
                                $flowstr .= '<br>Sub Jobs<br>[';
                                foreach ($subjobs as $task) {
                                    $flowstr .=  $task->subjob->name . '&nbsp;-&nbsp;(' . $task->RelStatus->name . ')';
                                }
                                $flowstr .= '<br>]';
                               
                            }

                            $flowstr .= '<br>]<br>';


                            
                        }
                    }
				} else {
					$flowstr .=  $flow->activity . '<br />';
                }
            } else {
                $flowstr .= $flow->activity . '<br />';
            }


            $lastactivity = $flow->activity;
        }

        if ($this->status_id == 11) {
            $flowstr .= '-----<b>Job Done</b>----';
        }
		
        if (in_array($lastactivity, array('Job End'))) {

            $inventory_id = null;
            if (!empty($artworkdtl)) {
                $artworkinventory = InventoryArtWork::model()->find("internaljob_id = '{$artworkdtl->internalJob_id}'");
                $inventory_id = $artworkinventory->id;
            } else if (!empty($artworkPO)) {
                $artworkinventory = InventoryArtWork::model()->find("po_id = '{$artworkPO->id}'");
                $inventory_id = $artworkinventory->id;
            }
            $flowstr .= '&#187;End<br />';
            //$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("purchaseOrders/createEmbTapePO", array("id" => $inventory_id, "type" => "po_emb_tape")) . '">Purchase Embroidery Tape</a></li>';
            //$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobs/endDecoration",array("job_id"=>$job->id,"wodtls_id"=>  $this->workorderDtl_id, "jd_id"=>  $this->id)) . '">End Job</a></li>';
        }



        if ($lastactivity == 'PO Emb Tape') {
            $pos = PurchaseOrders::model()->findAll("job_id = '{$job->id}' and poType = 'Purchase  Embroidery Tape' ");
            $po_id = null;
            foreach ($pos as $po) {
                $podtl = PurchaseOrderDetails::model()->find("po_id = '{$po->id}' and workorderDtl_id = '{$this->workorderDtl_id}'");
                if (!empty($podtl)) {
                    $po_id = $po->id;
                    break;
                }
            }
        }

        if (in_array($lastactivity, array('Emb Tape Received', 'Job End', 'Artwork Allocated'))) {
            $flowstr .= '&#187;End<br />';
        }



        

        return $flowstr;
    }

}