<?php

/**
 * This is the model class for table "job_packing".
 *
 * The followings are the available columns in table 'job_packing':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorderDtl_id
 * @property integer $isInternalJob
 * @property integer $internalJob_id
 * @property integer $po_id
 * @property integer $qty
 * @property string $notation
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $status_id
 * @property integer $user_id
 */
class JobPacking extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return JobPacking the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_packing';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, workorderDtl_id, isInternalJob, internalJob_id, po_id, qty, status_id, user_id', 'numerical', 'integerOnly'=>true),
			array('notation', 'length', 'max'=>255),
			array('followupDate, dueDate', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, workorderDtl_id, isInternalJob, internalJob_id, po_id, qty, notation, followupDate, dueDate, status_id, user_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'workorderDtl_id' => 'Workorder Dtl',
			'isInternalJob' => 'Is Internal Job',
			'internalJob_id' => 'Internal Job',
			'po_id' => 'Po',
			'qty' => 'Qty',
			'notation' => 'Notation',
			'followupDate' => 'Followup Date',
			'dueDate' => 'Due Date',
			'status_id' => 'Status',
			'user_id' => 'User',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('workorderDtl_id',$this->workorderDtl_id);
		$criteria->compare('isInternalJob',$this->isInternalJob);
		$criteria->compare('internalJob_id',$this->internalJob_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('qty',$this->qty);
		$criteria->compare('notation',$this->notation,true);
		$criteria->compare('followupDate',$this->followupDate,true);
		$criteria->compare('dueDate',$this->dueDate,true);
		$criteria->compare('status_id',$this->status_id);
		$criteria->compare('user_id',$this->user_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}