<?php

/**
 * This is the model class for table "job_product_decorations".
 *
 * The followings are the available columns in table 'job_product_decorations':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorderDtl_id
 * @property integer $isInternalJob
 * @property integer $internalJob_id
 * @property integer $po_id
 * @property integer $qty
 * @property string $notation
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $user_id
 * @property integer $lineOrder order of detail lines
 */
class JobProductDecorations extends CActiveRecord
{
    //if this code apear then show only related product instead decoration on View, PDF etc.
    const PRODUCT_DECORATION_LINE_CODE = 'INCLUDE_PRODUCT';


    public $original_jpd_id;
	public $source_table;
	public $jobNum;
    public $productsku;
    public $prdsrtdesc;
    public $prodQty;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return JobProductDecorations the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_product_decorations';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, workorderDtl_id, isInternalJob, internalJob_id, po_id,original_jpd_id,
                            qty, user_id,status_id,decoQty, lineOrder, po_detail_id', 'numerical', 'integerOnly' => true),
			array('notation,decprtnam,customdecoration,customizationDetails, source_table', 'length', 'max' => 255),
			array('decoJobType,decosupref', 'length', 'max' => 45),
			array('followupDate, dueDate, decdesc', 'safe'),
			array('decoCostPrice, logo_setup', 'type', 'type' => 'float'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, workorderDtl_id, isInternalJob, internalJob_id, po_id, qty, notation, 
                            followupDate, dueDate, user_id,status_id', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorderDtl_id'),
			'workorderDtlDeco' => array(self::BELONGS_TO, 'WorkorderDetailsDecoration', '', 'foreignKey' => array('workorderDtl_id' => 'workorder_detail_id')),
			'decoSupp' => array(self::BELONGS_TO, 'Supplier', '', 'foreignKey' => array('decosupref' => 'supsup_fref')),
			'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
		);
	}

	public function rel_workorder_detail_decoration()
	{
		return WorkorderDetailsDecoration::model()->find(array('condition' => "workorder_detail_id = {$this->workorderDtl_id} AND decprtnam = '{$this->decprtnam}'"));
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'workorderDtl_id' => 'Workorder Dtl',
			'isInternalJob' => 'Is Internal Job',
			'internalJob_id' => 'Internal Job',
			'po_id' => 'Po',
			'qty' => 'Qty',
			'notation' => 'Notation',
			'followupDate' => 'Followup Date',
			'dueDate' => 'Due Date',
			'user_id' => 'User',
			'status_id' => 'Status',
			'decprtnam' => 'Decoration Name',
			'decdesc' => 'Decoration Decription',
			'customdecoration' => 'Custom Decoration',
			'decosupref' => 'Decoration Supplier',
			'decoQty' => 'Qty',
			'decoCostPrice' => 'Cost Price',
			'lineOrder' => 'Line Order',
			'po_detail_id' => 'PO Detail'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('job_id', $this->job_id);
		$criteria->compare('workorderDtl_id', $this->workorderDtl_id);

		$criteria->compare('decprtnam', $this->decprtnam, true);
		$criteria->compare('decdesc', $this->decdesc, true);
		$criteria->compare('customdecoration', $this->customdecoration, true);
		$criteria->compare('decoQty', $this->decoQty, true);
		$criteria->compare('decoCostPrice', $this->decoCostPrice, true);
		$criteria->compare('decosupref', $this->decosupref, true);
		$criteria->compare('customizationDetails', $this->customizationDetails, true);

		$criteria->compare('isInternalJob', $this->isInternalJob);
		$criteria->compare('internalJob_id', $this->internalJob_id);
		$criteria->compare('po_id', $this->po_id);
		$criteria->compare('qty', $this->qty);
		$criteria->compare('notation', $this->notation, true);
		$criteria->compare('followupDate', $this->followupDate, true);
		$criteria->compare('dueDate', $this->dueDate, true);
		$criteria->compare('user_id', $this->user_id);
		$criteria->compare('status_id', $this->status_id);

		$pageSize = (int) GlobalVars::get('RecordsViewPerPage');

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
				'defaultOrder' => 't.lineOrder ASC',
			)
		));
	}

	/**
     * Data provider for job item without po report to join tables
     */
    public function getJobItemWithoutPOJoinDataProvider()
    {
		$attributes = array( 
            'job_id',
            'jobNum',
            'workorderDtl_id',
            'productsku',
            'prdsrtdesc',
            'prodQty',
            'po_id',
        );

        $criteria = new CDbCriteria();
        $criteria->select = $attributes;

        $criteria->join = 'LEFT JOIN jobs j ON t.job_id = j.id
                           LEFT JOIN workorderdetails wd ON t.workorderDtl_id = wd.id';
        $criteria->condition = 't.po_id IS NULL AND j.status_id NOT IN (3, 17)';
        $criteria->order = 't.job_id';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
			'pagination' => false,
        ));
    }

	public function getCommonChkBox()
	{
		$checkbox = CHtml::radioButton("usedeco[]", false, array('id' => 'decochk_' . $this->id, 'value' => $this->id));

		$chkboxLbl = '<font style="font-size:0.8em;">Use this decoration for all</font>';
		$row = '<table width="100%;" border="0" style="border-collapse: collapse;"><tr width="100%;"><td>' . $checkbox . '</td><td>' . $chkboxLbl . '</td></tr></table>';
		return $row;
	}

	public function getProductDecorationRaw()
	{

		$deco = Decoration::model()->find(array('condition' => "decprtnam = '$this->decprtnam'"));

		$decorationdesc = '<a href="' . Yii::app()->createUrl("decoration/view", array("id" => $deco->decsno)) . '" target="_blank">CODE [ ' . $this->decprtnam . ' ]</a><br>';

		$decorationdesc .= nl2br($this->decdesc);


		$row .= $decorationdesc . nl2br($this->getCustomizationDetail()) . nl2br($this->getDecoSupplierLink());


		return $row;
	}

	public function getCustomizationDetail()
	{
		$html = "<div><table>";
		$html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Customization Details</th></tr>";

		if (!empty($this->customizationDetails)) {
			$html .= "<tr><td style='text-align:center'>{$this->customizationDetails}</td></tr>";
		} else {
			$html .= "<tr><td style='text-align:center'>--empty--</td></tr>";
		}


		$html .= "</table></div>";
		return $html;
	}

	public function getXeroAccountHtml()
	{
		if (!(int) SystemOptions::getOptions()->enbleXero) {
			return '';
		}

		$poDetail = PurchaseOrderDetails::model()->findByPk($this->po_detail_id);

		$html = '';
		if ($poDetail && $poDetail->xero_account_id) {
			$xeroaccText = XeroAccount::model()->findByPk($poDetail->xero_account_id)->code . " - " . XeroAccount::model()->findByPk($poDetail->xero_account_id)->name;
			$html = "<div><table>";
			$html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Xero Account</th></tr>";
			
			if ($this->po_detail_id) {
				$html .= "<tr><td style='text-align:center'>{$xeroaccText}</td></tr>";
			}


			$html .= "</table></div>";
		}



		return $html;
	}

	public function getDecoSupplierLink()
	{
		$html = "<div><table>";
		$html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Supplier</th></tr>";
		$html .= "<tr><td style='text-align:center'>" . ($this->supplierLink() ?: "N/A") . "</td></tr>";
		$html .= "</table></div>";

		return $html;
	}

	public function supplierLink()
	{
		$supnam = null;
		$supsno = null;
		if ($this->decoSupp) {
			$supnam = $this->decoSupp->supnam;
			$supsno = $this->decoSupp->supsno;
		} else {
			$decoration = Decoration::model()->find("decprtnam = '$this->decprtnam'");
			if ($decoration->decsupsno) {
				$deco_supp = Supplier::model()->findByPk($decoration->decsupsno);
				if ($deco_supp) {
					$supnam = $deco_supp->supnam;
					$supsno = $deco_supp->supsno;
				}
			}
		}
		if ($supsno) {
			return CHtml::link($supnam, array('supplier/view', 'id' => $supsno));
		} else {
			return null;
		}
	}

	public function getDecorationString()
	{
		return $this->decdesc;
	}

	public function getJobActivityFlow($type)
	{
		$flowstr = '';
		$lastactivity = '';



		$flows = JobActivityFlow::model()->findAll("type = '{$type}' and flowjob_id = '{$this->id}'");

		$flowstr .= '<ul style="font-size:0.9em;">';

		foreach ($flows as $flow) {

			if ($type == 'Product-Decoration') {
				if ($flow->activity == 'PO Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
				} else if ($flow->activity == 'GIN Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$gin = GoodsIssueNote::model()->find("job_id = '{$flow->job_id}' and po_id = '{$po->id}'");
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsIssueNote/view", array("id" => $gin->id)) . '">' . $gin->ginnum . '</a>)</li>';
				} else if ($flow->activity == 'Goods Received') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$grn = GoodsReceived::model()->find("grnType = 'Product-Decoration' and po_id = '{$po->id}'");
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
				} else if ($flow->activity == 'Sub Job') {
					$pdsubjobdetails = PDSubJobDetail::model()->findAll(array('condition' => "jobProductDecorationId = {$this->id} and workorderDetailsId = {$this->workorderDtl->id} and activityFlowId = $flow->id"));
					$PDSubJobIDArr = array();
					foreach ($pdsubjobdetails as $rowdtl) {
						$PDSubJobIDArr[] = $rowdtl->PDSubJobId;
					}

					foreach ($PDSubJobIDArr as $key => $val) {
						$pdsubjob = PDSubJob::model()->findByPk($val);
						$pdsubjoblist = PDSubJobList::model()->findAll(array('condition' => "PDSubJobId = {$val}", 'order' => "sortOrderval asc"));
						if (count($pdsubjoblist) > 0) {

							$flowstr .= '<ul style="margin-left:30px;">';
							$flowstr .= '<br><a href="' . Yii::app()->createUrl("pdSubJob/view", array("id" => $pdsubjob->id)) . '" target="_blank">SUB JOB ' . $pdsubjob->PDSubJobNum . '</a><br>[';
							foreach ($pdsubjoblist as $task) {
								$flowstr .= '<li>' . $task->subjob->name . '&nbsp;-&nbsp;(' . $task->RelStatus->name . ')</li>';
							}
							$flowstr .= '<br>]';
							$flowstr .= '</ul>';
						}
					}

					$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-Decoration</a></li>';
					$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/update", array("id" => $this->id)) . '">Update Product-Decoration</a></li>';
					//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
					$flowstr .= '<li >' . CHtml::link('Delete Product-Decoration', '#', array('submit' => array('jobProductDecorations/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
				} else {
					if ($flow->activity != 'Job End') {
						if ($flow->activity == 'Not Applicable' && count($flows) > 1) {
							continue;
						} else {
							$flowstr .= '<li >' . $flow->activity . '</li>';
						}
					}
				}
			} else {
				$flowstr .= '<li >' . $flow->activity . '</li>';
			}


			$lastactivity = $flow->activity;
		}







		if ($type == 'Product-Decoration' && $lastactivity == '') {
			$flowstr .= '<li >Next &#187; Create PO For Product-Decoration</li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-Decoration</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/update", array("id" => $this->id)) . '">Update Product-Decoration</a></li>';
			//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
			$flowstr .= '<li >' . CHtml::link('Delete Product-Decoration', '#', array('submit' => array('jobProductDecorations/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}




		if ($lastactivity == 'PO Created' && $type == 'Product-Decoration') {
			if ($this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsIssueNote/create", array("po_id" => $this->po_id, "jpd_id" => $this->id)) . '">Goods Issue</a></li>';
			}
			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductDecorations/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-Decoration</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/update", array("id" => $this->id)) . '">Update Product-Decoration</a></li>';
			//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
			$flowstr .= '<li >' . CHtml::link('Delete Product-Decoration', '#', array('submit' => array('jobProductDecorations/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}


		if ($lastactivity == 'GIN Created' && $type == 'Product-Decoration') {
			$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $this->po_id)) . '">Goods Receive</a></li>';
			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductDecorations/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-Decoration</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/update", array("id" => $this->id)) . '">Update Product-Decoration</a></li>';
			//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
			$flowstr .= '<li >' . CHtml::link('Delete Product-Decoration', '#', array('submit' => array('jobProductDecorations/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}

		if ($lastactivity == 'Goods Received' && $type == 'Product-Decoration') {

			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductDecorations/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-Decoration</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/update", array("id" => $this->id)) . '">Update Product-Decoration</a></li>';
			//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductDecorations/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
			$flowstr .= '<li >' . CHtml::link('Delete Product-Decoration', '#', array('submit' => array('jobProductDecorations/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}

		if ($this->status_id == 11) {

			$flowstr .= '-----<b>Job Done</b>----';
		}








		if (in_array($lastactivity, array('Job End'))) {
			$flowstr .= '<li >&#187;End</li>';
		}

//        if (in_array($type, array('Product', 'Product-Decoration')) && $lastactivity == 'Goods Received')
//            $flowstr .= '<li >&#187;End</li>';

		$flowstr .= '</ul>';

		return $flowstr;
	}

	public function getJobActivityFlowForPDF($type)
	{
		$flowstr = '';
		$lastactivity = '';



		$flows = JobActivityFlow::model()->findAll("type = '{$type}' and flowjob_id = '{$this->id}'");

		

		foreach ($flows as $flow) {

			if ($type == 'Product-Decoration') {
				if ($flow->activity == 'PO Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$flowstr .= $flow->activity . '<br> (' . $po->poNum . ')';
				} else if ($flow->activity == 'GIN Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$gin = GoodsIssueNote::model()->find("job_id = '{$flow->job_id}' and po_id = '{$po->id}'");
					$flowstr .=  $flow->activity . '<br> (' . $gin->ginnum . ')';
				} else if ($flow->activity == 'Goods Received') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$grn = GoodsReceived::model()->find("grnType = 'Product-Decoration' and po_id = '{$po->id}'");
					$flowstr .= $flow->activity . '<br> (' . $grn->grnnum . ')';
				} else if ($flow->activity == 'Sub Job') {
					$pdsubjobdetails = PDSubJobDetail::model()->findAll(array('condition' => "jobProductDecorationId = {$this->id} and workorderDetailsId = {$this->workorderDtl->id} and activityFlowId = $flow->id"));
					$PDSubJobIDArr = array();
					foreach ($pdsubjobdetails as $rowdtl) {
						$PDSubJobIDArr[] = $rowdtl->PDSubJobId;
					}

					foreach ($PDSubJobIDArr as $key => $val) {
						$pdsubjob = PDSubJob::model()->findByPk($val);
						$pdsubjoblist = PDSubJobList::model()->findAll(array('condition' => "PDSubJobId = {$val}", 'order' => "sortOrderval asc"));
						if (count($pdsubjoblist) > 0) {

							
							$flowstr .= '<br>SUB JOB ' . $pdsubjob->PDSubJobNum . '<br>[';
							foreach ($pdsubjoblist as $task) {
								$flowstr .= $task->subjob->name . '&nbsp;-&nbsp;(' . $task->RelStatus->name . ')';
							}
							$flowstr .= '<br>]';
							
						}
					}
				} else {
					if ($flow->activity != 'Job End') {
						if ($flow->activity == 'Not Applicable' && count($flows) > 1) {
							continue;
						} else {
							$flowstr .=  $flow->activity ;
						}
					}
				}
			} else {
				$flowstr .= $flow->activity;
			}


			$lastactivity = $flow->activity;
		}





		if ($this->status_id == 11) {

			$flowstr .= '-----<b>Job Done</b>----';
		}








		if (in_array($lastactivity, array('Job End'))) {
			$flowstr .= '&#187;End<br />';
		}

//        if (in_array($type, array('Product', 'Product-Decoration')) && $lastactivity == 'Goods Received')
//            $flowstr .= '<li >&#187;End</li>';

		

		return $flowstr;
	}

}
