<?php

/**
 * This is the model class for table "job_product_other_costs".
 *
 * The followings are the available columns in table 'job_product_other_costs':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorder_detail_id
 * @property integer $workorder_id
 * @property integer $other_cost_type_id
 * @property integer $other_cost_id
 * @property integer $other_cost_group_id
 * @property string $other_cost_name
 * @property string $other_cost_group_name
 * @property integer $is_qty_based
 * @property double $cost_price
 * @property integer $quantity
 * @property string $customisation_detail
 * @property integer $supplier_id
 * @property integer $po_id
 * @property integer $workorder_other_cost_id
 * @property integer $status_id
 * @property integer $po_detail_id
 * @property integer $user_id
 */
class JobProductOtherCost extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return JobProductOtherCost the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'job_product_other_costs';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('job_id, workorder_detail_id, workorder_id, other_cost_type_id, other_cost_id, other_cost_group_id, other_cost_name, other_cost_group_name, quantity, workorder_other_cost_id', 'required'),
			array('job_id, workorder_detail_id, workorder_id, other_cost_type_id, other_cost_id, other_cost_group_id, is_qty_based, quantity, supplier_id, po_id, workorder_other_cost_id, status_id, po_detail_id, user_id', 'numerical', 'integerOnly'=>true),
			array('cost_price', 'numerical'),
			array('other_cost_name, other_cost_group_name, customisation_detail', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, job_id, workorder_detail_id, workorder_id, other_cost_type_id, other_cost_id, other_cost_group_id, other_cost_name, other_cost_group_name, is_qty_based, cost_price, quantity, customisation_detail, supplier_id, po_id, workorder_other_cost_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorder_detail_id'),
			'workorderDtlOtherCost' => array(self::BELONGS_TO, 'WorkorderOtherCost', '', 'foreignKey' => array('workorder_detail_id' => 'workorder_detail_id')), 			
			'job' => array(self::BELONGS_TO, 'Jobs', 'job_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'job_id' => 'Job',
			'workorder_detail_id' => 'Workorder Detail',
			'workorder_id' => 'Workorder',
			'other_cost_type_id' => 'Other Cost Type',
			'other_cost_id' => 'Other Cost',
			'other_cost_group_id' => 'Other Cost Group',
			'other_cost_name' => 'Other Cost Name',
			'other_cost_group_name' => 'Other Cost Group Name',
			'is_qty_based' => 'Is Qty Based',
			'cost_price' => 'Cost Price',
			'quantity' => 'Quantity',
			'customisation_detail' => 'Customisation Detail',
			'supplier_id' => 'Supplier',
			'po_id' => 'PO',
			'workorder_other_cost_id' => 'Workorder Other Cost',
			'status_id' => 'Status'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('job_id',$this->job_id);
		$criteria->compare('workorder_detail_id',$this->workorder_detail_id);
		$criteria->compare('workorder_id',$this->workorder_id);
		$criteria->compare('other_cost_type_id',$this->other_cost_type_id);
		$criteria->compare('other_cost_id',$this->other_cost_id);
		$criteria->compare('other_cost_group_id',$this->other_cost_group_id);
		$criteria->compare('other_cost_name',$this->other_cost_name,true);
		$criteria->compare('other_cost_group_name',$this->other_cost_group_name,true);
		$criteria->compare('is_qty_based',$this->is_qty_based);
		$criteria->compare('cost_price',$this->cost_price);
		$criteria->compare('quantity',$this->quantity);
		$criteria->compare('customisation_detail',$this->customisation_detail,true);
		$criteria->compare('supplier_id',$this->supplier_id);
		$criteria->compare('po_id',$this->po_id);
		$criteria->compare('workorder_other_cost_id',$this->workorder_other_cost_id);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public function getJobActivityFlow($type)
	{
		$flowstr = '';
		$lastactivity = '';



		$flows = JobActivityFlow::model()->findAll("type = '{$type}' and flowjob_id = '{$this->id}'");

		$flowstr .= '<ul style="font-size:0.9em;">';

		foreach ($flows as $flow) {

			if ($type == 'Product-OtherCost') {
				if ($flow->activity == 'PO Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
				} else if ($flow->activity == 'GIN Created') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$gin = GoodsIssueNote::model()->find("job_id = '{$flow->job_id}' and po_id = '{$po->id}'");
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsIssueNote/view", array("id" => $gin->id)) . '">' . $gin->ginnum . '</a>)</li>';
				} else if ($flow->activity == 'Goods Received') {
					$po = PurchaseOrders::model()->findByPk($this->po_id);
					$grn = GoodsReceived::model()->find("grnType = 'Product-OtherCost' and po_id = '{$po->id}'");
					$flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
				}else {
					if ($flow->activity != 'Job End') {
						if ($flow->activity == 'Not Applicable' && count($flows) > 1) {
							continue;
						} else {
							$flowstr .= '<li >' . $flow->activity . '</li>';
						}
					}
				}
			} else {
				$flowstr .= '<li >' . $flow->activity . '</li>';
			}


			$lastactivity = $flow->activity;
		}

		if ($type == 'Product-OtherCost' && $lastactivity == '') {
			$flowstr .= '<li >Next &#187; Create PO For Product-OtherCost</li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-OtherCost</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/update", array("id" => $this->id)) . '">Update Product-OtherCost</a></li>';
			//$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/delete", array("id" => $this->id)) . '" >Delete Product-Decoration</a></li>';
			$flowstr .= '<li >' . CHtml::link('Delete Product-OtherCost', '#', array('submit' => array('jobProductOtherCost/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}




		if ($lastactivity == 'PO Created' && $type == 'Product-OtherCost') {
			if ($this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsIssueNote/create", array("po_id" => $this->po_id, "jpd_id" => $this->id)) . '">Goods Issue</a></li>';
			}
			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductOtherCost/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-OtherCost</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/update", array("id" => $this->id)) . '">Update Product-OtherCost</a></li>';
			
			$flowstr .= '<li >' . CHtml::link('Delete Product-OtherCost', '#', array('submit' => array('jobProductOtherCost/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}


		if ($lastactivity == 'GIN Created' && $type == 'Product-OtherCost') {
			$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("po_id" => $this->po_id)) . '">Goods Receive</a></li>';
			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductOtherCost/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-OtherCost</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/update", array("id" => $this->id)) . '">Update Product-OtherCost</a></li>';
			
			$flowstr .= '<li >' . CHtml::link('Delete Product-OtherCost', '#', array('submit' => array('jobProductOtherCost/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}

		if ($lastactivity == 'Goods Received' && $type == 'Product-OtherCost') {

			if (in_array($lastactivity, array('PO Created', 'GIN Created', 'Goods Received')) && $this->status_id != 11) {
				$flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProductOtherCost/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
			}
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/createCopy", array("id" => $this->id)) . '">Create New Copy of Product-OtherCost</a></li>';
			$flowstr .= '<li ><a href="' . Yii::app()->createUrl("jobProductOtherCost/update", array("id" => $this->id)) . '">Update Product-OtherCost</a></li>';			
			$flowstr .= '<li >' . CHtml::link('Delete Product-OtherCost', '#', array('submit' => array('jobProductOtherCost/delete', 'id' => $this->id), 'confirm' => 'Are you sure you want to delete this item?')) . '</li>';
		}

		if ($this->status_id == 11) {

			$flowstr .= '-----<b>Job Done</b>----';
		}








		if (in_array($lastactivity, array('Job End'))) {
			$flowstr .= '<li >&#187;End</li>';
		}

//        if (in_array($type, array('Product', 'Product-Decoration')) && $lastactivity == 'Goods Received')
//            $flowstr .= '<li >&#187;End</li>';

		$flowstr .= '</ul>';

		return $flowstr;
	}
}