<?php

/**
 * This is the model class for table "job_products".
 *
 * The followings are the available columns in table 'job_products':
 * @property integer $id
 * @property integer $job_id
 * @property integer $workorderDtl_id
 * @property integer $allocatedFrmInventory
 * @property integer $po_id
 * @property integer $qty
 * @property string $notation
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $status_id
 * @property integer $user_id
 * @property integer $lineOrder order of detail lines
 */
class JobProducts extends CActiveRecord
{

    public $source_table;
    public $jobNum;
    public $productsku;
    public $prdsrtdesc;
    public $prodQty;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return JobProducts the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'job_products';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('job_id, workorderDtl_id, allocatedFrmInventory, po_id, qty, status_id, user_id, inventory_id, lineOrder', 'numerical', 'integerOnly' => true),
            array('notation, source_table', 'length', 'max' => 255),
            array('followupDate, dueDate', 'safe'),
            array('prodCostPrice', 'type', 'type' => 'float'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, job_id, workorderDtl_id, allocatedFrmInventory, po_id, qty, notation, followupDate, dueDate, status_id, user_id, inventory_id, prodCostPrice', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'workorderDtl' => array(self::BELONGS_TO, 'Workorderdetails', 'workorderDtl_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'job_id' => 'Job',
            'workorderDtl_id' => 'Workorder Dtl',
            'allocatedFrmInventory' => 'Allocated Frm Inventory',
            'po_id' => 'Po',
            'qty' => 'Qty',
            'notation' => 'Notation',
            'followupDate' => 'Followup Date',
            'dueDate' => 'Due Date',
            'status_id' => 'Status',
            'user_id' => 'User',
            'lineOrder' => 'Line Order'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorderDtl_id', $this->workorderDtl_id);
        $criteria->compare('allocatedFrmInventory', $this->allocatedFrmInventory);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('prodCostPrice', $this->qty, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('user_id', $this->user_id);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchForPO()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('job_id', $this->job_id);
        $criteria->compare('workorderDtl_id', $this->workorderDtl_id);
        $criteria->compare('allocatedFrmInventory', $this->allocatedFrmInventory);
        $criteria->compare('po_id', $this->po_id);
        $criteria->compare('qty', $this->qty);
        $criteria->compare('prodCostPrice', $this->qty, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('status_id', $this->status_id);
        $criteria->compare('user_id', $this->user_id);





        $criteria->addCondition("po_id IS NULL OR po_id =''");

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.lineOrder ASC',
            )
        ));
    }


    /**
     * Data provider for job item without po report to join tables
     */
    public function getJobItemWithoutPOJoinDataProvider()
    {

        $attributes = array(
            'job_id',
            'jobNum',
            'workorderDtl_id',
            'productsku',
            'prdsrtdesc',
            'prodQty',
            'po_id',
        );

        $criteria = new CDbCriteria();
        $criteria->select = $attributes;
        $criteria->join = 'LEFT JOIN jobs j ON t.job_id = j.id
                           LEFT JOIN workorderdetails wd ON t.workorderDtl_id = wd.id';
        $criteria->condition = 't.po_id IS NULL AND j.status_id NOT IN (3, 17)';
        $criteria->order = 'j.jobNum';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));
    }

    public function getJobActivityFlow($type)
    {
        $flowstr = '';
        $lastactivity = '';




        $flows = JobActivityFlow::model()->findAll("type = '$type' and flowjob_id = '$this->id'");

        $flowstr .= '<ul style="font-size:0.9em;">';

        $grnIds = [];
        foreach ($flows as $flow) {

            if ($type == 'Product') {


                $po = PurchaseOrders::model()->findByPk($this->po_id);
                if ($flow->activity == 'PO Created') {
                    $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("purchaseOrders/view", array("id" => $po->id)) . '">' . $po->poNum . '</a>)</li>';
                    $decorationCode = JobProductDecorations::PRODUCT_DECORATION_LINE_CODE;
                    $flowstr .= '<li >Next &#187; ' . Chtml::link('Add to Decoration Tab', 'javascript:void(0)', array('onclick' => "addDecoration($this->id, '{$decorationCode}');")) . '</li>';
                } else if ($flow->activity == 'Goods Received Partially') {
                    $grns = GoodsReceived::model()->findAll("grnType = 'Product' and po_id = '{$po->id}'");
                    foreach ($grns as $grn) {

                        if (!in_array($grn->id, $grnIds)) {
                            $grnIds[] = $grn->id;
                            $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                        }
                    }
                } else if ($flow->activity == 'Goods Received') {
                    if (!$grnIds) {
                        $grn = GoodsReceived::model()->find("grnType = 'Product' and po_id = '{$po->id}'");
                        $flowstr .= '<li >' . $flow->activity . '<br> (<a href="' . Yii::app()->createUrl("goodsReceived/view", array("id" => $grn->id)) . '">' . $grn->grnnum . '</a>)</li>';
                    }
                    $flowstr .= '<li >&#187;End</li>';
                } else {
                    $flowstr .= '<li >' . $flow->activity . '</li>';
                }
            } else {
                if ($flow->activity != 'Job End')
                    $flowstr .= '<li >' . $flow->activity . '</li>';
            }


            $lastactivity = $flow->activity;
        }



        if ($type == 'Product' && $lastactivity == '') {
            $flowstr .= '<li >Next &#187; Create PO</li>';
            $decorationCode = JobProductDecorations::PRODUCT_DECORATION_LINE_CODE;
            $flowstr .= '<li >Next &#187; ' . Chtml::link('Add to Decoration Tab', 'javascript:void(0)', array('onclick' => "addDecoration($this->id, '{$decorationCode}');")) . '</li>';
        }





        if (in_array($lastactivity, array('PO Created', 'Artwork PO Created', 'Goods Received Partially')) && $type != 'Product-Decoration') {



            if ($this->status_id != 11) {
                $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("goodsReceived/create", array("jobDtl_id" => $this->id, "po_id" => $this->po_id, "workorderDtlId" => $this->workorderDtl_id)) . '">Goods Receive</a></li>';

                $flowstr .= '<li >Next &#187; <a href="' . Yii::app()->createUrl("jobProducts/jobDone", array("id" => $this->id)) . '">Job Complete</a></li>';
            }

            if ($this->status_id == 11) {
                $flowstr .= '-----<b>Job Done</b>----';
            }
        }


        if (in_array($lastactivity, array('Job End'))) {
            $flowstr .= '<li >&#187;End</li>';
        }





        $flowstr .= '</ul>';

        return $flowstr;
    }

    public function getJobActivityFlowForPDF($type)
    {
        $flowstr = '';
        $lastactivity = '';




        $flows = JobActivityFlow::model()->findAll("type = '$type' and flowjob_id = '$this->id'");

        $flowstr .= '';

        foreach ($flows as $flow) {

            if ($type == 'Product') {


                $po = PurchaseOrders::model()->findByPk($this->po_id);
                if ($flow->activity == 'PO Created') {
                    $flowstr .= $flow->activity . '<br> (' . $po->poNum . ')';
                } else if ($flow->activity == 'Goods Received') {

                    $flowstr .= $flow->activity;
                    $flowstr .= '&#187;End';
                } else {
                    $flowstr .= $flow->activity;
                }
            } else {
                if ($flow->activity != 'Job End')
                    $flowstr .= $flow->activity;
            }


            $lastactivity = $flow->activity;
        }









        if (in_array($lastactivity, array('PO Created', 'Artwork PO Created')) && $type != 'Product-Decoration') {

            if ($this->status_id == 11) {
                $flowstr .= '-----<b>Job Done</b>----';
            }
        }


        if (in_array($lastactivity, array('Job End'))) {
            $flowstr .= '&#187;End';
        }





        $flowstr .= '';

        return $flowstr;
    }

    public function getProductColumnMarkUps()
    {
        $markup = $this->workorderDtl->productsku ? $this->workorderDtl->productsku . ' <br> ' . $this->workorderDtl->prdsrtdesc : $this->workorderDtl->custmproduct;

        $markup .= $this->workorderDtl->getProdSupplierLink();

        if ($this->workorderDtl->customizationDetails || $this->workorderDtl->notes) {
            $html = "<div><table>";
            $html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Customisations</th><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Notes</th></tr>";
            $html .= "<tr><td style='text-align:center'>{$this->workorderDtl->customizationDetails}</td><td style='text-align:center'>{$this->workorderDtl->notes}</td></tr>";
            $html .= "</table></div>";
            $markup .= $html;
        }




        return $markup;
    }
}
