<?php

/**
 * This is the model class for table "jobs".
 *
 * The followings are the available columns in table 'jobs':
 * @property integer $id
 * @property integer $workorder_id
 * @property integer $quote_id
 * @property string $quoteNum
 * @property string $jobNum
 * @property string $createdDtm
 * @property string $notation
 * @property string $followupDate
 * @property string $dueDate
 * @property integer $user_id
 * @property integer $status_id
 * @property integer $shippingLineId
 * @property integer $order_base_type
 */
class Jobs extends CActiveRecord
{

    const EXCLUDING_GST = 1;
    const INCLUDING_GST = 2;

    public $filterPastDue = false;
    public $jobactivity = null;
    public $totout = false;
    public $customer_search;
    public $customer_contact_search;
    public $cusemail_search;
    public $mastercus_search;
    public $prdcoordinator_search;
    public $salesorder_search;
    public $invoice_number_search;
    public $salesperson_search;
    public $customisation_dtl_search;
    public $product_search;
    public $cussno;
    public $cusnam;
    public $mcusnam;
    public $cusemail;
    public $custel;
    public $cusmobtel;
    public $datefrom;
    public $dateto;
    public $cancel_reason;
    public $followupStatus;
    public $sperson_filter_jobinprogress;
    public $sperson_filter_jobinvoiced;
    public $spersonDateFlag;
    public $allTotalExGST;
    public $allTotalCost;
    public $hide_completed_jobs;
    public $show_completed_jobs;
    public $show_cancelled_jobs;

    public $source_table;
    public $productsku;
    public $prdsrtdesc;
    public $prodQty;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Jobs the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'jobs';
    }

    public function behaviors()
    {
        return array(
            'ERememberFiltersBehavior' => array(
                'class' => 'ext.yii-remember-filters-gridview-master.components.ERememberFiltersBehavior',
                'defaults' => array(), /* optional line */
                'defaultStickOnClear' => false /* optional line */
            ),
        );
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('workorder_id, quote_id, user_id, status_id, mastercusno, ws_user_id, 
                prd_cordinator_id, originalJobId, isXNameProduction, sperson_filter_jobinprogress, sperson_filter_jobinvoiced ,spersonDateFlag, shippingLineId, order_base_type', 'numerical', 'integerOnly' => true),
            array('quoteNum, jobNum', 'length', 'max' => 45),
            array('jobname', 'length', 'max' => 100),
            array('customerpono', 'length', 'max' => 50),
            array('notation, cus_fref, ws_user, source_table', 'length', 'max' => 255),
            array('shipAddress1, shipAddress2, shipAddress3, shipContactName, shipSendVia', 'length', 'max' => 150),
            array('shipSub, shipState, shipPostalCode', 'length', 'max' => 100),
            array('createdDtm, followupDate, dueDate, customer_search, mastercus_search,prdcoordinator_search,
                mastercusno, cussno, cusnam, mcusnam, urgent_status, datefrom,dateto,cusemail_search,cancel_reason, 
                salesorder_search, filterPastDue, datefrom, dateto, invoice_number_search, salesperson_search,
                customer_contact_search, customisation_dtl_search, product_search, followupStatus, show_completed_jobs', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, workorder_id, quote_id, cus_fref, quoteNum, jobNum, createdDtm, notation, followupDate,
                dueDate, user_id, status_id, jobname, ws_user, datefrom, dateto, invoice_number_search, 
                originalJobId, ws_user_id, salesperson_search,customer_contact_search, isXNameProduction,
                customisation_dtl_search, product_search, followupStatus, salesorder_search', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'quotation' => array(self::BELONGS_TO, 'Quatation', 'quote_id'),
            'workorder' => array(self::BELONGS_TO, 'Workorder', 'workorder_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', '', 'foreignKey' => array('cus_fref' => 'cuscus_fref')),
            'master' => array(self::BELONGS_TO, 'MasterCustomer', '', 'foreignKey' => array('mastercusno' => 'mcussno')),
            'coordinator' => array(self::BELONGS_TO, 'User', 'prd_cordinator_id'),
            'salesperson' => array(self::BELONGS_TO, 'SalesPerson', 'ws_user_id'),
        );
    }

    public function rel_workorder()
    {
        return Workorder::model()->findByPk($this->workorder_id);
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'workorder_id' => 'Sales Order',
            'quote_id' => 'Quotation ID',
            'quoteNum' => 'Quotation Number',
            'jobNum' => 'Job Number',
            'createdDtm' => 'Created Date',
            'notation' => 'Notes',
            'followupDate' => 'Followup Date',
            'dueDate' => 'Due Date',
            'user_id' => 'User',
            'status_id' => 'Status',
            'jobactivity' => 'Activity',
            'jobname' => 'Job Name',
            'customer_search' => 'Customer',
            'mastercus_search' => 'Master Customer',
            'ws_user' => 'Sales Person',
            'urgent_status' => 'Urgent Status',
            'ws_user_id' => 'Sales Person',
            'prd_cordinator_id' => 'Production Coordinator',
            'prdcoordinator_search' => 'Production Coordinator',
            'customerpono' => 'Customer PO #',
            'cusemail_search' => 'Customer Email',
            'cancel_reason' => 'Reason to Cancel',
            'salesorder_search' => 'Sales Order',
            'invoice_number_search' => 'Invoice #',
            'salesperson_search' => 'Sales Person',
            'customer_contact_search' => 'Customer Contact',
            'isXNameProduction' => 'Offshore Production',
            'customisation_dtl_search' => 'Product Customisation / Note',
            'product_search' => 'Product (code, name, description)',
            'followupStatus' => 'Follow-up Status',
            'sperson_filter_jobinprogress' => 'Job in Progress',
            'sperson_filter_jobinvoiced' => 'Job Invoiced',
            'spersonDateFlag' => 'Filter Date Type',
            'shippingLineId' => 'Shipping Line',

            'source_table' => 'Job Type',
            'productsku' => 'Product',
            'prdsrtdesc' => 'Description',
            'prodQty' => 'Quantity'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'coordinator', 'workorder', 'salesperson');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('jobNum', $this->jobNum, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);
        $criteria->compare('t.customerpono', $this->customerpono, true);
        $criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cuscontact', $this->customer_contact_search, true);

        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if ($this->filterPastDue == true) {
            $criteria->addCondition("t.status_id <> 17 and t.dueDate < NOW()");
        }

        if ($this->totout == true) {
            $criteria->addCondition("t.status_id in (1,18)");
        }

        if ($this->urgent_status == true) {
            $criteria->addCondition("t.status_id NOT IN (3,17)");
        }

        if (!empty($this->invoice_number_search)) {
            $invoices = Invoice::model()->findAll(array('condition' => "invoiceNum LIKE '%{$this->invoice_number_search}%'"));
            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }

        if (!empty($this->customisation_dtl_search)) {
            $workorderDtls = Workorderdetails::model()->findAll(array('condition' => "customizationDetails LIKE '%{$this->customisation_dtl_search}%'"));
            $workorderIDArr = array();
            foreach ($workorderDtls as $dtl) {
                $workorderIDArr[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArr)) {
                $workorderIDStr = implode(',', $workorderIDArr);

                $criteria->addCondition("t.workorder_id in ($workorderIDStr)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        if (!empty($this->product_search)) {
            $workorderDtlsPD = Workorderdetails::model()->findAll(array('condition' => "productsku LIKE '%{$this->product_search}%' OR prdsrtdesc LIKE '%{$this->product_search}%' OR prdlngdesc LIKE '%{$this->product_search}%'"));
            $workorderIDArrPD = array();
            foreach ($workorderDtlsPD as $dtl) {
                $workorderIDArrPD[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArrPD)) {
                $workorderIDStrPD = implode(',', $workorderIDArrPD);

                $criteria->addCondition("t.workorder_id in ($workorderIDStrPD)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }

        if (!isset(Yii::app()->session['show_completed_jobs'])) {
            $followupJobarr = array();
            //get all sales log related to quotation

            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
            if ($followupstats->id) {
                $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
                foreach ($saleslogs as $slog) {


                    $followupJobarr[] = $slog->tbl_id;
                }

                //remove empty elements if have
                $followupJobarr = array_filter($followupJobarr);
                //add in condition
                $idStr = implode(',', $followupJobarr);
                if (count($followupJobarr) > 0 && $idStr) {
                    $criteria->addCondition("t.id not in ($idStr)");
                }
            }
        }


        if (!isset(Yii::app()->session['show_cancelled_jobs'])) {
            $followupJobarr = array();
            //get all sales log related to quotation

            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Cancelled' and type = 'Job'"));
            if ($followupstats->id) {
                $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
                foreach ($saleslogs as $slog) {


                    $followupJobarr[] = $slog->tbl_id;
                }

                //remove empty elements if have
                $followupJobarr = array_filter($followupJobarr);
                //add in condition
                $idStr = implode(',', $followupJobarr);
                if (count($followupJobarr) > 0 && $idStr) {
                    $criteria->addCondition("t.id not in ($idStr)");
                }
            }
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }


        //$criteria->order = 'FIELD(t.urgent_status, 19) DESC, t.createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm DESC',
            )
        ));
    }


    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchSummary()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'coordinator', 'workorder', 'salesperson');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('jobNum', $this->jobNum, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);
        $criteria->compare('t.customerpono', $this->customerpono, true);
        $criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cuscontact', $this->customer_contact_search, true);

        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if ($this->filterPastDue == true) {
            $criteria->addCondition("t.status_id <> 17 and t.dueDate < NOW()");
        }

        if ($this->totout == true) {
            $criteria->addCondition("t.status_id in (1,18)");
        }

        if ($this->urgent_status == true) {
            $criteria->addCondition("t.status_id NOT IN (3,17)");
        }

        if (!empty($this->invoice_number_search)) {
            $invoices = Invoice::model()->findAll(array('condition' => "invoiceNum LIKE '%{$this->invoice_number_search}%'"));
            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }

        if (!empty($this->customisation_dtl_search)) {
            $workorderDtls = Workorderdetails::model()->findAll(array('condition' => "customizationDetails LIKE '%{$this->customisation_dtl_search}%'"));
            $workorderIDArr = array();
            foreach ($workorderDtls as $dtl) {
                $workorderIDArr[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArr)) {
                $workorderIDStr = implode(',', $workorderIDArr);

                $criteria->addCondition("t.workorder_id in ($workorderIDStr)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        if (!empty($this->product_search)) {
            $workorderDtlsPD = Workorderdetails::model()->findAll(array('condition' => "productsku LIKE '%{$this->product_search}%' OR prdsrtdesc LIKE '%{$this->product_search}%' OR prdlngdesc LIKE '%{$this->product_search}%'"));
            $workorderIDArrPD = array();
            foreach ($workorderDtlsPD as $dtl) {
                $workorderIDArrPD[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArrPD)) {
                $workorderIDStrPD = implode(',', $workorderIDArrPD);

                $criteria->addCondition("t.workorder_id in ($workorderIDStrPD)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }

        if (!isset(Yii::app()->session['show_completed_jobs'])) {
            $followupJobarr = array();
            //get all sales log related to quotation

            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
            if ($followupstats->id) {
                $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
                foreach ($saleslogs as $slog) {


                    $followupJobarr[] = $slog->tbl_id;
                }

                //remove empty elements if have
                $followupJobarr = array_filter($followupJobarr);
                //add in condition
                $idStr = implode(',', $followupJobarr);
                if (count($followupJobarr) > 0 && $idStr) {
                    $criteria->addCondition("t.id not in ($idStr)");
                }
            }
        }


        if (!isset(Yii::app()->session['show_cancelled_jobs'])) {
            $followupJobarr = array();
            //get all sales log related to quotation

            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Cancelled' and type = 'Job'"));
            if ($followupstats->id) {
                $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
                foreach ($saleslogs as $slog) {


                    $followupJobarr[] = $slog->tbl_id;
                }

                //remove empty elements if have
                $followupJobarr = array_filter($followupJobarr);
                //add in condition
                $idStr = implode(',', $followupJobarr);
                if (count($followupJobarr) > 0 && $idStr) {
                    $criteria->addCondition("t.id not in ($idStr)");
                }
            }
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }


        //$criteria->order = 'FIELD(t.urgent_status, 19) DESC, t.createdDtm DESC';

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm DESC',
            )
        ));
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function searchDashboard()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'coordinator', 'workorder', 'salesperson');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('jobNum', $this->jobNum, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);
        $criteria->compare('t.customerpono', $this->customerpono, true);
        $criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cuscontact', $this->customer_contact_search, true);

        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        //$criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        $criteria->compare('t.prd_cordinator_id', $this->prd_cordinator_id);

        //$criteria->compare('t.shipComanyName', $this->shipComanyName, true);




        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if ($this->filterPastDue == true) {
            $criteria->addCondition("t.status_id <> 17 and t.dueDate < NOW()");
        }

        if ($this->totout == true) {
            $criteria->addCondition("t.status_id in (1,18)");
        }


        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }





        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.createdDtm desc',
            )
        ));
    }

    public function searchjobflow()
    {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'coordinator', 'workorder', 'salesperson');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';



        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);
        $criteria->compare('t.notation', $this->notation, true);
        $criteria->compare('t.followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('t.jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);
        $criteria->compare('t.customerpono', $this->customerpono, true);
        $criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cuscontact', $this->customer_contact_search, true);

        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        $criteria->compare('t.ws_user_id', $this->ws_user_id, true);

        //$criteria->compare('orderTypeId', $this->orderTypeId);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if ($this->filterPastDue == true) {
            $criteria->addCondition("t.status_id <> 17 and t.dueDate < NOW()");
        }

        if ($this->totout == true) {
            $criteria->addCondition("t.status_id in (1,18)");
        }

        if (!empty($this->invoice_number_search)) {
            $invoices = Invoice::model()->findAll(array('condition' => "invoiceNum LIKE '%{$this->invoice_number_search}%'"));
            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }

        if ($this->customisation_dtl_search) {

            $criteria->mergeWith(array(
                'join' => 'LEFT JOIN workorder wo1 ON wo1.id = t.workorder_id LEFT JOIN workorderdetails wd1 ON wd1.workorderId = wo1.id ',
                'condition' => "wd1.customizationDetails LIKE '%{$this->customisation_dtl_search}%' OR  wd1.notes LIKE '%{$this->customisation_dtl_search}%'"
            ));
        }

        if ($this->product_search) {

            $criteria->mergeWith(array(
                'join' => 'LEFT JOIN workorder wo2 ON wo2.id = t.workorder_id LEFT JOIN workorderdetails wd2 ON wd2.workorderId = wo2.id ',
                'condition' => "wd2.productsku LIKE '%{$this->product_search}%' OR wd2.prdsrtdesc LIKE '%{$this->product_search}%' OR wd2.prdlngdesc LIKE '%{$this->product_search}%' "
            ));
        }

        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user

        if (AuthAssignment::checkRoleAccess('Production Staff')) {

            $criteria->addCondition("t.user_id = '$loggeduserID' or t.prd_cordinator_id = '$loggeduserID'");
        }


        if (!empty($this->followupStatus)) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }


        if (!isset(Yii::app()->session['show_dashboard_completed_jobs'])) {
            $followupJobarr = array();
            //get all sales log related to quotation

            $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
            if ($followupstats->id) {
                $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
                foreach ($saleslogs as $slog) {


                    $followupJobarr[] = $slog->tbl_id;
                }

                //remove empty elements if have
                $followupJobarr = array_filter($followupJobarr);
                //add in condition
                $idStr = implode(',', $followupJobarr);
                if (count($followupJobarr) > 0 && $idStr) {
                    $criteria->addCondition("t.id not in ($idStr)");
                }
            }
        }


        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }


        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'createdDtm desc',
            )
        ));
    }

    public function searchstatus()
    {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('coordinator', 'workorder', 'salesperson');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno'
            . '         left join customer on cus_fref = customer.cuscus_fref';



        //$criteria->compare('t.id', $this->id);
        //$criteria->compare('t.workorder_id', $this->workorder_id);
        //$criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        //$criteria->compare('t.createdDtm', $this->createdDtm, true);
        //$criteria->compare('t.notation', $this->notation, true);
        //$criteria->compare('t.followupDate', $this->followupDate, true);
        //$criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('t.user_id', $this->user_id);
        //$criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('t.cus_fref', $this->cus_fref);
        //$criteria->compare('t.customerpono', $this->customerpono, true);
        //$criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('customer.cuscontact', $this->customer_contact_search, true);
        //$criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        //$criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('salesperson.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        //$criteria->compare('t.ws_user_id', $this->ws_user_id, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }


        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user
        //        if (AuthAssignment::checkRoleAccess('Production Staff')) {
        //
        //            $criteria->addCondition("t.user_id = '$loggeduserID' or t.prd_cordinator_id = '$loggeduserID'");
        //        }


        if (isset(Yii::app()->session['job_sts_selcted'])) {
            $stsArr = explode(',', Yii::app()->session['job_sts_selcted']);

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && in_array($slog->followupSts_id, $stsArr)) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';

        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array('urgent_status=:' => $this->urgent_status);

        //here define the filter fields by like values
        $paramarrLike = array(
            'jobNum LIKE :' => $this->jobNum, 'quoteNum LIKE :' => $this->quoteNum,
            'workorder.salesorderNumber LIKE :' => $this->salesorder_search, 'master_customer.mcusnam LIKE :' => $this->mastercus_search,
            'customer.cusnam LIKE :' => $this->customer_search, 'ws_user LIKE :' => $this->ws_user
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        if (isset(Yii::app()->session['job_sts_qry']))
            unset(Yii::app()->session['job_sts_qry']);

        Yii::app()->session['job_sts_qry'] = $originalQuery;


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 't.followupStatus, t.dueDate',
            ),
        ));
    }

    public function searchcustom()
    {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno'
            . '         left join customer on cus_fref = customer.cuscus_fref'
            . '             left join User on prd_cordinator_id = User.id '
            . '                 left join workorder on workorder_id = workorder.id'
            . '                     left join sales_persons on t.ws_user_id = sales_persons.id';


        $criteria->compare('id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('jobNum', $this->jobNum, true);
        $criteria->compare('createdDtm', $this->createdDtm, true);
        $criteria->compare('notation', $this->notation, true);
        $criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('urgent_status', $this->urgent_status);
        $criteria->compare('jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);
        $criteria->compare('t.customerpono', $this->customerpono, true);
        $criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cuscontact', $this->customer_contact_search, true);

        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('user.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('sales_persons.name', $this->salesperson_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        $criteria->compare('t.ws_user_id', $this->ws_user_id, true);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }


        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if ($this->filterPastDue == true) {
            $criteria->addCondition("t.status_id <> 17 and dueDate < NOW()");
        }

        if ($this->totout == true) {
            $criteria->addCondition("t.status_id in (1,18)");
        }

        if (!empty($this->invoice_number_search)) {
            $invoices = Invoice::model()->findAll(array('condition' => "invoiceNum LIKE '%{$this->invoice_number_search}%'"));
            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }

        if (!empty($this->customisation_dtl_search)) {
            $workorderDtls = Workorderdetails::model()->findAll(array('condition' => "customizationDetails LIKE '%{$this->customisation_dtl_search}%'"));
            $workorderIDArr = array();
            foreach ($workorderDtls as $dtl) {
                $workorderIDArr[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArr)) {
                $workorderIDStr = implode(',', $workorderIDArr);

                $criteria->addCondition("t.workorder_id in ($workorderIDStr)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        if (!empty($this->product_search)) {
            $workorderDtlsPD = Workorderdetails::model()->findAll(array('condition' => "productsku LIKE '%{$this->product_search}%' or prdsrtdesc LIKE '%{$this->product_search}%'"));
            $workorderIDArrPD = array();
            foreach ($workorderDtlsPD as $dtl) {
                $workorderIDArrPD[] = $dtl->workorderId;
            }

            if (!empty($workorderIDArrPD)) {
                $workorderIDStrPD = implode(',', $workorderIDArrPD);

                $criteria->addCondition("t.workorder_id in ($workorderIDStrPD)");
            } else {
                $criteria->addCondition("t.workorder_id in (0)");
            }
        }

        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        $criteria->order = 't.createdDtm DESC';

        /*
         * Here we do catch mysql query schema for this criteria
         * 
         */

        unset(Yii::app()->session['job_cus_rpt_qry']);
        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array(
            't.id=:' => $this->id, 'workorder_id=:' => $this->workorder_id,
            'quote_id=:' => $this->quote_id, 'user_id=:' => $this->user_id,
            'status_id=:' => $this->status_id, 'urgent_status=:' => $this->urgent_status,
            'cus_fref=:' => $this->cus_fref, 'isXNameProduction=:' => $this->isXNameProduction
        );

        //here define the filter fields by like values
        $paramarrLike = array(
            'quoteNum LIKE :' => $this->quoteNum, 'jobNum LIKE :' => $this->jobNum, $this->createdDtm => 'createdDtm LIKE :',
            'notation LIKE :' => $this->notation, 'followupDate LIKE :' => $this->followupDate, 'dueDate LIKE :' => $this->dueDate,
            'jobname LIKE :' => $this->jobname, 'customerpono LIKE :' => $this->customerpono, 'customer.cusnam LIKE :' => $this->customer_search,
            'customer.cuscontact LIKE :' => $this->customer_contact_search, 'customer.cusemail LIKE :' => $this->cusemail_search, 'master_customer.mcusnam LIKE :' => $this->mastercus_search,
            'user.username LIKE :' => $this->prdcoordinator_search, 'workorder.salesorderNumber LIKE :' => $this->salesorder_search, 'sales_persons.name LIKE :' => $this->salesperson_search,
            't.ws_user LIKE :' => $this->ws_user, 't.ws_user_id LIKE :' => $this->ws_user_id
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //set refined mysql query into a session
        Yii::app()->session['job_cus_rpt_qry'] = $originalQuery;

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

    public function getInvoicesLinkHtml()
    {
        $invoices = Invoice::model()->findAll(array('condition' => "job_id = '$this->id'"));
        $html = '';
        if (!empty($invoices) && count($invoices) > 0) {
            foreach ($invoices as $inv) {
                $html .= CHtml::link($inv->invoiceNum, array("invoice/view", "id" => $inv->id), array("target" => "_blank", 'style' => 'background-color:#00aa00;')) . '<br>';
            }
        }

        return $html;
    }

    public function searchoutstandingjobs()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        //$criteria->compare('id', $this->id);
        //$criteria->compare('workorder_id', $this->workorder_id);
        //$criteria->compare('quote_id', $this->quote_id);
        //$criteria->compare('quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        $criteria->compare('t.createdDtm', $this->createdDtm);
        //$criteria->compare('notation', $this->notation, true);
        //$criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('jobname', $this->jobname, true);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcussno', $this->mastercus_search);


        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();
        $paramarr = array(
            'createdDtm=:' => $this->createdDtm, 'status_id=:' => $this->status_id,
            'customer.cussno=:' => $this->customer_search, 'master_customer.mcussno=:' => $this->mastercus_search
        );

        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        if (isset(Yii::app()->session['out_jobrpt_qry']))
            unset(Yii::app()->session['out_jobrpt_qry']);

        Yii::app()->session['out_jobrpt_qry'] = $originalQuery;

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function searchJobsWithoutInvoice()
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        //$criteria->compare('id', $this->id);
        //$criteria->compare('workorder_id', $this->workorder_id);
        //$criteria->compare('quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        $criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('createdDtm', $this->createdDtm);
        //$criteria->compare('notation', $this->notation, true);
        //$criteria->compare('followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('jobname', $this->jobname, true);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcussno', $this->mastercus_search);

        //$criteria->compare('ws_user', $this->ws_user, true);
        //$criteria->order = 'dueDate ASC';

        $invoices = Invoice::model()->findAll();
        $invoiceJobIDArr = array();
        foreach ($invoices as $inv) {
            $invoiceJobIDArr[] = $inv->job_id;
        }

        $invoiceJobIDStr = implode(',', $invoiceJobIDArr);

        if (!empty($invoiceJobIDStr)) {
            $criteria->addCondition("t.id not in ($invoiceJobIDStr)");
        }

        $criteria->addCondition("t.status_id not in (3)");

        if (!empty($this->datefrom) && empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
        } else if (empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        } else if (!empty($this->datefrom) && !empty($this->dateto)) {
            $criteria->addCondition("t.createdDtm between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }


        $criteria->order = 't.dueDate ASC';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function searchDue($nextdays)
    {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->with = array('customer', 'coordinator');
        $criteria->join = 'left join master_customer on mastercusno = master_customer.mcussno';


        $criteria->compare('t.id', $this->id);
        $criteria->compare('t.workorder_id', $this->workorder_id);
        $criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        $criteria->compare('t.createdDtm', $this->createdDtm, true);
        $criteria->compare('t.notation', $this->notation, true);
        $criteria->compare('t.followupDate', $this->followupDate, true);
        $criteria->compare('t.dueDate', $this->dueDate, true);
        $criteria->compare('t.user_id', $this->user_id);
        $criteria->compare('t.status_id', $this->status_id);
        $criteria->compare('t.urgent_status', $this->urgent_status);
        $criteria->compare('t.jobname', $this->jobname, true);
        $criteria->compare('t.cus_fref', $this->cus_fref);


        $criteria->compare('customer.cusnam', $this->customer_search, true);
        $criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        $criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);

        $criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('t.ws_user', $this->ws_user, true);

        if (!empty($this->prd_cordinator_id)) {
            $criteria->addCondition("t.prd_cordinator_id  = '$this->prd_cordinator_id'");
        }



        $criteria->addCondition("t.dueDate between NOW() and DATE_ADD(NOW(), INTERVAL {$nextdays} DAY)");


        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }



        $criteria->order = 't.dueDate ASC';

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    public function searchSperson()
    {
        $loggeduserID = Yii::app()->user->id;
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->select = 't.id, t.workorder_id, t.quote_id, t.quoteNum, t.jobNum, t.createdDtm, t.dueDate, t.prd_cordinator_id,'
            . 't.user_id, t.status_id, t.urgent_status, t.jobname, t.cus_fref, customer.cusnam, master_customer.mcusnam, '
            . 'coordinator.username, workorder.salesorderNumber, sales_persons.name, t.ws_user_id';

        $criteria->join = ' left join master_customer on mastercusno = master_customer.mcussno '
            . '         left join customer on t.cus_fref = customer.cuscus_fref '
            . '         left join User as coordinator on prd_cordinator_id = coordinator.id '
            . '         left join workorder as workorder on t.workorder_id = workorder.id '
            . '         left join sales_persons on t.ws_user_id = sales_persons.id';



        //$criteria->compare('t.id', $this->id);
        //$criteria->compare('t.workorder_id', $this->workorder_id);
        //$criteria->compare('t.quote_id', $this->quote_id);
        $criteria->compare('t.quoteNum', $this->quoteNum, true);
        $criteria->compare('t.jobNum', $this->jobNum, true);
        //$criteria->compare('t.createdDtm', $this->createdDtm, true);
        //$criteria->compare('t.notation', $this->notation, true);
        //$criteria->compare('t.followupDate', $this->followupDate, true);
        //$criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('t.user_id', $this->user_id);
        //$criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('urgent_status', $this->urgent_status);
        //$criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('t.cus_fref', $this->cus_fref);
        //$criteria->compare('t.customerpono', $this->customerpono, true);
        //$criteria->compare('t.isXNameProduction', $this->isXNameProduction);

        $criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('customer.cuscontact', $this->customer_contact_search, true);
        //$criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        //$criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);
        //$criteria->compare('coordinator.username', $this->prdcoordinator_search, true);

        $criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);

        $criteria->compare('sales_persons.name', $this->salesperson_search, true);

        //$criteria->compare('t.ws_user', $this->ws_user, true);
        //$criteria->compare('t.ws_user_id', $this->ws_user_id, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);



        if ($this->spersonDateFlag == 1) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        } else if ($this->spersonDateFlag == 2) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        }




        if (!empty($this->invoice_number_search)) {


            $invoices = Invoice::model()->findAll(array('condition' => "invoiceNum LIKE '%{$this->invoice_number_search}%'"));
            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }

        if (!empty($this->sperson_filter_jobinvoiced) || $this->spersonDateFlag == 3) {

            $invoicecriteria = '';
            $invoices = null;
            if ($this->spersonDateFlag == 3) {
                if (!empty($this->datefrom) && empty($this->dateto)) {
                    $invoicecriteria = "DATE_FORMAT(createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'";
                } else if (empty($this->datefrom) && !empty($this->dateto)) {
                    $invoicecriteria = "DATE_FORMAT(createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'";
                } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                    $invoicecriteria = "DATE_FORMAT(createdDtm, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'";
                }
                $invoices = Invoice::model()->findAll(array('condition' => $invoicecriteria));
            } else {
                $invoices = Invoice::model()->findAll();
            }

            if (!empty($invoices) && count($invoices) > 0) {
                $invoicedJobIDArr = array();
                foreach ($invoices as $inv) {
                    $invoicedJobIDArr[] = $inv->job_id;
                }
                $invoicedJobIDStr = implode(',', $invoicedJobIDArr);

                if (!empty($invoicedJobIDStr)) {
                    $criteria->addCondition("t.id in ({$invoicedJobIDStr})");
                }
            }
        }




        //just pass the role name u need to check weather this user has or not,
        //if no user id pass then it will check for the current user



        if ($this->followupStatus) {

            $followupJobarr = array();
            //get all sales log related to quotation
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if ($slog->tbl_id) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if ($slog && $slog->followupSts_id == $this->followupStatus) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }


        if (!empty($this->sperson_filter_jobinprogress)) {

            $floupsts = FollowupStatus::model()->find(array('condition' => "type = 'Job' and status = 'Job In Progress'"));
            $followupJobarr = array();
            //get all sales log related to job
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id > 0"));
            foreach ($saleslogs as $slog) {

                //get each log last updated followup status only if record has a table id value
                if (!empty($slog->tbl_id)) {
                    $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$slog->tbl_id} and followupSts_id > 0", 'order' => "id desc"));
                    //if last updated follow-up status is equal to filtering one then store it in an array
                    if (!empty($slog) && $slog->followupSts_id == $floupsts->id) {
                        $followupJobarr[] = $slog->tbl_id;
                    }
                }
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                $criteria->addCondition("t.id in ($idStr)");
            } else {
                $criteria->addCondition("t.id in (0)");
            }
        }


        if (isset(Yii::app()->session['sperson_selcted'])) {
            //t.ws_user_id
            $salespersonStrArr = Yii::app()->session['sperson_selcted'];
            if (!empty($salespersonStrArr)) {
                $criteria->addCondition("t.ws_user_id in ($salespersonStrArr)");
            }
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }

        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';

        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        if (isset(Yii::app()->session['sperson_query'])) {
            unset(Yii::app()->session['sperson_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        $paramarr = array('t.id=:' => $this->id);

        $paramarrLike = array(
            't.jobNum LIKE :' => $this->jobNum, 't.quoteNum LIKE :' => $this->quoteNum,
            'workorder.salesorderNumber LIKE :' => $this->salesorder_search, 'customer.cusnam LIKE :' => $this->customer_search,
            'sales_persons.name LIKE :' => $this->salesperson_search
        );


        foreach ($paramarr as $key => $value) {
            $position = strpos($originalQuery, $key);
            if (!empty($position)) {
                $param = str_replace('=:', '', $key);
                $param .= "='$value'";
                $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
            }
        }

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }




        Yii::app()->session['sperson_query'] = $originalQuery;

        foreach ($dataProvider->getData() as $record) {
            $workorder = Workorder::model()->findByPk($record->workorder_id);
            $this->allTotalExGST += $workorder->getTotalWithoutGST();
            $this->allTotalCost += $workorder->getItemCosts();
        }


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    'sales_persons.name',
                ),
                'defaultOrder' => 'sales_persons.name',
            ),
        ));
    }

    public $salesPersonName;
    public $customerName;
    public $otherCostValue;
    public $decoValue;
    public $logoSetupValue;
    public $freightValue;
    public $cusProductValue;
    public $salesInvoiceValue;
    public $otherCostCost;
    public $supDecoCost;
    public $logoSetupCost;
    public $usdFreightCost;
    public $supProductCost;
    public $invoiceNumbersText;
    public $productValueTotal;
    public $supplierProductCostTotal;
    public $salesInvoiceTotal;
    public $costOfOrderTotal;
    public $grossProfitTotal;

    public function searchGrossProfit()
    {

        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;
        $criteria->select = 't.id, sp.`name` salesPersonName, cus.cusnam customerName,'
            . '             ROUND(SUM(wd.other_cost * wd.other_cost_markup_rate * wd.prodQty ), 2) otherCostValue, 
                                ROUND(SUM(wddeco.sup_markedup_price * wddeco.quantity),2) decoValue,
                                ROUND(SUM(wddeco.logo_setup_unit_markedup_price * wddeco.quantity),2) logoSetupValue,
                                ROUND(SUM(wd.totIncVat - wd.totExVat), 2) freightValue,
                                ROUND(SUM(wd.prodCostPrice * wd.prod_supmarg * wd.prodQty),2) cusProductValue, 
                                ROUND(SUM(wd.sellPriceIncVat * wd.prodQty),2) salesInvoiceValue,
                                
                                ROUND(SUM(wd.other_cost  * wd.prodQty ),2) otherCostCost,
                                ROUND(SUM(wddeco.cost_price * wddeco.quantity),2) supDecoCost,
                                ROUND(SUM(wddeco.logo_setup_unit_price * wddeco.quantity),2) logoSetupCost,
                                ROUND(SUM(wd.productFrieghtUnitCost * wd.prodQty),2) usdFreightCost,
                                ROUND(SUM(wd.prodCostPrice * wd.prodQty),2) supProductCost,
                                
                                GROUP_CONCAT(DISTINCT i.invoiceNum SEPARATOR \',\') as invoiceNumbersText
                    ';

        $criteria->join = ' LEFT JOIN workorder w ON t.workorder_id = w.id
                            LEFT JOIN workorderdetails wd ON w.id = wd.workorderId
                            LEFT JOIN workorder_details_decorations wddeco ON wd.id = wddeco.workorder_detail_id
                            LEFT JOIN sales_persons sp ON t.ws_user_id = sp.id
                            LEFT JOIN customer cus ON t.cus_fref = cus.cuscus_fref
                            LEFT JOIN invoices i ON t.id = i.job_id';



        //$criteria->compare('t.id', $this->id);
        //$criteria->compare('t.workorder_id', $this->workorder_id);
        //$criteria->compare('t.quote_id', $this->quote_id);
        //$criteria->compare('t.quoteNum', $this->quoteNum, true);
        //$criteria->compare('t.jobNum', $this->jobNum, true);
        //$criteria->compare('t.createdDtm', $this->createdDtm, true);
        //$criteria->compare('t.notation', $this->notation, true);
        //$criteria->compare('t.followupDate', $this->followupDate, true);
        //$criteria->compare('t.dueDate', $this->dueDate, true);
        //$criteria->compare('t.user_id', $this->user_id);
        //$criteria->compare('t.status_id', $this->status_id);
        //$criteria->compare('urgent_status', $this->urgent_status);
        //$criteria->compare('t.jobname', $this->jobname, true);
        //$criteria->compare('t.cus_fref', $this->cus_fref);
        //$criteria->compare('t.customerpono', $this->customerpono, true);
        //$criteria->compare('t.isXNameProduction', $this->isXNameProduction);
        //$criteria->compare('customer.cusnam', $this->customer_search, true);
        //$criteria->compare('customer.cuscontact', $this->customer_contact_search, true);
        //$criteria->compare('customer.cusemail', $this->cusemail_search, true);
        //$criteria->compare( 'cus_fref', $this->cus_fref);
        //$criteria->compare('master_customer.mcusnam', $this->mastercus_search, true);
        //$criteria->compare('coordinator.username', $this->prdcoordinator_search, true);
        //$criteria->compare('workorder.salesorderNumber', $this->salesorder_search, true);
        //$criteria->compare('sales_persons.name', $this->salesperson_search, true);
        //$criteria->compare('t.ws_user', $this->ws_user, true);
        //$criteria->compare('t.ws_user_id', $this->ws_user_id, true);
        //$criteria->compare('orderTypeId', $this->orderTypeId);



        if ($this->spersonDateFlag == 1) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.createdDtm, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        } else if ($this->spersonDateFlag == 2) {
            if (!empty($this->datefrom) && empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') >= '" . date('Y-m-d', strtotime($this->datefrom)) . "'");
            } else if (empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') <= '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            } else if (!empty($this->datefrom) && !empty($this->dateto)) {
                $criteria->addCondition("DATE_FORMAT(t.dueDate, '%Y-%m-%d') between '" . date('Y-m-d', strtotime($this->datefrom)) . "' and '" . date('Y-m-d', strtotime($this->dateto)) . "'");
            }
        }

        if (isset(Yii::app()->session['sperson_selcted'])) {
            //t.ws_user_id
            $salespersonStrArr = Yii::app()->session['sperson_selcted'];
            if (!empty($salespersonStrArr)) {
                $criteria->addCondition("t.ws_user_id in ($salespersonStrArr)");
            }
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('t.user_id = ' . Yii::app()->user->id);
        }


        $criteria->group = "t.id";

        //here we show only jobs which is not "ON_INVENTORY" types
        // $criteria->addCondition("t.orderTypeId not in (1,2)");
        //$criteria->order = 'createdDtm DESC';

        $dataProvider = new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => false,
        ));

        if (isset(Yii::app()->session['sperson_gross_profit_query'])) {
            unset(Yii::app()->session['sperson_gross_profit_query']);
        }


        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();




        Yii::app()->session['sperson_gross_profit_query'] = $originalQuery;

        foreach ($dataProvider->getData() as $record) {
            $this->productValueTotal += $record->cusProductValue;
            $this->supplierProductCostTotal += $record->supProductCost;

            $costOfOrderLineTotal = $record->otherCostCost + $record->supDecoCost + $record->logoSetupCost + $record->usdFreightCost + $record->supProductCost;
            $this->costOfOrderTotal += $costOfOrderLineTotal;
            $this->salesInvoiceTotal += $record->salesInvoiceValue;
            $this->grossProfitTotal += round(($record->salesInvoiceValue - $costOfOrderLineTotal), 2);
        }




        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'attributes' => array(
                    'salesPersonName',
                ),
                'defaultOrder' => 'salesPersonName',
            ),
        ));
    }

    public function searchJobItemsWithoutPOs()
    {
        $jobProductModel = new JobProducts();
        $jobProductDecorationModel = new JobProductDecorations();

        $dataProvider1 = $jobProductModel->getJobItemWithoutPOJoinDataProvider();
        $dataProvider2 = $jobProductDecorationModel->getJobItemWithoutPOJoinDataProvider();

        $data1 = $dataProvider1->getData();
        $data2 = $dataProvider2->getData();

        // Add the custom field "source_table" to the data arrays
        foreach ($data1 as &$item) {
            $item['source_table'] = 'JOB_PRODUCT';
        }

        foreach ($data2 as &$item) {
            $item['source_table'] = 'JOB_PRODUCT-DECORATION';
        }

        $combinedData = array_merge($data1, $data2);

        

       // Create a new CArrayDataProvider with the combined data
       $pageSize = (int) GlobalVars::get('RecordsViewPerPage');
       return new CArrayDataProvider($combinedData, array(
        'pagination' => array(
            'pageSize' => 50, // Set the desired page size
        ),
    ));
    }

    public function getFinishedWrkOrdDtlsIds()
    {
        $finishedids = array();
        $wrkorderdlts = Workorderdetails::model()->findAll("workorderId = '{$this->workorder_id}'");
        //$productpass = false;
        //$decorationpass = false;
        foreach ($wrkorderdlts as $dtl) {
            $jobactivityflow = JobActivityFlow::model()->find("job_id = '$this->id' and wrkorderDtl_id = '$dtl->id' and type = 'Decoration' and activity in ('Emb Tape Received','Artwork Done','Job End','Artwork Allocated')");
            if (!empty($jobactivityflow))
                $finishedids[] = $dtl->id;
        }

        return $finishedids;
    }

    public function getFinishedWrkOrdDtlsIdsForInvoice()
    {
        $finishedids = array();
        $wrkorderdlts = Workorderdetails::model()->findAll("workorderId = '{$this->workorder_id}'");
        //$productpass = false;
        //$decorationpass = false;
        foreach ($wrkorderdlts as $dtl) {
            $jobactivityflow = JobActivityFlow::model()->find("job_id = '$this->id' and wrkorderDtl_id = '$dtl->id' and type = 'Product-Decoration' and activity = 'Goods Received'");
            if (!empty($jobactivityflow))
                $finishedids[] = $dtl->id;
        }

        return $finishedids;
    }

    public function getInvoice()
    {
        return  Invoice::model()->find("job_id = '$this->id'");
    }

    public function getInvoiceLink()
    {

        if ($invoice = $this->getInvoice()) {
            $returnURL = Yii::app()->createUrl("invoice/view", array("id" => $invoice->id));
            return $returnURL;
        }

        return null;
    }

    public function getCustomerLink()
    {
        $html = null;
        $customerText = $this->customer->cusnam;
        $customerContactName = '<br><div style="border-top:1px solid #C9E0ED;">' . $this->customer->cuscontact . '</div>';
        if (!empty($this->customer)) {
            if (Yii::app()->user->checkAccess('Customer.View') == true) {
                $html .= CHtml::link($customerText, array("customer/view", "id" => $this->customer->cussno), array("target" => "_blank")) . $customerContactName;
            } else {
                $html .= $customerText . $customerContactName;
            }

            if ($this->customer->status_id == 29) {
                $html .= "<br><span class='label label-important'>ACCOUNT ON HOLD</span>";
            }
        }

        return $html;
    }

    public function getMasterCustomerLink()
    {

        if (!empty($this->master)) {
            if (Yii::app()->user->checkAccess('MasterCustomer.View') == true) {
                return CHtml::link($this->master->mcusnam, array("masterCustomer/view", "id" => $this->customer->master->mcuscus), array("target" => "_blank"));
            } else {
                return $this->master->mcusnam;
            }
        }

        return null;
    }

    public function focussearch($jobid)
    {

        $poIDs = array();
        $invIDs = array();
        $doIDs = array();
        $artworkIDs = array();


        $sql = "select quote_id,workorder_id from jobs where id = '$jobid'";
        $result = Yii::app()->db->createCommand($sql)->queryRow();
        $quoteID = $result['quote_id'];
        $workorderID = $result['workorder_id'];


        $sql2 = "select id from purchase_orders where job_id = '$jobid'";
        $result2 = Yii::app()->db->createCommand($sql2)->queryAll();

        foreach ($result2 as $raw) {
            $poIDs[] = $raw['id'];
        }


        $sqlArtworkJob = "select id from job_artwork where job_id = '$jobid'";
        $resultArtworkJob = Yii::app()->db->createCommand($sqlArtworkJob)->queryAll();

        foreach ($resultArtworkJob as $raw) {
            $artworkIDs[] = $raw['id'];
        }

        $sql3 = "select id from invoices where job_id = '$jobid'";
        $result3 = Yii::app()->db->createCommand($sql3)->queryAll();

        foreach ($result3 as $raw) {
            $invIDs[] = $raw['id'];
        }

        if (count($invIDs) > 0) {

            foreach ($invIDs as $inid) {
                $sql4 = "select id from delivery_dockets where invoiceId = '$inid'";
                $result4 = Yii::app()->db->createCommand($sql4)->queryAll();
                $doIDs[$inid] = array();
                foreach ($result4 as $raw) {
                    $doIDs[$inid][] = $raw['id'];
                }
            }
        }

        return array(
            'jobID' => $jobid,
            'quoteid' => $quoteID,
            'workorderid' => $workorderID,
            'pos' => $poIDs,
            'invs' => $invIDs,
            'dos' => $doIDs,
            'artworks' => $artworkIDs,
        );
    }

    public function getFlowStatus()
    {
        if ($this->status_id == 17)
            return 'complete';

        if (!empty($this->dueDate)) {
            if ($this->status_id != 17 && date('Y-m-d', strtotime('now')) > date('Y-m-d', strtotime($this->dueDate))) {
                return 'due';
            } else {
                return 'notcomplete';
            }
        } else {
            return 'notcomplete';
        }
    }

    public static function getJobsByStatus($statusID)
    {
        $dependency = new CDbCacheDependency("SELECT MAX(id) FROM jobs");
        $completeJobIDs = self::getCompletedJobStrIDs();
        $criteria = new CDbCriteria;
        $criteria->addCondition("status_id = '{$statusID}'");
        if ($completeJobIDs) {
            $criteria->addNotInCondition("id", explode(',', $completeJobIDs));
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('user_id = ' . Yii::app()->user->id);
        }

        $jobs = Jobs::model()->cache(3600, $dependency)->findAll($criteria);
        return $jobs;
    }

    public static function getUrgentJobs()
    {
        $dependency = new CDbCacheDependency("SELECT MAX(id) FROM jobs");
        $completeJobIDs = self::getCompletedJobStrIDs();
        $criteria = new CDbCriteria;
        $criteria->addCondition("urgent_status = 19");

        if ($completeJobIDs) {
            $criteria->addNotInCondition("id", explode(',', $completeJobIDs));
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('user_id = ' . Yii::app()->user->id);
        }

        $jobs = Jobs::model()->cache(3600, $dependency)->findAll($criteria);
        return $jobs;
    }

    public static function getXNameProductionJobs()
    {
        $dependency = new CDbCacheDependency("SELECT MAX(id) FROM jobs");
        $completeJobIDs = self::getCompletedJobStrIDs();
        $criteria = new CDbCriteria;
        $criteria->addCondition("isXNameProduction = 1");

        if ($completeJobIDs) {
            $criteria->addNotInCondition("id", explode(',', $completeJobIDs));
        }

        if (!User::isAdmin()) {
            $criteria->addCondition('user_id = ' . Yii::app()->user->id);
        }

        $jobs = Jobs::model()->cache(3600, $dependency)->findAll($criteria);
        return $jobs;
    }

    public static function getJobsBetween($iniDate, $endDate)
    {
        $dependency = new CDbCacheDependency("SELECT MAX(id) FROM jobs");
        $criteria = new CDbCriteria;
        if (!User::isAdmin()) {
            $criteria->addCondition('user_id = ' . Yii::app()->user->id);
        }

        $criteria->addCondition("DATE_FORMAT(createdDtm, '%Y-%m-%d') between '{$iniDate}' and '{$endDate}'");

        $jobs = Jobs::model()->cache(3600, $dependency)->findAll($criteria);
        return $jobs;
    }

    public function getColorCodedOutstandingHTML()
    {
        $focussearcharr = $this->focussearch($this->id);


        $jobstyle = '';
        if ($this->getFlowStatus() == 'complete')
            $jobstyle = 'style="background-color:green;float:left;width:160px;"';
        else if ($this->getFlowStatus() == 'due')
            $jobstyle = 'style="background-color:#DC1B00;float:left;width:160px;"';
        else if ($this->getFlowStatus() == 'notcomplete')
            $jobstyle = 'style="background-color:orange;float:left;width:160px;"';

        $html .= '<div ' . $jobstyle . ' >
                                    <div  >Job</div>
                                    <div>' . CHtml::link($this->jobNum, array("jobs/view", "id" => $this->id), array("target" => "_blank", 'style' => 'color:#fff;'))
            . '</div>
                                </div>';

        $html .= '<div style="float:left;width:400px;">
                    <div style="width: 100%;text-align: center;background-color: #C9E0ED;"><b>Customer Information</b></div>
                    <div style="">
                        <b>Name</b> : ' . $this->customer->cusnam . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                        <b>Telephone</b> : ' . $this->customer->custel . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <b>Email</b> : ' . $this->customer->cusemail . '</div>
                </div><div class="clear"></div>';

        $poidarr = $focussearcharr['pos'];
        $poidstr = implode(',', $poidarr);

        if (!empty($poidstr)) {
            $purchaseorders = PurchaseOrders::model()->findAll(array('condition' => "id in ($poidstr)"));
            $pocount = 0;
            foreach ($purchaseorders as $po) {
                $pocount++;
                $postyle = '';
                if ($po->getFlowStatus() == 'complete')
                    $postyle = 'style="background-color:green;float:left;width:160px;"';
                else if ($po->getFlowStatus() == 'due')
                    $postyle = 'style="background-color:#DC1B00;float:left;width:160px;"';
                else if ($po->getFlowStatus() == 'notcomplete')
                    $postyle = 'style="background-color:orange;float:left;width:160px;"';

                $html .= '<div  ' . $postyle . ' >
                                            <div >PO</div>
                                            <div>' . CHtml::link($po->poNum, array("purchaseOrders/view", "id" => $po->id), array("target" => "_blank", 'style' => 'color:#fff;')) . '<br>'
                    . '</div>
                                            <div> Due : ';

                if (!empty($po->dueDate))
                    $html .= date(GlobalVars::get("DateFormat"), strtotime($po->dueDate));
                else
                    $html .= 'Not Set';

                $html .= '</div>
                                        </div> ';
                if ($pocount == count($purchaseorders))
                    $html .= '<div class="clear"></div>';
            }
        }

        //internal artwork jobs
        $artworkjobarr = $focussearcharr['artworks'];
        $artjobidstr = implode(',', $artworkjobarr);
        if (!empty($artjobidstr)) {
            $artworkjobs = JobArtwork::model()->findAll(array('condition' => "id in ($artjobidstr)"));
            $artjobcount = 0;
            foreach ($artworkjobs as $artwrk) {
                $artjobcount++;
                $artjobstyle = '';
                if ($artwrk->getFlowStatus() == 'complete')
                    $artjobstyle = 'style="background-color:green;float:left;width:160px;"';
                else if ($artwrk->getFlowStatus() == 'due')
                    $artjobstyle = 'style="background-color:#DC1B00;float:left;width:160px;"';
                else if ($artwrk->getFlowStatus() == 'notcomplete')
                    $artjobstyle = 'style="background-color:orange;float:left;width:160px;"';

                $html .= '<div  ' . $artjobstyle . ' >
                                            <div >Artwork Job</div>
                                            <div>' . CHtml::link($artwrk->artworkjobNum, array("jobArtwork/view", "id" => $artwrk->id), array("target" => "_blank", 'style' => 'color:#fff;')) . '<br>'
                    . '</div>  
                                            <div> Due : ';

                if (!empty($artwrk->dueDate))
                    $html .= date(GlobalVars::get("DateFormat"), strtotime($artwrk->dueDate));
                else
                    $html .= 'Not Set';

                $html .= '</div>
                                        </div>';
                if ($artjobcount == count($artworkjobs))
                    $html .= '<div class="clear"></div>';
            }
        }
        $invidarr = $focussearcharr['invs'];
        $invidstr = implode(',', $invidarr);
        if (!empty($invidstr)) {

            $html .= '<div style="border: 1px solid #C9E0ED;float:left;width:160px;">
                                    <div >Invoice</div>
                                    <div>';


            $invoices = Invoice::model()->findAll(array('condition' => "id in ($invidstr)"));

            foreach ($invoices as $invoice) {

                $html .= CHtml::link($invoice->invoiceNum, array("invoice/view", "id" => $invoice->id), array("target" => "_blank")) . '<br>';
            }


            $html .= '</div>
                                </div><br>';


            $invdoarr = $focussearcharr['dos'];
            $doidarr = array();

            foreach ($invdoarr as $invid => $doarr) {
                foreach ($doarr as $doid) {
                    $doidarr[] = $doid;
                }
            }

            $doidstr = implode(',', $doidarr);
            if (!empty($doidstr)) {
                $deleveryords = DeliveryDockets::model()->findAll(array('condition' => "id in ($doidstr)"));
                $docount = 0;
                foreach ($deleveryords as $do) {
                    $docount++;
                    $html .= '<div style="border: 1px solid #C9E0ED;float:left;width:160px;">
                                            <div >DO</div>
                                            <div>' . CHtml::link($do->diliveryDocketNum, array("deliveryDockets/view", "id" => $do->id), array("target" => "_blank", 'style' => 'color:#94B9C7;')) . '<br>' .
                        '</div>
                                        </div>';
                    if ($docount == count($deleveryords))
                        $html .= '<div class="clear"></div>';
                }
            }
        }

        return $html;
    }

    public function invoiceTotal($GST_STATUS)
    {
        $total = 0;
        $workorderdetails = Workorderdetails::model()->findAll(array('condition' => "workorderId = '{$this->workorder_id}'"));
        foreach ($workorderdetails as $dtl) {
            if ($GST_STATUS == 1)
                $total += $dtl->totExVat;
            if ($GST_STATUS == 2)
                $total += $dtl->totIncVat;
        }

        return $total;
    }

    public function invoicedTotal($GST_STATUS)
    {
        $invoices = Invoice::model()->findAll(array('condition' => "job_id = '$this->id'"));
        $total = 0;
        foreach ($invoices as $invoice) {
            if ($GST_STATUS == Jobs::EXCLUDING_GST) {
                $total += $invoice->getTotExVat();
            } else if ($GST_STATUS == Jobs::INCLUDING_GST) {
                $total += $invoice->getTotIncVat();
            }
        }

        return $total;
    }

    //access functions

    public function getQuoteNumLink()
    {

        if (Yii::app()->user->checkAccess('Quatation.View') == true)
            return CHtml::link($this->quoteNum, array("quatation/view", "id" => $this->quote_id), array("target" => "_blank"));
        else
            return $this->quoteNum;
    }

    public function getSONumLink()
    {

        if (Yii::app()->user->checkAccess('Workorderdetails.Admin') == true)
            return CHtml::link($this->workorder->salesorderNumber, array("workorderdetails/admin", "wid" => $this->workorder->id), array("target" => "_blank"));
        else
            return $this->workorder->salesorderNumber;
    }

    public function getJobNumberLink()
    {
        return CHtml::link($this->jobNum, array("jobs/view", "id" => $this->id), array("target" => "_blank"));
    }

    public function getJobHtml()
    {
        $workorderdetails = $this->workorder->RelDtls;
        $countdtl = count($workorderdetails);
        $html = '';
        if (!empty($this->originalJobId)) {
            $link = CHtml::link($this->jobNum, array("jobs/view", "id" => $this->id), array("target" => "_blank"));
            $html = '<div style="position: relative;width:100%;">' . $link . '</div>
                    <div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #f00;padding:1px;background-color:#f00;border-radius:3px;">Copy</div>
                    <div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #0f0;padding:1px;background-color:#0f0;border-radius:3px;">P-' . $countdtl . '</div>';
        } else {
            $link = CHtml::link($this->jobNum, array("jobs/view", "id" => $this->id), array("target" => "_blank"));
            $html = '<div style="position: relative;width:100%;">' . $link . '</div>                    
                    <div style="margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #0f0;padding:1px;background-color:#0f0;border-radius:3px;">P-' . $countdtl . '</div>';
        }

        if ($this->isXNameProduction == true) {
            $html .= '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #0f0;padding:1px;background-color:#0f0;border-radius:3px;">OFFSHORE</div>';
        }

        if ($this->status_id == 3) {
            $html .= '<br><span class="label label-important" title="Cancelled Job">Cancelled</span>';
        }
        return $html;
    }

    public function getFollowupStatus()
    {
        $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return FollowupStatus::model()->findByPk($slog->followupSts_id)->status;
        } else {
            return null;
        }
    }

    public function getFollowupStatusId()
    {
        $slog = SalesLog::model()->find(array('condition' => "category = 'Job' and tbl_id = {$this->id} and followupSts_id > 0", 'order' => "id desc"));
        if (!empty($slog)) {
            return $slog->followupSts_id;
        } else {
            return 0;
        }
    }

    public function getNameWithTotalExGst()
    {
        $html = $this->getJobNumberLink();
        //$html .= "</br><span style='float:right;' class='label label-default'>" . number_format($this->rel_workorder()->getTotalWithoutGST(), 2) . "<br /> {$this->rel_workorder()->getItemCosts()}</span>";

        return $html;
    }

    public function getAllTotalExGST()
    {
        return $this->allTotalExGST;
    }

    public function footerTemplate()
    {
        $html = '<div class="label label-success" style="text-align:right;font-size:1.2em;"><span >' . number_format($this->getAllTotalExGST(), 2) . '</span></div>';

        return $html;
    }

    public function footerTemplateCost()
    {
        $html = '<div class="label label-success" style="text-align:right;font-size:1.2em;"><span >' . number_format($this->allTotalCost, 2) . '</span></div>';

        return $html;
    }

    public static function getCompletedJobStrIDs()
    {
        $followupJobarr = array();
        //get all sales log related to quotation

        $followupstats = FollowupStatus::model()->find(array('condition' => "status = 'Job Completed' and type = 'Job'"));
        if ($followupstats->id) {
            $saleslogs = SalesLog::model()->findAll(array('condition' => "category = 'Job' and followupSts_id = {$followupstats->id}"));
            foreach ($saleslogs as $slog) {


                $followupJobarr[] = $slog->tbl_id;
            }

            //remove empty elements if have
            $followupJobarr = array_filter($followupJobarr);
            //add in condition
            $idStr = implode(',', $followupJobarr);
            if (count($followupJobarr) > 0) {
                return $idStr;
            } else {
                return "0";
            }
        }
    }

    public function getSalespersonColumnmarkUp()
    {

        if (!$this->salesperson->name) {
            return '';
        }

        $markup = $this->salesperson->name;

        if ($this->coordinator) {
            $markup .= '<div style="border-top:1px solid #C9E0ED;">' . $this->coordinator->username . '</div>';
        }

        return $markup;
    }

    public function getFullShippingAddress()
    {
        $address = array(
            $this->shipComanyName,
            $this->shipAddress1,
            $this->shipAddress2,
            $this->shipAddress3,
            $this->shipSub . ' ' . $this->shipState . ' ' . $this->shipPostalCode
        );

        $address = array_filter($address);

        return implode(', ', $address);
    }

    public function getUrgentHtml()
    {

        $labelText = Status::model()->findByPk($this->urgent_status)->name;
        if (in_array($this->urgent_status, array(19))) {
            return '<div style="display:inline;margin-left:auto;margin-right:auto;width:20%;color:#fff;font-weight:bold;top:-5px;right:0px;font-size:0.8em;border:1px solid #f00;padding:1px;background-color:#f00;border-radius:3px;">' . $labelText . '</div>';
        }

        return $labelText;
    }
}
