<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class MPDFGenerator extends CFormModel {
    public $mdf_header = '<img src="images/pdf_default_header_gunweb.jpg" style="border-bottom: 1px solid #000;"/>';



    public function __construct() {
       
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
        );
    }

    public function createPDF($html, $output = array('type' => 'I', 'filename'=>'aranxa'), $pdfinfo = array('header' => null,'title'=>'Aranxa PDF')) {
        if($pdfinfo['header'] != null)$this->mdf_header = $pdfinfo['header'];
            

        //$mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
		require_once 'vendor/autoload.php';
		$mPDF1 = new \Mpdf\Mpdf(
				array(// More info: http://mpdf1.com/manual/index.php?tid=184
			'mode' => '', //  This parameter specifies the mode of the new document.
			'format' => 'A4', // format A4, A5, ...
			'default_font_size' => 0, // Sets the default document font size in points (pt)
			'default_font' => '', // Sets the default font-family for the new document.
			'mgl' => 10, // margin_left. Sets the page margins for the new document.
			'mgr' => 10, // margin_right
			'mgt' => 27, // margin_top
			'mgb' => 10, // margin_bottom
			'mgh' => 5, // margin_header
			'mgf' => 15, // margin_footer
			'orientation' => 'P', // landscape or portrait orientation
				)
		); 
        $mPDF1->SetTitle($pdfinfo['title']);
        
        $mPDF1->SetHTMLHeader($this->mdf_header);
        
       $mPDF1->WriteHTML($html);
            
        
        //Close and output PDF document
        if($output['type'] == 'I'){
            $mPDF1->Output($output['filename']. ".pdf",'I');
        }else if($output['type'] == 'F'){
            $mPDF1->Output($output['filename'] . ".pdf", $output['type']);
        }
        
        //Yii::app()->end();
    }
    
    public function createWorkWearPDF($html, $output = array('type' => 'I', 'filename'=>'aranxa'), $pdfinfo = array('header' => null,'title'=>'Aranxa PDF')) {
        $this->mdf_header = '<img src="images/workwear_header.png" style="border-bottom: 1px solid #000;"/>';
            

        //$mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
		require_once 'vendor/autoload.php';
		$mPDF1 = new \Mpdf\Mpdf(
				array(// More info: http://mpdf1.com/manual/index.php?tid=184
			'mode' => '', //  This parameter specifies the mode of the new document.
			'format' => 'A4', // format A4, A5, ...
			'default_font_size' => 0, // Sets the default document font size in points (pt)
			'default_font' => '', // Sets the default font-family for the new document.
			'mgl' => 10, // margin_left. Sets the page margins for the new document.
			'mgr' => 10, // margin_right
			'mgt' => 27, // margin_top
			'mgb' => 10, // margin_bottom
			'mgh' => 5, // margin_header
			'mgf' => 15, // margin_footer
			'orientation' => 'P', // landscape or portrait orientation
				)
		); 
        $mPDF1->SetTitle($pdfinfo['title']);
        
        $mPDF1->SetHTMLHeader($this->mdf_header);
        
       $mPDF1->WriteHTML($html);
            
        
        //Close and output PDF document
        if($output['type'] == 'I'){
            $mPDF1->Output($output['filename']. ".pdf",'I');
        }else if($output['type'] == 'F'){
            $mPDF1->Output($output['filename'] . ".pdf", $output['type']);
        }
        
        //Yii::app()->end();
    }

}
