<?php

/**
 * This is the model class for table "myob_guids".
 *
 * The followings are the available columns in table 'myob_guids':
 * @property string $id
 * @property string $uuid
 * @property string $account_name
 * @property string $library_path
 * @property string $country
 * @property string $launcher_id
 * @property string $serial_number
 */
class MYOBGuide extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MYOBGuide the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'myob_guids';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uuid, launcher_id', 'length', 'max'=>36),
			array('account_name, library_path', 'length', 'max'=>255),
			array('country', 'length', 'max'=>20),
			array('serial_number', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uuid, account_name, library_path, country, launcher_id, serial_number', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uuid' => 'Uuid',
			'account_name' => 'Account Name',
			'library_path' => 'Library Path',
			'country' => 'Country',
			'launcher_id' => 'Launcher',
			'serial_number' => 'Serial Number',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('uuid',$this->uuid,true);
		$criteria->compare('account_name',$this->account_name,true);
		$criteria->compare('library_path',$this->library_path,true);
		$criteria->compare('country',$this->country,true);
		$criteria->compare('launcher_id',$this->launcher_id,true);
		$criteria->compare('serial_number',$this->serial_number,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}