<?php

/**
 * This is the model class for table "myob_tokens".
 *
 * The followings are the available columns in table 'myob_tokens':
 * @property string $id
 * @property string $access_token
 * @property string $refresh_token
 * @property string $access_token_expires_in
 * @property string $created_at
 * @property integer $created_by
 * @property string $account_owner_uuid UID of MYOB account owner
 * @property string $account_owner_username username of MYOB account owner
 */
class MYOBToken extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MYOBToken the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'myob_tokens';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('created_by, access_token_expires_in', 'numerical', 'integerOnly'=>true),
			array('access_token, refresh_token, created_at', 'safe'),
			array('account_owner_uuid', 'length', 'max' => 36),
			array('account_owner_username', 'length', 'max' => 255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, access_token, refresh_token, access_token_expires_in, created_at, created_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'access_token' => 'Access Token',
			'refresh_token' => 'Refresh Token',
			'access_token_expires_in' => 'Access Token Expires In',
			'created_at' => 'Created At',
			'created_by' => 'Created By',
			'account_owner_uuid' => 'Account Owner UID',
			'account_owner_username' => 'Account Owner',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('access_token',$this->access_token,true);
		$criteria->compare('refresh_token',$this->refresh_token,true);
		$criteria->compare('account_owner_username',$this->account_owner_username,true);		
		$criteria->compare('access_token_expires_in',$this->access_token_expires_in,true);
		$criteria->compare('created_at',$this->created_at,true);
		$criteria->compare('created_by',$this->created_by);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}