<?php

/**
 * This is the model class for table "master_customer".
 *
 * The followings are the available columns in table 'master_customer':
 * @property integer $mcussno
 * @property string $mcuscus
 * @property string $mcuscus_fref
 * @property string $mcusnam
 * @property string $mcusfnam
 * @property string $mcussnam
 * @property string $mcusadd1
 * @property string $mcusadd2
 * @property string $mcusadd3
 * @property string $mcustown
 * @property string $mcusstate
 * @property string $mcuspostcode
 * @property integer $mcuscousno
 * @property string $mcustel
 * @property string $mcusfax
 * @property string $mcusemail
 * @property double $mcusdispcn
 * @property string $mcusimgpath
 * @property string $mcuscontact
 * @property string $mcusucdnew
 * @property string $mcusentddt
 * @property string $mcusenttime
 * @property string $mcusucdame
 * @property string $mcusameddt
 * @property string $mcusametime
 * @property integer $categoryId
 * @property integer $industryId
 * @property integer $salesPersonId
 * @property integer $payment_type_id
 * @property integer $payment_type_days
 */
class MasterCustomer extends CActiveRecord implements MYOBSynchronizable {

    public $subcustomerid;
    public $importFile;

    /**
     * Provide the logic to be synchronized this record in an API 
     * @var MYOBSynchronizer concrete implementation of Synchronizer
     */
    public $synchronizer;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return MasterCustomer the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'master_customer';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            //array('mcussnam,mcuscus', 'required'),
            array('mcuscousno, subcustomerid, salesPersonId', 'numerical', 'integerOnly' => true),
            array('mcusnam', 'required'),
            array('mcusdispcn, isIndividualMYOB, myob_taxId, myob_freightTaxId, payment_type_id, payment_type_days', 'numerical'),
            array('mcuscus, mcuscontact, mcusucdnew, mcusucdame', 'length', 'max' => 50),
            array('mcuscus_fref, mcusnam, mcusfnam, mcussnam, mcusadd1, mcusadd2, mcusadd3, mcustel, mcusfax, mcusemail, mcusimgpath, myob_row_version,qca_ref, categoryId, industryId, shipCountryId, xeroContactID', 'length', 'max' => 255),
            array('mcustown, firstName, lastName', 'length', 'max' => 40),
            array('shipAddress1, shipAddress2, shipAddress3', 'length', 'max' => 150),
            array('shipSub, shipState, shipPostalCode', 'length', 'max' => 100),
            array('mcusstate', 'length', 'max' => 30),
            array('mcuspostcode', 'length', 'max' => 10),
            array('displayIdMYOB', 'length', 'max' => 15),
            array('mcustel2, mcustel3', 'length', 'max' => 21),
            array('myob_guid_uuid, myob_uuid', 'length', 'max' => 36),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('mcussno, mcuscus, mcuscus_fref, mcusnam, mcusfnam, mcussnam, mcusadd1, mcusadd2, mcusadd3, mcustown, mcusstate, mcuspostcode,'
                . ' mcuscousno, mcustel, mcusfax, mcusemail, mcusdispcn, mcusimgpath, mcuscontact, mcusucdnew, mcusentddt, mcusenttime, mcusucdame, '
                . 'mcusameddt, mcusametime, firstName, lastName, displayIdMYOB, mcustel2, mcustel3, json_response, myob_uuid, importFile', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'category' => array(self::BELONGS_TO, 'CustomerCategory', 'categoryId'),
            'industry' => array(self::BELONGS_TO, 'CustomerIndustry', 'industryId'),
            'salesPerson' => array(self::BELONGS_TO, 'SalesPerson', 'salesPersonId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'mcussno' => 'Mcussno',
            'mcuscus' => 'Code',
            'mcuscus_fref' => 'Mcuscus Fref',
            'mcusnam' => 'Company Name',
            'mcusfnam' => 'Mcusfnam',
            'mcussnam' => 'Mcussnam',
            'mcusadd1' => 'Address',
            'mcusadd2' => 'Address 2',
            'mcusadd3' => 'Address 3',
            'mcustown' => 'Town',
            'mcusstate' => 'State',
            'mcuspostcode' => 'Post Code',
            'mcuscousno' => 'Mcuscousno',
            'mcustel' => 'Telephone',
            'mcusfax' => 'Fax',
            'mcusemail' => 'Email',
            'mcusdispcn' => 'Discount %',
            'mcusimgpath' => 'Image Path',
            'mcuscontact' => 'Contact',
            'mcusucdnew' => 'Created By',
            'mcusentddt' => 'Created Date',
            'mcusenttime' => 'Created Time',
            'mcusucdame' => 'Mcusucdame',
            'mcusameddt' => 'Edit Date',
            'mcusametime' => 'Edit Time',
            'displayIdMYOB' => 'MYOB Display ID',
            'firstName' => 'Fisrt Name',
            'lastName' => 'Last Name',
            'myob_taxId' => 'MYOB Tax Code',
            'myob_freightTaxId' => 'MYOB Freight Tax Code',
            'mcustel2' => 'Telephone 2',
            'mcustel3' => 'Telephone 3',
            'isIndividualMYOB' => 'MYOB Is Individual',
            'qca_ref' => 'Reference',
            'categoryId' => 'Category',
            'industryId' => 'Industry',
            'salesPersonId' => 'Sales Person',
            'payment_type_id' => 'Payment Term Type',
            'payment_type_days' => 'Payment Days'
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        //$criteria->compare('mcussno', $this->mcussno);
        //$criteria->compare('mcuscus', $this->mcuscus, true);
        //$criteria->compare('mcuscus_fref', $this->mcuscus_fref, true);
        $criteria->compare('mcusnam', $this->mcusnam, true);
        //$criteria->compare('mcusfnam', $this->mcusfnam, true);
        //$criteria->compare('mcussnam', $this->mcussnam, true);
        $criteria->compare('mcusadd1', $this->mcusadd1, true);
        //$criteria->compare('mcusadd2', $this->mcusadd1, true);
        //$criteria->compare('mcusadd3', $this->mcusadd1, true);
        //$criteria->compare('mcustown', $this->mcusadd1, true);
        //$criteria->compare('mcusstate', $this->mcusadd1, true);
        //$criteria->compare('mcuspostcode', $this->mcusadd1, true);
        //$criteria->compare('mcuscousno', $this->mcuscousno);
        $criteria->compare('mcustel', $this->mcustel, true);
        $criteria->compare('mcusfax', $this->mcusfax, true);
        $criteria->compare('mcusemail', $this->mcusemail, true);
        //$criteria->compare('mcusdispcn', $this->mcusdispcn);
        //$criteria->compare('mcusimgpath', $this->mcusimgpath, true);
        $criteria->compare('mcuscontact', $this->mcuscontact, true);
        //$criteria->compare('mcusucdnew', $this->mcusucdnew, true);
        //$criteria->compare('mcusentddt', $this->mcusentddt, true);
        //$criteria->compare('mcusenttime', $this->mcusenttime, true);
        //$criteria->compare('mcusucdame', $this->mcusucdame, true);
        //$criteria->compare('mcusameddt', $this->mcusameddt, true);
        //$criteria->compare('mcusametime', $this->mcusametime, true);
        //$criteria->compare('displayIdMYOB', $this->displayIdMYOB, true);
        $criteria->compare('firstName', $this->firstName, true);
        $criteria->compare('lastName', $this->lastName, true);

        $criteria->compare('categoryId', $this->categoryId);
        $criteria->compare('industryId', $this->industryId);

        $originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

        //here define the filter fields by exactly value
        $paramarr = array(
            'categoryId=:' => $this->categoryId,
            'industryId=:' => $this->industryId
        );

        //here define the filter fields by like values
        $paramarrLike = array(
            'firstName LIKE :' => $this->mcusnam,
            'lastName LIKE :' => $this->mcusadd1,
            'mcusnam LIKE :' => $this->mcusnam,
            'mcusadd1 LIKE :' => $this->mcusadd1,
            'mcustel LIKE :' => $this->mcustel,
            'mcusfax LIKE :' => $this->mcusfax,
            'mcusemail LIKE :' => $this->mcusemail,
            'mcuscontact LIKE :' => $this->mcuscontact
        );

        //here we remove and replace Yii specific criterias
        //for exactly check
        foreach ($paramarr as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace('=:', '', $key);
                    $param .= "='$value'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        //for like check

        foreach ($paramarrLike as $key => $value) {
            if (!empty($key)) {
                $position = strpos($originalQuery, $key);
                if ($position != false && $position >= 0) {
                    $param = str_replace(':', '', $key);
                    $param .= " '%$value%'";
                    $originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
                }
            }
        }

        Yii::app()->session['master_customer_expt_qry'] = $originalQuery;


        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'mcusnam ASC',
            )
        ));
    }

    protected function beforeSave() {

        if ($this->isNewRecord) {
            $lastcode = $this->_getLastCode();
            $this->mcuscus = ++$lastcode;

            $this->mcusfnam = $this->mcusnam;
            $this->mcussnam = $this->mcusnam;

            $this->mcusentddt = date("Y-m-d");
            $this->mcusenttime = date('H:i:s');
        }

        $this->mcusameddt = date("Y-m-d");
        $this->mcusametime = date('H:i:s');


        return parent::beforeSave();
    }

    private function _getLastCode() {
        $result = Yii::app()->db->createCommand('select mcuscus from master_customer order by mcussno desc limit 1')->queryRow();
        return $result['mcuscus'];
    }

    public function getAddress() {
        $threeaddress = '';
        if (!empty($this->mcusadd1)) {
            $threeaddress .= $this->mcusadd1;
        }

        if (!empty($this->mcusadd2)) {
            $threeaddress .= ', ' . $this->mcusadd2;
        }

        if (!empty($this->mcusadd3)) {
            $threeaddress .= ', ' . $this->mcusadd3;
        }

        return $threeaddress;
    }

    public function getMYOBJson() {

        //required - TaxCode,FreightTaxCode
        $myobsettings = MyobSetting::getSettings();
        $taxcode = $this->myob_taxId ? MyobTaxCode::model()->findByPk($this->myob_taxId) : MyobTaxCode::model()->findByPk($myobsettings->cus_taxcode_id);
        $freighttaxcode = $this->myob_freightTaxId ? MyobTaxCode::model()->findByPk($this->myob_freightTaxId) : MyobTaxCode::model()->findByPk($myobsettings->cus_freight_taxcode_id);

        $taxcodeuuid = $taxcode ? $taxcode->uuid : null;
        $freightcodeuuid = $freighttaxcode ? $freighttaxcode->uuid : null;

        $customerarr = array(
            "CompanyName" => $this->mcusnam,
            "IsIndividual" => $this->isIndividualMYOB ? true : false,
            "DisplayID" => $this->displayIdMYOB,
            "LastName" => $this->lastName,
            "FirstName" => $this->firstName,
            "IsActive" => "true",
            "SellingDetails" => array(
                "TaxCode" => array(
                    "UID" => $taxcodeuuid,
                ),
                "FreightTaxCode" => array(
                    "UID" => $freightcodeuuid,
                ),
            )
        );




        $street = $this->mcusadd1 . " " . $this->mcusadd2 . " " . $this->mcusadd3;
        $city = $this->mcustown ? $this->mcustown : null;
        $state = $this->mcusstate ? $this->mcusstate : null;
        $postal = $this->mcuspostcode ? $this->mcuspostcode : null;
        $phone1 = $this->mcustel ? $this->mcustel : null;
        $phone2 = $this->mcustel2 ? $this->mcustel : null;
        $phone3 = $this->mcustel3 ? $this->mcustel : null;
        $fax = $this->mcusfax ? $this->mcusfax : null;
        $email = $this->mcusemail ? $this->mcusemail : null;
        $contact = $this->mcuscontact ? $this->mcuscontact : null;
        $customerarr["Addresses"][] = array(
            "Location" => 1,
            "Street" => $street,
            "City" => $city,
            "State" => $state,
            "PostCode" => $postal,
            "Country" => "Australia",
            "Phone1" => $phone1,
            "Phone2" => $phone2,
            "Phone3" => $phone3,
            "Fax" => $fax,
            "Email" => $email,
            "ContactName" => $contact
        );

        /* this will force  MYOB to update the record */
        /* this section will only be added if company file of this record ( myob guid) is same as the current login one */
        if ($this->myob_uuid && $this->myob_row_version) {
            $customerarr["UID"] = $this->myob_uuid;
            $customerarr["RowVersion"] = $this->myob_row_version;
        }


        return json_encode($customerarr);
    }

    public function getMYOBError() {
        $obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
        return $obj ? MYOBResponse::formatError($obj) : '';
    }

    public function myobLastModified() {
        return date('Y-m-d H:i:s', strtotime($this->mcusameddt . ' ' . $this->mcusametime));
    }

    /**
     * @override
     * Synchronize current record with MYOB
     * @param MYOBApiConnector $myobConnector api connection
     * @return boolean success true, otherwise false
     */
    public function myobSynchronize(\MYOBApiConnector $myobConnector) {
        return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
    }

    public function reportMYOBError(\MYOBResponse $response) {
        try {
            return Yii::app()->db->createCommand()
                            ->update('master_customer', array(
                                'json_response' => serialize($response),
                                    ), "mcussno=$this->mcussno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    public function setSynchronizer(\MYOBSynchronizer $synchronizer) {
        $this->synchronizer = $synchronizer;
    }

    public function toJsonString() {
        return $this->getMYOBJson();
    }

    public function updateByMYOB(\MYOBResponse $response) {
        try {
            $dataArr = self::myobProductDataCore($response);
            if (in_array($response->DisplayID, array(null, '', '*None'))) { /* MYOB DisplayID may contain with empty or *None value */
                $dataArr['mcuscus'] = $this->mcuscus ?: $this->mcussno;
                $dataArr['displayIdMYOB'] = $this->displayIdMYOB ?: $this->mcussno;
            }
            Yii::app()->db->createCommand()
                    ->update('master_customer', $dataArr, "mcussno=$this->mcussno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public function updateMYOBReferences(\MYOBResponse $response) {
        try {
            Yii::app()->db->createCommand()
                    ->update('master_customer', array(
                        'myob_uuid' => $response->UID,
                        'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
                        'myob_row_version' => $response->RowVersion,
                        'json_response' => null,
                            ), "mcussno=$this->mcussno" /* where condition */
            );
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }

        return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
    }

    public static function createByMYOB(\MYOBResponse $response) {
        try {
            $dataArr = self::myobProductDataCore($response);
            $dataArr['mcuscus'] = $response->DisplayID;
            $dataArr['mcuscus_fref'] = $response->DisplayID;
            $dataArr['displayIdMYOB'] = $response->DisplayID;
            $dataArr['mcusentddt'] = date('Y-m-d');
            $dataArr['mcusenttime'] = date('H:i:s');
            if (in_array($response->DisplayID, array(null, '', '*None'))) { /* MYOB DisplayID may contain with empty or *None value */
                $dataArr['mcuscus'] = time();
                $dataArr['mcuscus_fref'] = time();
                $dataArr['displayIdMYOB'] = time();
            }
            if (Yii::app()->db->createCommand()
                            ->insert('master_customer', $dataArr)) {
                $lastInsertID = Yii::app()->db->getLastInsertID();
                Yii::app()->db->createCommand("UPDATE master_customer SET mcuscus = master_customer.mcussno, mcuscus_fref = master_customer.mcussno, displayIdMYOB = master_customer.mcussno  WHERE mcussno = {$lastInsertID}")->execute();

                return true;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    /**
     * Encapsulate supplier data creation from MYOB response
     * @return array key,value pairs represent this data table
     */
    static function myobProductDataCore(\MYOBResponse $response) {
        $addressArr = $response->Addresses;
        $sellingDetailArr = $response->SellingDetails;



        if ($taxUID = $sellingDetailArr["TaxCode"]["UID"]) {
            $taxRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $taxUID,))->queryRow();
        }
        if ($freightTaxUID = $sellingDetailArr["FreightTaxCode"]["UID"]) {
            $freightTaxRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $freightTaxUID,))->queryRow();
        }
        return array(
            'mcuscus' => $response->DisplayID,
            'displayIdMYOB' => $response->DisplayID,
            'myob_uuid' => $response->UID,
            'mcusnam' => (boolval($response->IsIndividual) ? ($response->FirstName . ' ' . $response->LastName) : $response->CompanyName),
            'mcusfnam' => (boolval($response->IsIndividual) ? ($response->FirstName . ' ' . $response->LastName) : $response->CompanyName),
            'mcussnam' => (boolval($response->IsIndividual) ? ($response->FirstName . ' ' . $response->LastName) : $response->CompanyName),
            'mcusadd1' => $addressArr[0]["Street"],
            'mcustown' => $addressArr[0]["City"],
            'mcusstate' => $addressArr[0]["State"],
            'mcuspostcode' => $addressArr[0]["PostCode"],
            'mcustel' => $addressArr[0]["Phone1"],
            'mcustel2' => $addressArr[0]["Phone2"],
            'mcustel3' => $addressArr[0]["Phone3"],
            'mcusfax' => $addressArr[0]["Fax"],
            'mcusemail' => $addressArr[0]["Email"],
            'mcuscontact' => $addressArr[0]["ContactName"],
            //'myob_item_price_level' => $sellingDetailArr["ItemPriceLevel"],
            'myob_row_version' => $response->RowVersion,
            'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
            'myob_taxId' => isset($taxRaw) ? $taxRaw['id'] : null,
            'myob_tax_uuid' => $sellingDetailArr["TaxCode"]["UID"],
            'myob_freightTaxId' => isset($freightTaxRaw) ? $freightTaxRaw['id'] : null,
            'myob_freightTax_uuid' => $sellingDetailArr["FreightTaxCode"]["UID"],
            'json_response' => null,
            'mcusameddt' => date('Y-m-d', strtotime($response->LastModified)),
            'mcusametime' => date('H:i:s', strtotime($response->LastModified))
        );
    }

    public function reportMYOBSuccess(\MYOBResponse $response) {
        
    }
}
