<?php

/**
 * This is the model class for table "myob_accounts".
 *
 * The followings are the available columns in table 'myob_accounts':
 * @property integer $id
 * @property string $uuid
 * @property string $name
 * @property string $displayId
 * @property string $classification
 * @property string $type
 * @property integer $number
 * @property integer $taxCodeId
 * @property string $openingBalance
 * @property string $currentBalance
 * @property string $row_version
 * @property integer $myob_guid_uuid MYOB account id ( CompanyFile )
 */
class MyobAccount extends CActiveRecord implements MYOBSynchronizable
{
	public $accountDisplay;

	/**
	 * Provide the logic to be synchronized this record in an API 
	 * @var MYOBSynchronizer concrete implementation of Synchronizer
	 */
	public $synchronizer;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return MyobAccount the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'myob_accounts';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('name,displayId,type,classification,number', 'required'),
			array('number, taxCodeId', 'numerical', 'integerOnly' => true),
			array('uuid, myob_guid_uuid', 'length', 'max' => 36),
			array('name', 'length', 'max' => 30),
			array('displayId', 'length', 'max' => 6),
			array('classification, type', 'length', 'max' => 45),
			array('openingBalance, currentBalance', 'length', 'max' => 13),
			array('row_version,description', 'length', 'max' => 255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uuid, name, displayId, classification, type, number, taxCodeId, openingBalance, currentBalance, row_version, description', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uuid' => 'Uuid',
			'name' => 'Name',
			'displayId' => 'Display',
			'classification' => 'Classification',
			'type' => 'Type',
			'number' => 'Number',
			'taxCodeId' => 'Tax Code',
			'openingBalance' => 'Opening Balance',
			'currentBalance' => 'Current Balance',
			'row_version' => 'Row Version',
			'description' => 'Description',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('uuid', $this->uuid, true);
		$criteria->compare('name', $this->name, true);
		$criteria->compare('displayId', $this->displayId, true);
		$criteria->compare('classification', $this->classification, true);
		$criteria->compare('type', $this->type, true);
		$criteria->compare('number', $this->number);
		$criteria->compare('taxCodeId', $this->taxCodeId);
		$criteria->compare('openingBalance', $this->openingBalance, true);
		$criteria->compare('currentBalance', $this->currentBalance, true);
		$criteria->compare('row_version', $this->row_version, true);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
	}

	public static function getAccount($uuid)
	{
		return MyobAccount::model()->find(array('condition' => "uuid = '{$uuid}'"));
	}

	public function getMYOBError()
	{
		$obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
		return $obj ? MYOBResponse::formatError($obj) : '';
	}

	/**
	 * @return string date time
	 */
	public function myobLastModified()
	{
		return '';
	}

	/**
	 * @override
	 * Synchronize current record with MYOB
	 * @param MYOBApiConnector $myobConnector api connection
	 * @return boolean success true, otherwise false
	 */
	public function myobSynchronize(\MYOBApiConnector $myobConnector)
	{
		return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
	}

	public function reportMYOBError(\MYOBResponse $response)
	{
		Yii::app()->db->createCommand()
				->update('myob_accounts', array(
					'json_response' => serialize($response),
						), "id=$this->id" /* where condition */
		);		
	}

	public function setSynchronizer(\MYOBSynchronizer $synchronizer)
	{
		$this->synchronizer = $synchronizer;
	}

	public function toJsonString()
	{
		$accarr = array(
			"Name" => $this->name,
			"DisplayID" => $this->displayId,
			"Classification" => $this->classification,
			"Type" => $this->type,
			"Description" => $this->description,
			"Number" => $this->number,
			"OpeningBalance" => $this->openingBalance,
			"CurrentBalance" => $this->currentBalance,
		);

		if ($this->taxCodeId) {
			$taxcode = MyobTaxCode::model()->findByPk($this->taxCodeId);
			if ($taxcode->uuid) {
				$accarr["TaxCode"] = array(
					"UID" => $taxcode->uuid,
				);
			}
		}


		/* this will force  MYOB to update the record */
		/* this section will only be added if company file of this record ( myob guid) is same as the current login one */
		if ($this->myob_uuid && $this->myob_row_version && $this->myob_guid_uuid == trim(Yii::app()->session['myob_guid_uuid'])) {
			$accarr["UID"] = $this->uuid;
			$accarr["RowVersion"] = $this->row_version;
		}


		return json_encode($accarr);
	}

	public function updateByMYOB(\MYOBResponse $response)
	{
		try {
			$taxcode = MyobTaxCode::model()->find(array('condition' => "uuid ='{$response->TaxCode['UID']}'"));
			Yii::app()->db->createCommand()
					->update('myob_accounts', array(
						'uuid' => $response->UID,
						'name' => $response->Name,
						'displayId' => $response->DisplayID,
						'classification' => $response->Classification,
						'type' => $response->Type,
						'number' => $response->Number,
						'description' => $response->Description,
						'taxCodeId' => $taxcode ? $taxcode->id : null,
						'openingBalance' => $response->OpeningBalance,
						'currentBalance' => $response->CurrentBalance,
						'row_version' => $response->RowVersion,
						'json_response' => '',
						'myob_guid_uuid' => Yii::app()->session['myob_guid'],
							), "id=$this->id" /* where condition */
			);
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true;
	}

	public function updateMYOBReferences(\MYOBResponse $response)
	{
		try {
			Yii::app()->db->createCommand()
					->update('myob_accounts', array(
						'uuid' => $response->UID,
						'myob_guid_uuid' => Yii::app()->session['myob_guid'],
						'row_version' => $response->RowVersion,
						'json_response' => null,
							), "id=$this->id" /* where condition */
			);
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true;
	}

	public static function createByMYOB(\MYOBResponse $response)
	{
		try {
			$taxcode = MyobTaxCode::model()->find(array('condition' => "uuid ='{$response->TaxCode['UID']}'"));
			Yii::app()->db->createCommand()
					->insert('myob_accounts', array(
						'uuid' => $response->UID,
						'name' => $response->Name,
						'displayId' => $response->DisplayID,
						'classification' => $response->Classification,
						'type' => $response->Type,
						'number' => $response->Number,
						'description' => $response->Description,
						'taxCodeId' => $taxcode ? $taxcode->id : null,
						'openingBalance' => $response->OpeningBalance,
						'currentBalance' => $response->CurrentBalance,
						'row_version' => $response->RowVersion,
						'json_response' => '',
						'myob_guid_uuid' => Yii::app()->session['myob_guid']
			));
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true;
	}

	public function reportMYOBSuccess(\MYOBResponse $response)
	{
		
	}

}
