<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class MyobSetting extends CFormModel {
	
	 
	const SUPERADMIN_LOGIN = 1;
	const ADMIN_LOGIN = 2;
	
	const ENVIRONMENT_SANDBOX_ACCOUNT = 1;
	const ENVIRONMENT_LIVE_ACCOUNT = 2;


	public	$login_scenario = 2;

	/**
	 * CurlHeader will be decided by this value
	 * environment can be either sandbox (development) or live ( actual account of client )
	 * @var int predefined constant value
	 */
	public $environment;


	public $api_key;
    public $api_secret;
    public $redirect_url;
    public $company_username;//this will be a part of the x-myobapi-cftoken
    public $company_paassword;//this will be a part of the x-myobapi-cftoken
    public $base_url;
	public $myob_guid_uuid;
	
	/* company name or guide name should be defined before sign in, 
	 * this will compare with retrived guides and if one of them match then allow to communicate with MYOB
	 * once this is set, cannot be changed
	 *  */
	public $myob_company_name;


	public $access_token_expires_in;//seconds


	public $cus_taxcode_id;
    public $cus_freight_taxcode_id;
	
	/**
	 * system to determine whether it updates products from MYOB or not 
	 */
    public $update_products_from_myob;
	public $prd_expns_accnt_id;
    public $prd_incm_accnt_id;
    public $prd_buying_taxcode_id;
	public $prd_buying_freight_taxcode_id;
	
    public $prd_selling_taxcode_id;
	 public $prd_selling_freight_taxcode_id;
    
    public $inv_taxcode_id;
	public $inv_freight_taxcode_id;
	
	public $po_taxcode_id;
	public $po_freight_taxcode_id;


	public $auto_send_invoice;
	public $auto_send_po;
	
	

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        $rules = array(			
            array('api_key, api_secret, redirect_url, api_url, api_scope, '
                . 'base_url, company_username, company_paassword, '
                . 'cus_taxcode_id, cus_freight_taxcode_id, prd_expns_accnt_id, '
                . 'prd_incm_accnt_id, prd_buying_taxcode_id, prd_selling_taxcode_id, '
                . 'inv_taxcode_id, auto_send_invoice, auto_send_po, inv_freight_taxcode_id, myob_guid_uuid, '
				. 'access_token_expires_in, access_code_url, access_token_url, environment, po_taxcode_id, po_freight_taxcode_id, '
				. 'prd_buying_freight_taxcode_id, prd_selling_freight_taxcode_id, update_products_from_myob, myob_company_name', 'safe'),
        );
		
		if ($this->login_scenario == self::SUPERADMIN_LOGIN) {
			/* these fields can only be seen for superadmin */
			$rules[] = array('api_key, api_secret, base_url, redirect_url, access_token_expires_in, environment','required');
		}
		
		return $rules;
		
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'api_key' => 'API Key',
            'api_secret' => 'API Secret',
            'redirect_url' => 'Redirect URL',          
            'access_token_expires_in'=>'Access Token Expires In ( Minutes )',
            'base_url' => 'Base URL',
            'company_username' => 'Company Username',
            'company_paassword'=>'Company Password',
			'myob_guid_uuid'=>'Guide Account',
            
            'cus_taxcode_id'=>'Tax Code',
            'cus_freight_taxcode_id'=>'Freight Tax Code',
			
			'update_products_from_myob' => 'Update products from MYOB',
            'prd_expns_accnt_id'=>'Expense Account',
            'prd_incm_accnt_id'=>'Income Account',
            'prd_buying_taxcode_id'=>'Buying Details Tax Code',
            'prd_selling_taxcode_id'=>'Selling Details Tax Code',
			
            'inv_taxcode_id'=>'Tax Code',
            'auto_send_invoice'=>'Automatically Send Invoice',
			'inv_freight_taxcode_id'=>'Freight Tax Code',		
			'po_taxcode_id'=>'Purchase Order Tax Code',
			'po_freight_taxcode_id'=>'Purchase Order Freight Tax Code',			
			
			'environment'=>'Environment',
			'auto_send_po'=>'Automatically Send Purchase Orders',
			
			'prd_buying_freight_taxcode_id'=>'Buying Details Freight Tax Code',
            'prd_selling_freight_taxcode_id'=>'Selling Details Freight Tax Code',
			
			'myob_company_name' => 'Company Name ( Guide )'
            
            
        );
    }

    public static function getSettings() {
        $model = new MyobSetting();
        $file = fopen("protected/filemodels/myobsettings.csv", "r");
        $propertyArr = array();
        while (!feof($file)) {
            $line = fgets($file);
            $pairs = explode('=>', $line);
            $propertyArr[$pairs[0]] = $pairs[1];
        }
        fclose($file);

        foreach ($model->attributeLabels() as $attr => $lbl) {
            $model->$attr = $propertyArr[$attr];
        }


        return $model;
    }
	
	public static function iscompanyRegisteredLocally() {
		$compnayName = trim(self::getSettings()->myob_company_name);
		$guide = MYOBGuide::model()->find("account_name = '$compnayName'");
		return $guide ? true : false;
	}

}
