<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class MyobSetting extends CFormModel {

    public $api_key;
    public $api_secret;
    public $redirect_url;
    public $api_url;
    public $api_scope;
    public $company_username;//this will be a part of the x-myobapi-cftoken
    public $company_paassword;//this will be a part of the x-myobapi-cftoken
    public $base_url;
    public $expire_in;


    public $cus_taxcode_id;
    public $cus_freight_taxcode_id;
    
    public $prd_expns_accnt_id;
    public $prd_incm_accnt_id;
    public $prd_buying_taxcode_id;
    public $prd_selling_taxcode_id;
    
    public $inv_taxcode_id;

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
            array('api_key, api_secret, redirect_url, api_url, api_scope, '
                . 'base_url, company_username, company_paassword, '
                . 'cus_taxcode_id, cus_freight_taxcode_id, prd_expns_accnt_id, '
                . 'prd_incm_accnt_id, prd_buying_taxcode_id, prd_selling_taxcode_id, '
                . 'inv_taxcode_id, expire_in', 'safe'),
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
            'api_key' => 'API Key',
            'api_secret' => 'API Secret',
            'redirect_url' => 'Redirect URL',
            'api_url' => 'API URL',
            'api_scope' => 'API Scope',
            'base_url' => 'Base URL',
            'company_username' => 'Company Username',
            'company_paassword'=>'Company Password',
            
            'cus_taxcode_id'=>'Tax Code',
            'cus_freight_taxcode_id'=>'Freight Tax Code',
            'prd_expns_accnt_id'=>'Expense Account',
            'prd_incm_accnt_id'=>'Income Account',
            'prd_buying_taxcode_id'=>'Buying Details Tax Code',
            'prd_selling_taxcode_id'=>'Selling Details Tax Code',
            'inv_taxcode_id'=>'Tax Code',
            'expire_in'=>'Session Expires in (Days)'
            
            
        );
    }

    public static function getSettings() {
        $model = new MyobSetting();
        $file = fopen("protected/filemodels/myobsettings.csv", "r");
        $propertyArr = array();
        while (!feof($file)) {
            $line = fgets($file);
            $pairs = explode('=>', $line);
            $propertyArr[$pairs[0]] = $pairs[1];
        }
        fclose($file);

        foreach ($model->attributeLabels() as $attr => $lbl) {
            $model->$attr = $propertyArr[$attr];
        }


        return $model;
    }

}
