<?php

/**
 * This is the model class for table "supplier".
 *
 * The followings are the available columns in table 'supplier':
 * @property integer $supsno
 * @property string $supsup
 * @property string $supsup_fref
 * @property string $supnam
 * @property string $supad1
 * @property string $supad2
 * @property string $supad3
 * @property string $suptown
 * @property string $supstate
 * @property string $suppostcode
 * @property integer $supcousno
 * @property integer $suptypsno
 * @property string $suptel
 * @property string $supfax
 * @property string $supemail
 * @property double $supmrate
 * @property string $supucdnew
 * @property string $supentddt
 * @property string $supenttime
 * @property string $supucdame
 * @property string $supameddt
 * @property string $supametime
 * @property string $myob_guid_uuid
 */
class MyobSupplier extends CActiveRecord implements MYOBSynchronizable
{

	public $importFile;

	/**
	 * Provide the logic to be synchronized this record in an API 
	 * @var MYOBSynchronizer concrete implementation of Synchronizer
	 */
	public $synchronizer;

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Supplier the static model class
	 */
	public static function model($className = __CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'myob_supplier';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('supnam,  supmrate', 'required'),
			array('supcousno, suptypsno, myobTaxCodeId,myobFreightTaxCodeId, myobExpsAccntId', 'numerical', 'integerOnly' => true),
			array('supmrate', 'numerical'),
			array('supsup, supsup_fref', 'length', 'max' => 50),
			array('supnam', 'length', 'max' => 80),
			array('supad1, supad2, supad3, suptown', 'length', 'max' => 40),
			array('supstate, supucdnew, supucdame', 'length', 'max' => 30),
			array('suppostcode', 'length', 'max' => 10),
			array('suptel, suptel2, suptel3, supfax', 'length', 'max' => 15),
			array('supemail', 'length', 'max' => 100),
			array('xeroContactID, orderingUsername, orderingPassword, supcontact', 'length', 'max' => 255),
			array('supad1, supad2, supad3,suptown, supstate, suppostcode,suptel, 
                supfax, supemail, supucdame, supsup_fref', 'default', 'value' => ''),
			array('orderingWebsite, supnotes, importFile', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('supsno, supsup, supsup_fref, supnam, supad1, supad2, supad3, suptown, supstate, suppostcode, supcousno, 
                suptypsno, suptel, supfax, supemail, supmrate, supucdnew, supentddt, supenttime, supucdame, 
                supameddt, supametime, xeroContactID, orderingWebsite, orderingUsername, orderingPassword, supcontact, supnotes', 'safe', 'on' => 'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRel' => array(self::BELONGS_TO, 'Country', 'supcousno'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'supsno' => 'ID',
			'supsup' => 'Suplier Code',
			'supsup_fref' => 'Supplier Reference',
			'supnam' => 'Supplier Name',
			'supad1' => 'Address',
			'supad2' => 'Address 2',
			'supad3' => 'Address 3',
			'supad4' => 'Address 4',
			'suptown' => 'Town',
			'supstate' => 'State',
			'suppostcode' => 'Postal Code',
			'supcousno' => 'Country',
			'suptypsno' => 'Suptypsno',
			'suptel' => 'Telephone',
			'suptel2' => 'Telephone #2',
			'suptel3' => 'Telephone #3',
			'supfax' => 'Fax',
			'supemail' => 'E-mail',
			'supmrate' => 'Mark-Up Rate(%)',
			'supucdnew' => 'Supucdnew',
			'supentddt' => 'Supentddt',
			'supenttime' => 'Supenttime',
			'supucdame' => 'Supucdame',
			'supameddt' => 'Supameddt',
			'supametime' => 'Supametime',
			'paymentDueInXDays' => 'Payments Due Dates',
			'supwww' => 'Website',
			'orderingWebsite' => 'Website',
			'orderingUsername' => 'Username',
			'orderingPassword' => 'Password',
			'supcontact' => 'Contact Name',
			'supnotes' => 'Notes',
			'myobTaxCodeId' => 'MYOB Tax Code',
			'myobFreightTaxCodeId' => 'MYOB Freight Tax Code',
			'myobExpsAccntId' => 'MYOB Expense Account'
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('supsno', $this->supsno);
		$criteria->compare('supsup', $this->supsup, true);
		$criteria->compare('supsup_fref', $this->supsup_fref, true);
		$criteria->compare('supnam', $this->supnam, true);
		$criteria->compare('supad1', $this->supad1, true);
		$criteria->compare('supad2', $this->supad2, true);
		$criteria->compare('supad3', $this->supad3, true);
		//$criteria->compare('suptown', $this->suptown, true);
		//$criteria->compare('supstate', $this->supstate, true);
		//$criteria->compare('suppostcode', $this->suppostcode, true);
		//$criteria->compare('supcousno', $this->supcousno);
		//$criteria->compare('suptypsno', $this->suptypsno);
		$criteria->compare('suptel', $this->suptel, true);
		//$criteria->compare('supfax', $this->supfax, true);
		$criteria->compare('supemail', $this->supemail, true);
		//$criteria->compare('supmrate', $this->supmrate);
		//$criteria->compare('supucdnew', $this->supucdnew, true);
		//$criteria->compare('supentddt', $this->supentddt, true);
		//$criteria->compare('supenttime', $this->supenttime, true);
		// $criteria->compare('supucdame', $this->supucdame, true);
		//$criteria->compare('supameddt', $this->supameddt, true);
		//$criteria->compare('supametime', $this->supametime, true);

		$criteria->compare('supcontact', $this->supcontact, true);
		//$criteria->compare('supnotes', $this->supnotes, true);
		//$criteria->compare('orderingWebsite', $this->orderingWebsite, true);
		//$criteria->compare('orderingUsername', $this->orderingUsername, true);
		//$criteria->compare('orderingPassword', $this->orderingPassword, true);
		//$criteria->order = 'supentddt desc';

		$originalQuery = $this->getCommandBuilder()->createFindCommand($this->getTableSchema(), $criteria)->getText();

		//here define the filter fields by exactly value
		$paramarr = array(
			'supsno =:' => $this->supsno
		);

		//here define the filter fields by like values
		$paramarrLike = array(
			'supsup LIKE :' => $this->supsup,
			'supsup_fref LIKE :' => $this->supsup_fref,
			'supnam LIKE :' => $this->supnam, 'supad1 LIKE :' => $this->supad1,
			'supad2 LIKE :' => $this->supad1, 'supad3 LIKE :' => $this->supad1,
			'suptel LIKE :' => $this->suptel, 'supemail LIKE :' => $this->supemail,
			'supcontact LIKE :' => $this->supcontact
		);

		//here we remove and replace Yii specific criterias
		//for exactly check
		foreach ($paramarr as $key => $value) {
			if (!empty($key)) {
				$position = strpos($originalQuery, $key);
				if ($position != false && $position >= 0) {
					$param = str_replace('=:', '', $key);
					$param .= "='$value'";
					$originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
				}
			}
		}

		//for like check

		foreach ($paramarrLike as $key => $value) {
			if (!empty($key)) {
				$position = strpos($originalQuery, $key);
				if ($position != false && $position >= 0) {
					$param = str_replace(':', '', $key);
					$param .= " '%$value%'";
					$originalQuery = substr_replace($originalQuery, $param, $position, strlen($key) + 4);
				}
			}
		}

		if (isset(Yii::app()->session['sup_expt_qry'])) {
			unset(Yii::app()->session['sup_expt_qry']);
		}


		Yii::app()->session['sup_expt_qry'] = $originalQuery;

		$pageSize = (int) GlobalVars::get('RecordsViewPerPage');

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
			'pagination' => array('pageSize' => $pageSize),
			'sort' => array(
				'defaultOrder' => 't.supsup desc',
			)
		));
	}

	public function getFullAddress()
	{
		$address = "";

		if (!empty($this->supad1))
			$address = $this->supad1;
		if (!empty($this->supad2))
			$address .= ", " . $this->supad2;

		if (!empty($this->supad3))
			$address .= ", " . $this->supad3;

		if (!empty($this->suptown))
			$address .= ", " . $this->suptown;

		if (!empty($this->supstate))
			$address .= ", " . $this->supstate;

		if (!empty($this->suppostcode))
			$address .= ", " . $this->suppostcode;

		return $address;
	}

	public function getTelFax()
	{
		$telfax = '';

		if (!empty($this->suptel))
			$telfax .= "Tel: " . $this->suptel;

		if (!empty($this->supfax))
			$telfax .= "<br>/Fax: " . $this->supfax;
		return $telfax;
	}

	public function getLink()
	{

		$html = "<div><table>";
		$html .= "<tr><th style='text-align:center;font-weight:bold;font-size:0.8em;'>Supplier</th></tr>";
		$html .= "<tr><td style='text-align:center'>" . CHtml::link($this->supnam, array('supplier/view', 'id' => $this->supsno)) . "</td></tr>";
		$html .= "</table></div>";

		return $html;
	}

	public function getMYOBError()
	{
		$obj = @unserialize($this->json_response); //In case the passed string is not unserializeable, supress  E_NOTICE 
		return $obj ? MYOBResponse::formatError($obj) : '';
	}

	public function myobLastModified()
	{
		return date('Y-m-d H:i:s', strtotime($this->supameddt . ' ' . $this->supametime));
	}

	/**
	 * @override
	 * Synchronize current record with MYOB
	 * @param MYOBApiConnector $myobConnector api connection
	 * @return boolean success true, otherwise false
	 */
	public function myobSynchronize(\MYOBApiConnector $myobConnector)
	{
		return $this->synchronizer->syncronize(); /* Hide the syncronizing logics in syncronizer object */
	}

	/**
	 * Report Error, can be seen at the record view and in the MYOB log
	 */
	public function reportMYOBError(\MYOBResponse $response)
	{
		try {
			Yii::app()->db->createCommand()
					->update('supplier', array(
						'json_response' => serialize($response),
							), "supsno=$this->supsno" /* where condition */
			);

			MYOBLog::writeLog(array(
				'table_name' => $this->tableName(),
				'table_reference_id' => $this->supsno,
				'log_type_id' => MYOBLog::LOG_TYPE_ERROR,
				'log_message' => serialize($response),
				'log_class' => $GLOBALS['MYOB_ERROR_CLASS'],
				'log_line' => $GLOBALS['MYOB_ERROR_LINE'],
			));
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}
	}

	public function setSynchronizer(\MYOBSynchronizer $synchronizer)
	{
		$this->synchronizer = $synchronizer;
	}

	public function toJsonString()
	{
		//required - TaxCode,FreightTaxCode

		$taxcode = $this->myobTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobTaxCodeId) : MyobTaxCode::model()->findByPk(MyobSetting::getSettings()->prd_buying_taxcode_id);
		$freighttaxcode = $this->myobFreightTaxCodeId ? MyobTaxCode::model()->findByPk($this->myobFreightTaxCodeId) : MyobTaxCode::model()->findByPk(MyobSetting::getSettings()->prd_buying_freight_taxcode_id);

		$taxcodeuuid = $taxcode ? $taxcode->uuid : null;
		$freightcodeuuid = $freighttaxcode ? $freighttaxcode->uuid : null;

		$dataArr = array(
			"CompanyName" => $this->supnam,
			"IsIndividual" => "false",
			"DisplayID" => $this->supsup,
			"IsActive" => "true",
			"BuyingDetails" => array(
				"TaxCode" => array(
					"UID" => $taxcodeuuid,
				),
				"FreightTaxCode" => array(
					"UID" => $freightcodeuuid,
				),
			)
		);

		/* this will force  MYOB to update the record */
		/* this section will only be added if company file of this record ( myob guid) is same as the current login one */
		if ($this->myob_uuid && $this->myob_row_version && $this->myob_guid_uuid == trim(Yii::app()->session['myob_guid_uuid'])) {
			$dataArr["UID"] = $this->myob_uuid;
			$dataArr["RowVersion"] = $this->myob_row_version;
		}

		$street = $this->supad1 . " " . $this->supad2 . " " . $this->supad3;
		$dataArr["Addresses"][] = array(
			"Location" => 1,
			"Street" => $street,
			"City" => $this->suptown,
			"State" => $this->supstate,
			"PostCode" => $this->suppostcode,
			"Country" => "Australia",
			"Phone1" => $this->suptel,
			"Phone2" => $this->suptel2,
			"Phone3" => $this->suptel3,
			"Fax" => $this->supfax,
			"Email" => $this->supemail,
			"ContactName" => $this->supcontact,
			"Salutation" => "Hello"
		);

		return json_encode($dataArr);
	}

	public function updateByMYOB(\MYOBResponse $response)
	{
		try {
			$dataArr = self::myobProductDataCore($response);
			$dataArr['supsup'] = $response->DisplayID;
			if (in_array($response->DisplayID, array(null, '', '*None'))) { /* MYOB DisplayID may contain with empty or *None value */
				$dataArr['supsup'] = $this->supsup ?: $this->supsno;
			}
			Yii::app()->db->createCommand()
					->update(
							'myob_supplier', $dataArr, "supsno=$this->supsno" /* where condition */
			);
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
	}

	public function updateMYOBReferences(\MYOBResponse $response)
	{
		try {
			Yii::app()->db->createCommand()
					->update('myob_supplier', array(
						'myob_uuid' => $response->UID,
						'myob_guid_uuid' => trim(Yii::app()->session['myob_guid_uuid']),
						'myob_row_version' => $response->RowVersion,
						'json_response' => null,
							), "supsno=$this->supsno" /* where condition */
			);
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true; /* if there is no exception this line will be reached, whether it's update the row or not (row is not updated means same data are there) */
	}

	public static function createByMYOB(\MYOBResponse $response)
	{
		try {
			$dataArr = self::myobProductDataCore($response);
			$dataArr['supsup'] = $response->DisplayID;
			$dataArr['supsup_fref'] = $response->DisplayID;
			$dataArr['supentddt'] = date('Y-m-d', strtotime($response->LastModified));
			$dataArr['supenttime'] = date('H:i:s', strtotime($response->LastModified));
			if (in_array($response->DisplayID, array(null, '', '*None'))) {
				$dataArr['supsup'] = time();
				$dataArr['supsup_fref'] = time();
			}
			if (Yii::app()->db->createCommand()
							->insert('myob_supplier', $dataArr)) {
				$lastInsertID = Yii::app()->db->getLastInsertID();
				Yii::app()->db->createCommand("UPDATE myob_supplier SET supsup = supsno, supsup_fref = supsno WHERE supsno = '{$lastInsertID}'")->execute();
			}
		} catch (Exception $e) {
			throw new Exception($e->getMessage(), $e->getCode());
		}

		return true;
	}

	/**
	 * Encapsulate supplier data creation from MYOB response
	 * @return array key,value pairs represent this data table
	 */
	static function myobProductDataCore(\MYOBResponse $response)
	{
		$addressArr = $response->Addresses;
		$buyingDetail = $response->BuyingDetails;



		if ($expensesAccUID = $buyingDetail["ExpenseAccount"]["UID"]) {
			$expensesAccRaw = Yii::app()->db->createCommand()->select('id')->from('myob_accounts')->where('uuid=:UID', array(':UID' => $expensesAccUID,))->queryRow();
		}

		if ($taxCodeUID = $buyingDetail["TaxCode"]["UID"]) {
			$taxCodeUIDRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $taxCodeUID,))->queryRow();
		}

		if ($freightTaxCodeUID = $buyingDetail["FreightTaxCode"]["UID"]) {
			$freightTaxCodeUIDRaw = Yii::app()->db->createCommand()->select('id')->from('myob_tax_codes')->where('uuid=:UID', array(':UID' => $freightTaxCodeUID,))->queryRow();
		}

		return array(
			'supnam' => (boolval($response->IsIndividual) ? ($response->FirstName . ' ' . $response->LastName) : $response->CompanyName),
			'supsup' => $response->DisplayID,
			'supad1' => $addressArr[0]["Street"],
			'supad2' => '', /* because of MYOB doesn't have add2 add3 feields but only street for all, just replace them with empty */
			'supad3' => '',
			'suptown' => $addressArr[0]["City"],
			'supstate' => $addressArr[0]["State"],
			'suppostcode' => $addressArr[0]["PostCode"],
			'suptel' => $addressArr[0]["Phone1"],
			'suptel2' => $addressArr[0]["Phone2"],
			'suptel3' => $addressArr[0]["Phone3"],
			'supfax' => $addressArr[0]["Fax"],
			'supemail' => $addressArr[0]["Email"],
			'supcontact' => $addressArr[0]["ContactName"],
			'myobExpsAccntId' => isset($expensesAccRaw) ? $expensesAccRaw['id'] : null,
			'myobTaxCodeId' => isset($taxCodeUIDRaw) ? $taxCodeUIDRaw['id'] : null,
			'myobFreightTaxCodeId' => isset($freightTaxCodeUIDRaw) ? $freightTaxCodeUIDRaw['id'] : null,
			'myob_uuid' => $response->UID,
			'myob_row_version' => $response->RowVersion,
			'myob_guid_uuid' => Yii::app()->session['myob_guid_uuid'],
			'json_response' => null,
			'supameddt' => date('Y-m-d'),
			'supametime' => date("H:i:s")
		);
	}

	public function reportMYOBSuccess(\MYOBResponse $response)
	{
		
	}

}
