<?php

/**
 * This is the model class for table "other_cost_types".
 *
 * The followings are the available columns in table 'other_cost_types':
 * @property integer $id
 * @property string $name
 * @property integer $created_by
 * @property string $created_date
 */
class OtherCostType extends CActiveRecord {
    public $cost_group_name_search;

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return OtherCostType the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'other_cost_types';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('created_by, other_cost_group_id', 'numerical', 'integerOnly' => true),
            array('name', 'required'),
            array('default_cost', 'numerical'),
            array('name', 'length', 'max' => 255),
            array('created_date,devide_by_qty', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, name, created_by, created_date', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
             'cost_group_rel'=>array(self::BELONGS_TO, 'OtherCostGroup', 'other_cost_group_id'), 
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'name' => 'Name',
            'created_by' => 'Created By',
            'created_date' => 'Created Date',
            'default_cost'=>'Default Cost',
            'devide_by_qty'=>'Divide By Quantity',
            'other_cost_group_id'=>'Other Cost Group',
            'cost_group_name_search'=>'Other Cost Group',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('name', $this->name, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_date', $this->created_date, true);
        $criteria->compare('cost_group_rel.name', $this->cost_group_name_search, true);
        $criteria->compare('devide_by_qty', $this->devide_by_qty);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
            'sort' => array(
                'defaultOrder' => 'name asc',
            )
        ));
    }

}
