<?php

/**
 * LoginForm class.
 * LoginForm is the data structure for keeping
 * user login form data. It is used by the 'login' action of 'SiteController'.
 */
class PDFGenerator extends CFormModel {

    public $author = 'Aranxa';
    public $title;
    public $subject;
    public $CUZ_PDF_HEADER_LOGO;
    public $CUZ_PDF_HEADER_LOGO_WIDTH;
    public $CUZ_HEADER_TITLE = null;
    public $CUZ_HEADER_TEXT = null;
    public $headerFont = array();
    public $footerFont = array();
    public $CUZ_PDF_MARGIN_TOP;
    public $CUZ_PDF_MARGIN_RIGHT;
    public $CUZ_PDF_MARGIN_LEFT;
    public $CUZ_PDF_MARGIN_BOTTOM;
    public $CUZ_PDF_MARGIN_HEADER;
    public $CUZ_PDF_MARGIN_FOOTER;
    public $AUTO_PAGE_BREAK = true;
    public $FONT_FAMILY = 'helvetica';
    public $FONT_STYLE = '';
    public $FONT_SIZE = 8;
    public $FONT_FILE = 'helvetica,Arial, sans-serif';
    public $textColorRGB = array(0, 0, 0);

    public function __construct() {
        $pdf = Yii::createComponent('application.extensions.tcpdf.ETcPdf', 'P', 'cm', 'A4', true, 'UTF-8');

        $this->CUZ_PDF_HEADER_LOGO = PDF_HEADER_LOGO;
        $this->CUZ_PDF_HEADER_LOGO_WIDTH = PDF_HEADER_LOGO_WIDTH;

        $this->headerFont = Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN);
        $this->footerFont = Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA);

        $this->CUZ_PDF_MARGIN_LEFT = PDF_MARGIN_LEFT;
        $this->CUZ_PDF_MARGIN_TOP = PDF_MARGIN_TOP;
        $this->CUZ_PDF_MARGIN_RIGHT = PDF_MARGIN_RIGHT;
        $this->CUZ_PDF_MARGIN_BOTTOM = PDF_MARGIN_BOTTOM;
    }

    /**
     * Declares the validation rules.
     * The rules state that username and password are required,
     * and password needs to be authenticated.
     */
    public function rules() {
        return array(
        );
    }

    /**
     * Declares attribute labels.
     */
    public function attributeLabels() {
        return array(
        );
    }

    public function createPDF($html, $output = array('type' => 'I', 'filename'=>'aranxa'), $pdfinfo = array('title' => 'Aranxa PDF', 'subject' => 'PDF')) {
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);


        spl_autoload_register(array('YiiBase', 'autoload'));

// set document information
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor($this->author);
        $pdf->SetTitle($pdfinfo[0]);
        $pdf->SetSubject($pdfinfo[1]);
// set default header data



        $pdf->SetHeaderData($this->CUZ_PDF_HEADER_LOGO, $this->CUZ_PDF_HEADER_LOGO_WIDTH, $this->CUZ_HEADER_TITLE, $this->CUZ_HEADER_TEXT);

        $pdf->setHeaderFont($this->headerFont);
        $pdf->setFooterFont($this->footerFont);
        $pdf->SetMargins($this->CUZ_PDF_MARGIN_LEFT, $this->CUZ_PDF_MARGIN_TOP, $this->CUZ_PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin($this->CUZ_PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin($this->CUZ_PDF_MARGIN_FOOTER);
        $pdf->SetAutoPageBreak($this->AUTO_PAGE_BREAK, $this->CUZ_PDF_MARGIN_BOTTOM);
        $pdf->SetFont($this->FONT_FAMILY, $this->FONT_STYLE, $this->FONT_SIZE, $this->FONT_FILE);
        $pdf->SetTextColor($this->textColorRGB[0], $this->textColorRGB[1], $this->textColorRGB[2]);
        $pdf->AddPage();
        
        $pdf->writeHTML($html, true, false, true, false, '');

        $pdf->lastPage();
        
        //Close and output PDF document
        $pdf->Output($output['filename'] . ".pdf", $output['type']);
        //Yii::app()->end();
    }

}
