<?php

/**
 * This is the model class for table "pd_sub_jobs".
 *
 * The followings are the available columns in table 'pd_sub_jobs':
 * @property integer $id
 * @property integer $jobId
 * @property string $PDSubJobNum
 * @property string $PDSubJobName
 * @property string $dueDate
 * @property string $followUpDate
 * @property string $createdDate
 * @property integer $createdBy
 */
class PDSubJob extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return PDSubJob the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'pd_sub_jobs';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('jobId, createdBy', 'numerical', 'integerOnly' => true),
            array('PDSubJobNum, PDSubJobName', 'length', 'max' => 100),
            array('dueDate, followUpDate, createdDate', 'safe'),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('id, jobId, PDSubJobNum, PDSubJobName, dueDate, followUpDate, createdDate, createdBy', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'job' => array(self::BELONGS_TO, 'Jobs', 'jobId'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'jobId' => 'Job',
            'PDSubJobNum' => 'Sub Job Number',
            'PDSubJobName' => 'Sub Job Name',
            'dueDate' => 'Due Date',
            'followUpDate' => 'Follow Up Date',
            'createdDate' => 'Created Date',
            'createdBy' => 'Created By',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('jobId', $this->jobId);
        $criteria->compare('PDSubJobNum', $this->PDSubJobNum, true);
        $criteria->compare('PDSubJobName', $this->PDSubJobName, true);
        $criteria->compare('dueDate', $this->dueDate, true);
        $criteria->compare('followUpDate', $this->followUpDate, true);
        $criteria->compare('createdDate', $this->createdDate, true);
        $criteria->compare('createdBy', $this->createdBy);

        $pageSize = (int) GlobalVars::get('RecordsViewPerPage');

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination' => array('pageSize' => $pageSize),
        ));
    }

}