<?php

/**
 * This is the model class for table "pd_sub_job_details".
 *
 * The followings are the available columns in table 'pd_sub_job_details':
 * @property integer $id
 * @property integer $PDSubJobId
 * @property integer $workorderId
 * @property integer $workorderDetailsId
 * @property integer $jobProductDecorationId
 */
class PDSubJobDetail extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PDSubJobDetail the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'pd_sub_job_details';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('PDSubJobId, workorderId, workorderDetailsId, jobProductDecorationId, activityFlowId', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, PDSubJobId, workorderId, workorderDetailsId, jobProductDecorationId', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'PDSubJobId' => 'Pdsub Job',
			'workorderId' => 'Workorder',
			'workorderDetailsId' => 'Workorder Details',
			'jobProductDecorationId' => 'Job Product Decoration',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('PDSubJobId',$this->PDSubJobId);
		$criteria->compare('workorderId',$this->workorderId);
		$criteria->compare('workorderDetailsId',$this->workorderDetailsId);
		$criteria->compare('jobProductDecorationId',$this->jobProductDecorationId);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}